/*
 * Decompiled with CFR 0.152.
 */
package com.swirlds.state;

import com.hedera.pbj.runtime.Codec;
import com.hedera.pbj.runtime.io.buffer.Bytes;
import com.swirlds.state.binary.MerkleProof;
import com.swirlds.state.binary.QueueState;
import edu.umd.cs.findbugs.annotations.NonNull;
import edu.umd.cs.findbugs.annotations.Nullable;
import java.util.List;
import org.hiero.base.crypto.Hash;

public interface BinaryState {
    default public <V> long getQueueElementPath(int stateId, @NonNull V expectedValue, @NonNull Codec<V> valueCodec) {
        return this.getQueueElementPath(stateId, valueCodec.toBytes(expectedValue));
    }

    default public <V> long getKvPath(int stateId, @NonNull V key, @NonNull Codec<V> keyCodec) {
        return this.getKvPath(stateId, keyCodec.toBytes(key));
    }

    public Hash getHashForPath(long var1);

    public MerkleProof getMerkleProof(long var1);

    public long getSingletonPath(int var1);

    public long getQueueElementPath(int var1, @NonNull Bytes var2);

    public long getKvPath(int var1, @NonNull Bytes var2);

    @Nullable
    public Bytes getKv(int var1, @NonNull Bytes var2);

    @Nullable
    public Bytes getSingleton(int var1);

    public QueueState getQueueState(int var1);

    public Bytes peekQueueHead(int var1);

    public Bytes peekQueueTail(int var1);

    public Bytes peekQueue(int var1, int var2);

    public List<Bytes> getQueueAsList(int var1);

    public void updateSingleton(int var1, @NonNull Bytes var2);

    public void removeSingleton(int var1);

    public void updateKv(int var1, @NonNull Bytes var2, @Nullable Bytes var3);

    public void removeKv(int var1, @NonNull Bytes var2);

    public void pushQueue(int var1, @NonNull Bytes var2);

    @Nullable
    public Bytes popQueue(int var1);

    public void removeQueue(int var1);
}

