/*
 * Decompiled with CFR 0.152.
 */
package org.hiero.consensus.gossip.impl.gossip.shadowgraph;

import com.swirlds.logging.legacy.LogMarker;
import com.swirlds.metrics.api.Metrics;
import edu.umd.cs.findbugs.annotations.NonNull;
import edu.umd.cs.findbugs.annotations.Nullable;
import java.util.ArrayDeque;
import java.util.ArrayList;
import java.util.Collection;
import java.util.Collections;
import java.util.HashMap;
import java.util.HashSet;
import java.util.Iterator;
import java.util.LinkedList;
import java.util.List;
import java.util.Map;
import java.util.Objects;
import java.util.Set;
import java.util.function.Predicate;
import java.util.stream.Collectors;
import org.apache.logging.log4j.LogManager;
import org.apache.logging.log4j.Logger;
import org.apache.logging.log4j.util.Supplier;
import org.hiero.base.Clearable;
import org.hiero.base.crypto.Hash;
import org.hiero.consensus.event.IntakeEventCounter;
import org.hiero.consensus.gossip.impl.gossip.shadowgraph.InsertableStatus;
import org.hiero.consensus.gossip.impl.gossip.shadowgraph.ReservedEventWindow;
import org.hiero.consensus.gossip.impl.gossip.shadowgraph.ShadowEvent;
import org.hiero.consensus.gossip.impl.gossip.shadowgraph.ShadowgraphInsertionException;
import org.hiero.consensus.gossip.impl.gossip.shadowgraph.ShadowgraphMetrics;
import org.hiero.consensus.gossip.impl.gossip.shadowgraph.ShadowgraphReservation;
import org.hiero.consensus.model.event.EventDescriptorWrapper;
import org.hiero.consensus.model.event.PlatformEvent;
import org.hiero.consensus.model.hashgraph.EventWindow;

public class Shadowgraph
implements Clearable {
    private static final Logger logger = LogManager.getLogger(Shadowgraph.class);
    public static final int NO_RESERVATION = -1;
    private final HashMap<Hash, ShadowEvent> hashToShadowEvent;
    private final Map<Long, Set<ShadowEvent>> indicatorToShadowEvent;
    private final HashSet<ShadowEvent> tips;
    private long oldestUnexpiredIndicator;
    private final LinkedList<ShadowgraphReservation> reservationList;
    private final ShadowgraphMetrics metrics;
    private final int numberOfNodes;
    private EventWindow eventWindow;
    private final IntakeEventCounter intakeEventCounter;

    public Shadowgraph(@NonNull Metrics metrics, int numberOfNodes, @NonNull IntakeEventCounter intakeEventCounter) {
        this.metrics = new ShadowgraphMetrics(metrics);
        this.numberOfNodes = numberOfNodes;
        this.intakeEventCounter = Objects.requireNonNull(intakeEventCounter);
        this.tips = new HashSet();
        this.hashToShadowEvent = new HashMap();
        this.indicatorToShadowEvent = new HashMap<Long, Set<ShadowEvent>>();
        this.reservationList = new LinkedList();
    }

    private void startWithEventWindow(@NonNull EventWindow eventWindow) {
        this.eventWindow = eventWindow;
        this.oldestUnexpiredIndicator = eventWindow.expiredThreshold();
        logger.info(LogMarker.STARTUP.getMarker(), "Shadowgraph starting from expiration threshold {}", (Object)eventWindow.expiredThreshold());
    }

    public synchronized void clear() {
        this.eventWindow = null;
        this.oldestUnexpiredIndicator = 1L;
        this.disconnectShadowEvents();
        this.tips.clear();
        this.hashToShadowEvent.clear();
        this.indicatorToShadowEvent.clear();
        this.reservationList.clear();
    }

    private void disconnectShadowEvents() {
        for (ShadowEvent shadow : this.hashToShadowEvent.values()) {
            shadow.clear();
        }
    }

    @NonNull
    public synchronized ReservedEventWindow reserve() {
        long thresholdWeWantToReserve;
        if (this.reservationList.isEmpty()) {
            return new ReservedEventWindow(this.eventWindow, this.newReservation());
        }
        ShadowgraphReservation lastReservation = this.reservationList.getLast();
        long previouslyReservedThreshold = lastReservation.getReservedThreshold();
        if (previouslyReservedThreshold == (thresholdWeWantToReserve = this.eventWindow.expiredThreshold())) {
            lastReservation.incrementReservations();
            return new ReservedEventWindow(this.eventWindow, lastReservation);
        }
        return new ReservedEventWindow(this.eventWindow, this.newReservation());
    }

    @NonNull
    public synchronized EventWindow getEventWindow() {
        return this.eventWindow;
    }

    @Deprecated(forRemoval=true)
    public synchronized boolean isHashInGraph(Hash hash) {
        return this.hashToShadowEvent.containsKey(hash);
    }

    public Set<ShadowEvent> findAncestors(Iterable<ShadowEvent> events, Predicate<ShadowEvent> predicate) {
        HashSet<ShadowEvent> ancestors = new HashSet<ShadowEvent>();
        for (ShadowEvent event : events) {
            Predicate<ShadowEvent> isValidShadowEvent = e -> !ancestors.contains(e) && !this.expired(e.getPlatformEvent().getDescriptor()) && predicate.test((ShadowEvent)((Object)e));
            this.findAncestors(ancestors, event, isValidShadowEvent);
        }
        return ancestors;
    }

    private void findAncestors(HashSet<ShadowEvent> ancestors, ShadowEvent event, Predicate<ShadowEvent> predicate) {
        ArrayDeque<ShadowEvent> todoStack = new ArrayDeque<ShadowEvent>();
        for (ShadowEvent parent : event.getAllParents()) {
            todoStack.push(parent);
        }
        while (!todoStack.isEmpty()) {
            ShadowEvent testEvent = (ShadowEvent)((Object)todoStack.pop());
            if (this.expired(testEvent.getPlatformEvent().getDescriptor()) || !predicate.test(testEvent) || !ancestors.add(testEvent)) continue;
            for (ShadowEvent parent : testEvent.getAllParents()) {
                todoStack.push(parent);
            }
        }
    }

    @Deprecated(forRemoval=true)
    @NonNull
    public synchronized Collection<PlatformEvent> findByAncientIndicator(long lowerBound, long upperBound, @NonNull Predicate<PlatformEvent> predicate) {
        ArrayList<PlatformEvent> result = new ArrayList<PlatformEvent>();
        if (lowerBound >= upperBound) {
            return result;
        }
        for (long indicator = lowerBound; indicator < upperBound; ++indicator) {
            this.indicatorToShadowEvent.getOrDefault(indicator, Collections.emptySet()).stream().map(shadowEvent -> shadowEvent.getPlatformEvent()).filter(predicate).forEach(result::add);
        }
        return result;
    }

    public synchronized void updateEventWindow(@NonNull EventWindow eventWindow) {
        if (this.eventWindow == null) {
            this.startWithEventWindow(eventWindow);
            return;
        }
        long expiredThreshold = eventWindow.expiredThreshold();
        if (expiredThreshold < eventWindow.expiredThreshold()) {
            logger.error(LogMarker.EXCEPTION.getMarker(), "A request to expire below {} is less than request of {}. Ignoring expiration request", (Object)expiredThreshold, (Object)eventWindow.expiredThreshold());
            return;
        }
        this.eventWindow = eventWindow;
        long oldestReservedIndicator = this.pruneReservationList();
        if (oldestReservedIndicator == -1L) {
            oldestReservedIndicator = eventWindow.expiredThreshold();
        }
        this.metrics.updateIndicatorsWaitingForExpiry(eventWindow.expiredThreshold() - oldestReservedIndicator);
        long minimumIndicatorToKeep = Math.min(eventWindow.expiredThreshold(), oldestReservedIndicator);
        while (this.oldestUnexpiredIndicator < minimumIndicatorToKeep) {
            Set<ShadowEvent> shadowsToExpire = this.indicatorToShadowEvent.remove(this.oldestUnexpiredIndicator);
            if (shadowsToExpire != null) {
                shadowsToExpire.forEach(this::expire);
            }
            ++this.oldestUnexpiredIndicator;
        }
    }

    private long pruneReservationList() {
        long oldestReservedIndicator = -1L;
        Iterator iterator = this.reservationList.iterator();
        while (iterator.hasNext()) {
            ShadowgraphReservation reservation = (ShadowgraphReservation)iterator.next();
            long reservedIndicator = reservation.getReservedThreshold();
            if (reservation.getReservationCount() > 0) {
                oldestReservedIndicator = reservation.getReservedThreshold();
                break;
            }
            if (reservedIndicator >= this.eventWindow.expiredThreshold()) break;
            iterator.remove();
        }
        return oldestReservedIndicator;
    }

    private void expire(ShadowEvent shadow) {
        this.hashToShadowEvent.remove(shadow.getBaseHash());
        shadow.clear();
        this.tips.remove((Object)shadow);
    }

    @Nullable
    public synchronized ShadowEvent shadow(@Nullable EventDescriptorWrapper e) {
        if (e == null) {
            return null;
        }
        return this.hashToShadowEvent.get(e.hash());
    }

    public synchronized List<ShadowEvent> shadows(List<Hash> hashes) {
        Objects.requireNonNull(hashes);
        ArrayList<ShadowEvent> shadows = new ArrayList<ShadowEvent>(hashes.size());
        for (Hash hash : hashes) {
            shadows.add(this.shadow(hash));
        }
        return shadows;
    }

    @Nullable
    public synchronized PlatformEvent hashgraphEvent(@Nullable Hash h) {
        ShadowEvent shadow = this.shadow(h);
        if (shadow == null) {
            return null;
        }
        return shadow.getPlatformEvent();
    }

    @NonNull
    public synchronized List<ShadowEvent> getTips() {
        return new ArrayList<ShadowEvent>(this.tips);
    }

    public synchronized boolean addEvent(@NonNull PlatformEvent event) throws ShadowgraphInsertionException {
        if (this.eventWindow == null) {
            throw new IllegalStateException("Initial event window not set");
        }
        Objects.requireNonNull(event);
        try {
            InsertableStatus status = this.insertable(event);
            if (status == InsertableStatus.INSERTABLE) {
                int tipsBefore = this.tips.size();
                ShadowEvent s = this.insert(event);
                this.tips.add(s);
                this.tips.remove(s.getSelfParent());
                if (this.numberOfNodes > 0 && this.tips.size() > this.numberOfNodes && this.tips.size() > tipsBefore) {
                    Supplier[] supplierArray = new Supplier[7];
                    supplierArray[0] = this.tips::size;
                    supplierArray[1] = () -> event;
                    supplierArray[2] = () -> event.getSelfParent() == null;
                    supplierArray[3] = () -> s.getSelfParent() == null;
                    supplierArray[4] = () -> this.eventWindow.expiredThreshold();
                    supplierArray[5] = () -> this.oldestUnexpiredIndicator;
                    supplierArray[6] = () -> this.tips.stream().map(sh -> sh.getPlatformEvent().getDescriptor().toString()).collect(Collectors.joining(","));
                    logger.info(LogMarker.SYNC_INFO.getMarker(), "tips size is {} after adding {}. Esp null:{} Ssp null:{}\neventWindow.getExpiredThreshold: {} oldestUnexpiredIndicator: {}\ncurrent tips:{}", supplierArray);
                }
                boolean bl = true;
                return bl;
            }
            if (status == InsertableStatus.EXPIRED_EVENT) {
                logger.error(LogMarker.EXCEPTION.getMarker(), "`addEvent`: did not insert, status is {} for event {}, oldestUnexpiredIndicator = {}", (Object)status, (Object)event, (Object)this.oldestUnexpiredIndicator);
                boolean bl = false;
                return bl;
            }
            if (status == InsertableStatus.NULL_EVENT) {
                throw new ShadowgraphInsertionException(String.format("`addEvent`: did not insert, status is %s", new Object[]{status}), status);
            }
            throw new ShadowgraphInsertionException(String.format("`addEvent`: did not insert, status is %s for event %s, oldestUnexpiredIndicator = %s", new Object[]{status, event, this.oldestUnexpiredIndicator}), status);
        }
        finally {
            this.intakeEventCounter.eventExitedIntakePipeline(event.getSenderId());
        }
    }

    private ShadowgraphReservation newReservation() {
        ShadowgraphReservation reservation = new ShadowgraphReservation(this.eventWindow.expiredThreshold());
        this.reservationList.addLast(reservation);
        return reservation;
    }

    private ShadowEvent shadow(Hash h) {
        return this.hashToShadowEvent.get(h);
    }

    @Nullable
    public synchronized PlatformEvent getEvent(@Nullable Hash hash) {
        ShadowEvent shadowEvent = this.hashToShadowEvent.get(hash);
        return shadowEvent == null ? null : shadowEvent.getPlatformEvent();
    }

    @NonNull
    private ShadowEvent insert(@NonNull PlatformEvent event) {
        ArrayList<ShadowEvent> allParents = new ArrayList<ShadowEvent>(event.getAllParents().size());
        for (EventDescriptorWrapper parent : event.getAllParents()) {
            ShadowEvent shadow = this.shadow(parent);
            boolean known = shadow != null;
            boolean expired = this.expired(parent);
            if (!known && !expired) {
                logger.info(LogMarker.STARTUP.getMarker(), "Missing non-expired other parent for {}", (Object)event);
            }
            if (!known) continue;
            allParents.add(shadow);
        }
        ShadowEvent se = new ShadowEvent(event, allParents);
        this.hashToShadowEvent.put(se.getBaseHash(), se);
        long ancientIndicator = event.getBirthRound();
        if (!this.indicatorToShadowEvent.containsKey(ancientIndicator)) {
            this.indicatorToShadowEvent.put(ancientIndicator, new HashSet());
        }
        this.indicatorToShadowEvent.get(ancientIndicator).add(se);
        return se;
    }

    private boolean expired(EventDescriptorWrapper event) {
        return event.birthRound() < this.oldestUnexpiredIndicator;
    }

    @NonNull
    private InsertableStatus insertable(@NonNull PlatformEvent e) {
        if (this.shadow(e.getDescriptor()) != null) {
            return InsertableStatus.DUPLICATE_SHADOW_EVENT;
        }
        if (this.expired(e.getDescriptor())) {
            return InsertableStatus.EXPIRED_EVENT;
        }
        return InsertableStatus.INSERTABLE;
    }
}

