/*
 * Decompiled with CFR 0.152.
 */
package org.hiero.consensus.gossip.impl.network;

import java.util.Objects;
import org.hiero.consensus.gossip.impl.network.IpAddressStatus;

public class ExternalIpAddress {
    public static final ExternalIpAddress NO_IP = new ExternalIpAddress(IpAddressStatus.NO_IP_FOUND, "");
    public static final ExternalIpAddress UPNP_DISABLED = new ExternalIpAddress(IpAddressStatus.ROUTER_UPNP_DISABLED, "");
    private final IpAddressStatus status;
    private final String ipAddress;

    ExternalIpAddress(IpAddressStatus status, String ipAddress) {
        this.status = status;
        this.ipAddress = ipAddress;
    }

    ExternalIpAddress(String ipAddress) {
        this(IpAddressStatus.IP_FOUND, ipAddress);
    }

    public IpAddressStatus getStatus() {
        return this.status;
    }

    public String getIpAddress() {
        return this.ipAddress;
    }

    public String toString() {
        if (this.status == IpAddressStatus.IP_FOUND) {
            return this.getIpAddress();
        }
        return this.status.name();
    }

    public boolean equals(Object other) {
        if (this == other) {
            return true;
        }
        if (other == null || this.getClass() != other.getClass()) {
            return false;
        }
        ExternalIpAddress that = (ExternalIpAddress)other;
        return this.status == that.status && Objects.equals(this.ipAddress, that.ipAddress);
    }

    public int hashCode() {
        return Objects.hash(new Object[]{this.status, this.ipAddress});
    }
}

