/*
 * Decompiled with CFR 0.152.
 */
package org.hiero.consensus.gossip.impl.network;

import com.swirlds.config.api.Configuration;
import com.swirlds.logging.legacy.LogMarker;
import edu.umd.cs.findbugs.annotations.NonNull;
import java.io.Closeable;
import java.io.IOException;
import java.security.KeyStoreException;
import java.security.NoSuchAlgorithmException;
import java.security.UnrecoverableKeyException;
import java.security.cert.CertificateException;
import java.util.List;
import java.util.Objects;
import javax.net.ssl.SSLException;
import org.apache.logging.log4j.LogManager;
import org.apache.logging.log4j.Logger;
import org.apache.logging.log4j.Marker;
import org.hiero.consensus.concurrent.utility.throttle.RateLimiter;
import org.hiero.consensus.exceptions.PlatformConstructionException;
import org.hiero.consensus.exceptions.ThrowableUtilities;
import org.hiero.consensus.gossip.impl.gossip.shadowgraph.SyncTimeoutException;
import org.hiero.consensus.gossip.impl.network.Connection;
import org.hiero.consensus.gossip.impl.network.PeerInfo;
import org.hiero.consensus.gossip.impl.network.connectivity.SocketFactory;
import org.hiero.consensus.gossip.impl.network.connectivity.TlsFactory;
import org.hiero.consensus.model.node.KeysAndCerts;
import org.hiero.consensus.model.node.NodeId;

public final class NetworkUtils {
    private static final Logger logger = LogManager.getLogger(NetworkUtils.class);

    private NetworkUtils() {
    }

    public static void close(Closeable ... closeables) {
        for (Closeable closeable : closeables) {
            try {
                if (closeable == null) continue;
                closeable.close();
            }
            catch (IOException | RuntimeException exception) {
                // empty catch block
            }
        }
    }

    public static void handleNetworkException(Exception e, Connection connection, RateLimiter socketExceptionRateLimiter) throws InterruptedException {
        String description;
        if (connection != null) {
            connection.disconnect();
            description = connection.getDescription();
        } else {
            description = null;
        }
        if (e instanceof InterruptedException) {
            InterruptedException ie = (InterruptedException)e;
            throw ie;
        }
        Marker marker = NetworkUtils.determineExceptionMarker(e);
        if (LogMarker.SOCKET_EXCEPTIONS.getMarker().equals((Object)marker)) {
            if (socketExceptionRateLimiter.requestAndTrigger()) {
                logger.warn(marker, "Connection broken: {}", (Object)description, (Object)e);
            } else {
                String formattedException = NetworkUtils.formatException(e);
                logger.warn(marker, "Connection broken: {} {}", (Object)description, (Object)formattedException);
            }
        } else {
            logger.error(LogMarker.EXCEPTION.getMarker(), "Connection broken: {}", (Object)description, (Object)e);
        }
    }

    public static Marker determineExceptionMarker(Exception e) {
        return ThrowableUtilities.isCausedByIOException((Exception)e) || ThrowableUtilities.isRootCauseSuppliedType((Throwable)e, SyncTimeoutException.class) || ThrowableUtilities.hasAnyCauseSuppliedType((Throwable)e, SSLException.class) ? LogMarker.SOCKET_EXCEPTIONS.getMarker() : LogMarker.EXCEPTION.getMarker();
    }

    public static String formatException(Throwable e) {
        if (e == null) {
            return "";
        }
        return "Caused by exception: " + e.getClass().getSimpleName() + " Message: " + e.getMessage() + " " + NetworkUtils.formatException(e.getCause());
    }

    @NonNull
    public static SocketFactory createSocketFactory(@NonNull NodeId selfId, @NonNull List<PeerInfo> peers, @NonNull KeysAndCerts ownKeysAndCerts, @NonNull Configuration configuration) {
        Objects.requireNonNull(selfId);
        Objects.requireNonNull(peers);
        Objects.requireNonNull(ownKeysAndCerts);
        Objects.requireNonNull(configuration);
        try {
            return new TlsFactory(ownKeysAndCerts.agrCert(), ownKeysAndCerts.agrKeyPair().getPrivate(), peers, selfId, configuration);
        }
        catch (IOException | KeyStoreException | NoSuchAlgorithmException | UnrecoverableKeyException | CertificateException e) {
            throw new PlatformConstructionException("A problem occurred while creating the SocketFactory", (Throwable)e);
        }
    }
}

