/*
 * Decompiled with CFR 0.152.
 */
package com.hedera.node.app.grpc.impl;

import com.hedera.pbj.runtime.io.buffer.BufferedData;
import com.hedera.pbj.runtime.io.buffer.Bytes;
import com.swirlds.metrics.api.Counter;
import com.swirlds.metrics.api.MetricConfig;
import com.swirlds.metrics.api.Metrics;
import edu.umd.cs.findbugs.annotations.NonNull;
import io.grpc.StatusRuntimeException;
import io.grpc.stub.ServerCalls;
import io.grpc.stub.StreamObserver;
import java.util.Objects;
import org.apache.logging.log4j.LogManager;
import org.apache.logging.log4j.Logger;
import org.hiero.consensus.metrics.SpeedometerMetric;

public abstract class MethodBase
implements ServerCalls.UnaryMethod<BufferedData, BufferedData> {
    private static final Logger logger = LogManager.getLogger(MethodBase.class);
    private static final int MAX_RESPONSE_SIZE = 0x200000;
    private static final String COUNTER_HANDLED_NAME_TPL = "%sHdl";
    private static final String COUNTER_HANDLED_DESC_TPL = "number of %s handled";
    private static final String COUNTER_RECEIVED_NAME_TPL = "%sRcv";
    private static final String COUNTER_RECEIVED_DESC_TPL = "number of %s received";
    private static final String COUNTER_FAILED_NAME_TPL = "%sFail";
    private static final String COUNTER_FAILED_DESC_TPL = "number of %s failed";
    private static final String SPEEDOMETER_HANDLED_NAME_TPL = "%sHdl_per_sec";
    private static final String SPEEDOMETER_HANDLED_DESC_TPL = "number of %s handled per second";
    private static final String SPEEDOMETER_RECEIVED_NAME_TPL = "%sRcv_per_sec";
    private static final String SPEEDOMETER_RECEIVED_DESC_TPL = "number of %s received per second";
    private static final ThreadLocal<BufferedData> BUFFER_THREAD_LOCAL = ThreadLocal.withInitial(() -> BufferedData.allocate((int)0x200000));
    protected final String serviceName;
    protected final String methodName;
    private final Counter callsReceivedCounter;
    private final Counter callsHandledCounter;
    private final Counter callsFailedCounter;
    private final SpeedometerMetric callsReceivedSpeedometer;
    private final SpeedometerMetric callsHandledSpeedometer;
    private final int maxMessageSize;

    MethodBase(@NonNull String serviceName, @NonNull String methodName, @NonNull Metrics metrics, int maxMessageSize) {
        this.serviceName = Objects.requireNonNull(serviceName);
        this.methodName = Objects.requireNonNull(methodName);
        this.callsHandledCounter = this.counter(metrics, COUNTER_HANDLED_NAME_TPL, COUNTER_HANDLED_DESC_TPL);
        this.callsReceivedCounter = this.counter(metrics, COUNTER_RECEIVED_NAME_TPL, COUNTER_RECEIVED_DESC_TPL);
        this.callsFailedCounter = this.counter(metrics, COUNTER_FAILED_NAME_TPL, COUNTER_FAILED_DESC_TPL);
        this.callsHandledSpeedometer = this.speedometer(metrics, SPEEDOMETER_HANDLED_NAME_TPL, SPEEDOMETER_HANDLED_DESC_TPL);
        this.callsReceivedSpeedometer = this.speedometer(metrics, SPEEDOMETER_RECEIVED_NAME_TPL, SPEEDOMETER_RECEIVED_DESC_TPL);
        this.maxMessageSize = maxMessageSize;
    }

    public void invoke(@NonNull BufferedData requestBuffer, @NonNull StreamObserver<BufferedData> responseObserver) {
        this.callsReceivedCounter.increment();
        this.callsReceivedSpeedometer.cycle();
        if (requestBuffer.length() > (long)this.maxMessageSize) {
            this.callsFailedCounter.increment();
            RuntimeException exception = new RuntimeException("More than " + this.maxMessageSize + " received");
            responseObserver.onError((Throwable)exception);
            return;
        }
        try {
            BufferedData responseBuffer = BUFFER_THREAD_LOCAL.get();
            responseBuffer.reset();
            Bytes requestBytes = requestBuffer.getBytes(0L, requestBuffer.length());
            this.handle(requestBytes, responseBuffer);
            responseBuffer.flip();
            responseObserver.onNext((Object)responseBuffer);
            responseObserver.onCompleted();
            this.callsHandledCounter.increment();
            this.callsHandledSpeedometer.cycle();
        }
        catch (Exception e) {
            if (!(e instanceof StatusRuntimeException)) {
                logger.error("Unexpected exception while handling a GRPC message", (Throwable)e);
            }
            this.callsFailedCounter.increment();
            responseObserver.onError((Throwable)e);
        }
    }

    protected abstract void handle(@NonNull Bytes var1, @NonNull BufferedData var2);

    @NonNull
    protected final Counter counter(@NonNull Metrics metrics, @NonNull String nameTemplate, @NonNull String descriptionTemplate) {
        String baseName = this.calculateBaseName();
        String name = String.format(nameTemplate, baseName);
        String desc = String.format(descriptionTemplate, baseName);
        return (Counter)metrics.getOrCreate((MetricConfig)new Counter.Config("app", name).withDescription(desc));
    }

    @NonNull
    protected final SpeedometerMetric speedometer(@NonNull Metrics metrics, @NonNull String nameTemplate, @NonNull String descriptionTemplate) {
        String baseName = this.calculateBaseName();
        String name = String.format(nameTemplate, baseName);
        String desc = String.format(descriptionTemplate, baseName);
        return (SpeedometerMetric)metrics.getOrCreate((MetricConfig)new SpeedometerMetric.Config("app", name).withDescription(desc));
    }

    private String calculateBaseName() {
        return this.serviceName.substring("proto.".length()).replace('.', ':') + ":" + this.methodName;
    }
}

