/*
 * Decompiled with CFR 0.152.
 */
package com.hedera.node.app.grpc.impl;

import com.hedera.node.app.grpc.impl.MethodBase;
import com.hedera.node.app.workflows.query.QueryWorkflow;
import com.hedera.pbj.runtime.io.buffer.BufferedData;
import com.hedera.pbj.runtime.io.buffer.Bytes;
import com.swirlds.metrics.api.Counter;
import com.swirlds.metrics.api.Metrics;
import edu.umd.cs.findbugs.annotations.NonNull;
import java.util.Objects;
import org.hiero.consensus.metrics.SpeedometerMetric;

public final class QueryMethod
extends MethodBase {
    private static final String COUNTER_ANSWERED_NAME_TPL = "%sSub";
    private static final String COUNTER_ANSWERED_DESC_TPL = "number of %s answered";
    private static final String SPEEDOMETER_ANSWERED_NAME_TPL = "%sSub_per_sec";
    private static final String SPEEDOMETER_ANSWERED_DESC_TPL = "number of %s answered per second";
    private final QueryWorkflow workflow;
    private final Counter queriesAnsweredCounter;
    private final SpeedometerMetric queriesAnsweredSpeedometer;

    public QueryMethod(@NonNull String serviceName, @NonNull String methodName, @NonNull QueryWorkflow workflow, @NonNull Metrics metrics, int maxMessageSize) {
        super(serviceName, methodName, metrics, maxMessageSize);
        this.workflow = Objects.requireNonNull(workflow);
        this.queriesAnsweredCounter = this.counter(metrics, COUNTER_ANSWERED_NAME_TPL, COUNTER_ANSWERED_DESC_TPL);
        this.queriesAnsweredSpeedometer = this.speedometer(metrics, SPEEDOMETER_ANSWERED_NAME_TPL, SPEEDOMETER_ANSWERED_DESC_TPL);
    }

    @Override
    protected void handle(@NonNull Bytes requestBuffer, @NonNull BufferedData responseBuffer) {
        this.workflow.handleQuery(requestBuffer, responseBuffer);
        this.queriesAnsweredCounter.increment();
        this.queriesAnsweredSpeedometer.cycle();
    }
}

