/*
 * Decompiled with CFR 0.152.
 */
package com.hedera.node.app.hints.impl;

import com.hedera.cryptography.hints.AggregationAndVerificationKeys;
import com.hedera.cryptography.hints.HintsLibraryBridge;
import com.hedera.node.app.hints.HintsLibrary;
import com.hedera.pbj.runtime.io.buffer.Bytes;
import edu.umd.cs.findbugs.annotations.NonNull;
import java.util.Arrays;
import java.util.Map;
import java.util.Objects;
import java.util.SortedMap;
import java.util.SplittableRandom;

public class HintsLibraryImpl
implements HintsLibrary {
    private static final SplittableRandom RANDOM = new SplittableRandom();
    private static final HintsLibraryBridge BRIDGE = HintsLibraryBridge.getInstance();
    public static final int VK_LENGTH = 1096;

    @Override
    public Bytes newCrs(short n) {
        return Bytes.wrap((byte[])BRIDGE.initCRS(n));
    }

    @Override
    public Bytes updateCrs(@NonNull Bytes crs, @NonNull Bytes entropy) {
        Objects.requireNonNull(crs);
        Objects.requireNonNull(entropy);
        return Bytes.wrap((byte[])BRIDGE.updateCRS(crs.toByteArray(), entropy.toByteArray()));
    }

    @Override
    public boolean verifyCrsUpdate(@NonNull Bytes oldCrs, @NonNull Bytes newCrs, @NonNull Bytes proof) {
        Objects.requireNonNull(oldCrs);
        Objects.requireNonNull(newCrs);
        Objects.requireNonNull(proof);
        return BRIDGE.verifyCRS(oldCrs.toByteArray(), newCrs.toByteArray(), proof.toByteArray());
    }

    @Override
    public Bytes newBlsPrivateKey() {
        byte[] randomBytes = new byte[32];
        RANDOM.nextBytes(randomBytes);
        byte[] key = BRIDGE.generateSecretKey(randomBytes);
        return key == null ? null : Bytes.wrap((byte[])key);
    }

    @Override
    public Bytes computeHints(@NonNull Bytes crs, @NonNull Bytes blsPrivateKey, int partyId, int n) {
        Objects.requireNonNull(blsPrivateKey);
        byte[] hints = BRIDGE.computeHints(crs.toByteArray(), blsPrivateKey.toByteArray(), partyId, n);
        return hints == null ? null : Bytes.wrap((byte[])hints);
    }

    @Override
    public boolean validateHintsKey(@NonNull Bytes crs, @NonNull Bytes hintsKey, int partyId, int n) {
        Objects.requireNonNull(crs);
        Objects.requireNonNull(hintsKey);
        return BRIDGE.validateHintsKey(crs.toByteArray(), hintsKey.toByteArray(), partyId, n);
    }

    @Override
    public AggregationAndVerificationKeys preprocess(@NonNull Bytes crs, @NonNull SortedMap<Integer, Bytes> hintsKeys, @NonNull SortedMap<Integer, Long> weights, int n) {
        Objects.requireNonNull(crs);
        Objects.requireNonNull(hintsKeys);
        Objects.requireNonNull(weights);
        if (!hintsKeys.keySet().equals(weights.keySet())) {
            throw new IllegalArgumentException("The number of hint keys and weights must be the same");
        }
        int[] parties = hintsKeys.keySet().stream().mapToInt(Integer::intValue).toArray();
        byte[][] hintsPublicKeys = (byte[][])Arrays.stream(parties).mapToObj(hintsKeys::get).map(Bytes::toByteArray).toArray(x$0 -> new byte[x$0][]);
        long[] weightsArray = Arrays.stream(parties).mapToLong(weights::get).toArray();
        return BRIDGE.preprocess(crs.toByteArray(), parties, hintsPublicKeys, weightsArray, n);
    }

    @Override
    public Bytes signBls(@NonNull Bytes message, @NonNull Bytes privateKey) {
        Objects.requireNonNull(message);
        Objects.requireNonNull(privateKey);
        byte[] signature = BRIDGE.signBls(message.toByteArray(), privateKey.toByteArray());
        return signature == null ? null : Bytes.wrap((byte[])signature);
    }

    @Override
    public boolean verifyBls(@NonNull Bytes crs, @NonNull Bytes signature, @NonNull Bytes message, @NonNull Bytes aggregationKey, int partyId) {
        Objects.requireNonNull(crs);
        Objects.requireNonNull(signature);
        Objects.requireNonNull(message);
        Objects.requireNonNull(aggregationKey);
        return BRIDGE.verifyBls(signature.toByteArray(), message.toByteArray(), aggregationKey.toByteArray(), partyId);
    }

    @Override
    public Bytes aggregateSignatures(@NonNull Bytes crs, @NonNull Bytes aggregationKey, @NonNull Bytes verificationKey, @NonNull Map<Integer, Bytes> partialSignatures) {
        Objects.requireNonNull(crs);
        Objects.requireNonNull(aggregationKey);
        Objects.requireNonNull(verificationKey);
        Objects.requireNonNull(partialSignatures);
        int[] parties = partialSignatures.keySet().stream().mapToInt(Integer::intValue).toArray();
        byte[][] signatures = (byte[][])Arrays.stream(parties).mapToObj(party -> ((Bytes)partialSignatures.get(party)).toByteArray()).toArray(x$0 -> new byte[x$0][]);
        byte[] aggregatedSignature = BRIDGE.aggregateSignatures(crs.toByteArray(), aggregationKey.toByteArray(), verificationKey.toByteArray(), parties, signatures);
        return aggregatedSignature == null ? null : Bytes.wrap((byte[])aggregatedSignature);
    }

    @Override
    public boolean verifyAggregate(@NonNull Bytes signature, @NonNull Bytes message, @NonNull Bytes verificationKey, long thresholdNumerator, long thresholdDenominator) {
        Objects.requireNonNull(signature);
        Objects.requireNonNull(message);
        Objects.requireNonNull(verificationKey);
        return BRIDGE.verifyAggregate(signature.toByteArray(), message.toByteArray(), verificationKey.toByteArray(), thresholdNumerator, thresholdDenominator);
    }
}

