/*
 * Decompiled with CFR 0.152.
 */
package com.hedera.node.app.quiescence;

import com.hedera.hapi.node.base.Timestamp;
import com.hedera.hapi.node.state.blockstream.BlockStreamInfo;
import com.hedera.hapi.node.state.schedule.ScheduledCounts;
import com.hedera.hapi.util.HapiUtils;
import com.hedera.node.app.blocks.BlockStreamService;
import com.hedera.node.app.blocks.schemas.V0560BlockStreamSchema;
import com.hedera.node.app.records.BlockRecordService;
import com.hedera.node.app.service.entityid.ReadableEntityCounters;
import com.hedera.node.app.service.entityid.impl.ReadableEntityIdStoreImpl;
import com.hedera.node.app.service.networkadmin.impl.ReadableFreezeStoreImpl;
import com.hedera.node.app.service.schedule.impl.ReadableScheduleStoreImpl;
import com.hedera.node.app.service.token.api.StakingRewardsApi;
import com.swirlds.state.State;
import com.swirlds.state.spi.ReadableSingletonState;
import edu.umd.cs.findbugs.annotations.NonNull;
import edu.umd.cs.findbugs.annotations.Nullable;
import java.time.Instant;
import java.util.Collections;
import java.util.List;
import java.util.Objects;
import java.util.Optional;

public class TctProbe {
    private final int maxConsecutiveScheduleSecondsToProbe;
    private final long stakePeriodMins;
    private final State state;
    @Nullable
    private Instant nearestTct;
    @Nullable
    private Instant nextFreezeTime;
    @Nullable
    private Instant nextScheduledSecond;
    @Nullable
    private Instant nextStakePeriodStart;
    @Nullable
    private Instant lastHandledConsensusTime;

    public TctProbe(int maxConsecutiveScheduleSecondsToProbe, long stakePeriodMins, @NonNull State state) {
        this.maxConsecutiveScheduleSecondsToProbe = maxConsecutiveScheduleSecondsToProbe;
        this.stakePeriodMins = stakePeriodMins;
        this.state = Objects.requireNonNull(state);
    }

    @Nullable
    public Instant findTct() {
        if (this.nextFreezeTime == null) {
            this.nextFreezeTime = Optional.ofNullable(new ReadableFreezeStoreImpl(this.state.getReadableStates("FreezeService")).freezeTime()).map(HapiUtils::asInstant).orElse(Instant.EPOCH);
        }
        if (this.stakePeriodMins > 0L) {
            if (this.nextStakePeriodStart == null) {
                long currentStakePeriod = StakingRewardsApi.stakePeriodAt((Instant)this.lastHandledConsensusTime(), (long)this.stakePeriodMins);
                this.nextStakePeriodStart = Instant.ofEpochSecond(StakingRewardsApi.epochSecondAtStartOfPeriod((long)(currentStakePeriod + 1L), (long)this.stakePeriodMins));
            }
        } else {
            this.nextStakePeriodStart = Instant.EPOCH;
        }
        if (this.nextScheduledSecond == null || this.nextScheduledSecondCouldBeNewNearestTct()) {
            if (this.nextScheduledSecond == null) {
                this.nextScheduledSecond = this.lastHandledConsensusTime();
            }
            ReadableScheduleStoreImpl readableScheduleStore = new ReadableScheduleStoreImpl(this.state.getReadableStates("ScheduleService"), (ReadableEntityCounters)new ReadableEntityIdStoreImpl(this.state.getReadableStates("EntityIdService")));
            for (int i = 0; i < this.maxConsecutiveScheduleSecondsToProbe; ++i) {
                ScheduledCounts counts = readableScheduleStore.scheduledCountsAt(this.nextScheduledSecond.getEpochSecond());
                if (counts != null && counts.numberProcessed() < counts.numberScheduled()) {
                    this.nearestTct = this.nextScheduledSecond;
                    break;
                }
                this.nextScheduledSecond = this.nextScheduledSecond.plusSeconds(1L);
            }
        }
        if (this.nearestTct == null) {
            Objects.requireNonNull(this.nextFreezeTime);
            Objects.requireNonNull(this.nextStakePeriodStart);
            this.nearestTct = Collections.min(List.of(this.nextStakePeriodStart, this.nextFreezeTime));
        }
        return this.nearestTct;
    }

    @NonNull
    public static BlockStreamInfo blockStreamInfoFrom(@NonNull State state, boolean inGenesisBlock) {
        ReadableSingletonState blockStreamInfoState = state.getReadableStates("BlockStreamService").getSingleton(V0560BlockStreamSchema.BLOCK_STREAM_INFO_STATE_ID);
        BlockStreamInfo blockStreamInfo = (BlockStreamInfo)blockStreamInfoState.get();
        if (blockStreamInfo == null && inGenesisBlock) {
            return BlockStreamService.GENESIS_BLOCK_STREAM_INFO;
        }
        return Objects.requireNonNull(blockStreamInfo);
    }

    @NonNull
    private Instant lastHandledConsensusTime() {
        if (this.lastHandledConsensusTime == null) {
            this.lastHandledConsensusTime = HapiUtils.asInstant((Timestamp)TctProbe.blockStreamInfoFrom(this.state, true).lastHandleTimeOrElse(BlockRecordService.EPOCH));
        }
        return this.lastHandledConsensusTime;
    }

    private boolean nextScheduledSecondCouldBeNewNearestTct() {
        if (this.nearestTct == null || this.nearestTct.equals(Instant.EPOCH)) {
            return true;
        }
        return this.nearestTct.equals(this.nextStakePeriodStart) || this.nearestTct.equals(this.nextFreezeTime);
    }
}

