/*
 * Decompiled with CFR 0.152.
 */
package io.helidon.webserver;

import io.helidon.webserver.ListenerConfig;
import io.helidon.webserver.spi.ServerConnection;
import java.time.Duration;
import java.util.List;
import java.util.Timer;
import java.util.TimerTask;
import java.util.function.Supplier;

class IdleTimeoutHandler
extends TimerTask {
    private final Timer timer;
    private final Supplier<List<ServerConnection>> connectionSupplier;
    private final Duration timeout;
    private final Duration period;
    private final String taskName;

    IdleTimeoutHandler(Timer timer, ListenerConfig listenerConfig, Supplier<List<ServerConnection>> connectionSupplier) {
        this.timer = timer;
        this.connectionSupplier = connectionSupplier;
        this.timeout = listenerConfig.idleConnectionTimeout();
        this.period = listenerConfig.idleConnectionPeriod();
        String listenerName = listenerConfig.name();
        this.taskName = "idle-timeout-handler-" + listenerName;
    }

    @Override
    public void run() {
        String name = Thread.currentThread().getName();
        Thread.currentThread().setName(this.taskName);
        List<ServerConnection> serverConnections = this.connectionSupplier.get();
        for (ServerConnection serverConnection : serverConnections) {
            if (serverConnection.idleTime().compareTo(this.timeout) <= 0) continue;
            try {
                serverConnection.close(false);
            }
            catch (Throwable t) {
                System.getLogger(IdleTimeoutHandler.class.getName() + "." + this.taskName).log(System.Logger.Level.TRACE, "Failed to close an idle connection", t);
            }
        }
        Thread.currentThread().setName(name);
    }

    void start() {
        this.timer.schedule((TimerTask)this, this.period.toMillis(), this.period.toMillis());
    }
}

