/*
 * Decompiled with CFR 0.152.
 */
package com.hedera.node.app.records.impl;

import com.hedera.hapi.block.internal.WrappedRecordFileBlockHashes;
import com.hedera.hapi.block.internal.WrappedRecordFileBlockHashesLog;
import com.hedera.node.app.metrics.BlockStreamMetrics;
import com.hedera.node.app.records.impl.WrappedRecordFileBlockHashesCalculator;
import com.hedera.node.app.records.impl.WrappedRecordFileBlockHashesComputationInput;
import com.hedera.node.app.records.impl.WrappedRecordHashesIndex;
import com.hedera.node.config.ConfigProvider;
import com.hedera.node.config.data.BlockRecordStreamConfig;
import com.hedera.pbj.runtime.io.buffer.Bytes;
import com.hedera.pbj.runtime.io.buffer.RandomAccessData;
import com.hedera.pbj.runtime.io.stream.WritableStreamingData;
import edu.umd.cs.findbugs.annotations.NonNull;
import java.io.BufferedOutputStream;
import java.io.IOException;
import java.io.OutputStream;
import java.io.UncheckedIOException;
import java.nio.file.FileSystem;
import java.nio.file.Files;
import java.nio.file.LinkOption;
import java.nio.file.Path;
import java.nio.file.StandardOpenOption;
import java.nio.file.attribute.FileAttribute;
import java.util.List;
import java.util.Objects;
import java.util.concurrent.CompletableFuture;
import java.util.concurrent.ExecutorService;
import java.util.concurrent.Executors;
import java.util.concurrent.atomic.AtomicBoolean;
import java.util.concurrent.atomic.AtomicReference;
import javax.inject.Inject;
import javax.inject.Singleton;
import org.apache.logging.log4j.LogManager;
import org.apache.logging.log4j.Logger;

@Singleton
public class WrappedRecordFileBlockHashesDiskWriter
implements AutoCloseable {
    private static final Logger logger = LogManager.getLogger(WrappedRecordFileBlockHashesDiskWriter.class);
    private static final String DEFAULT_FILE_NAME = "wrapped-record-hashes.pb";
    private static final int ENTRIES_FIELD_NUMBER = 1;
    private final ConfigProvider configProvider;
    private final FileSystem fileSystem;
    private final BlockStreamMetrics blockStreamMetrics;
    private final ExecutorService executor;
    private final AtomicReference<CompletableFuture<Void>> tail = new AtomicReference<CompletableFuture<Object>>(CompletableFuture.completedFuture(null));
    private final AtomicBoolean initialized = new AtomicBoolean(false);
    private final WrappedRecordHashesIndex index = new WrappedRecordHashesIndex();

    @Inject
    public WrappedRecordFileBlockHashesDiskWriter(@NonNull ConfigProvider configProvider, @NonNull FileSystem fileSystem, @NonNull BlockStreamMetrics blockStreamMetrics) {
        this.configProvider = Objects.requireNonNull(configProvider);
        this.fileSystem = Objects.requireNonNull(fileSystem);
        this.blockStreamMetrics = Objects.requireNonNull(blockStreamMetrics);
        this.executor = Executors.newSingleThreadExecutor();
    }

    public CompletableFuture<Void> appendAsync(@NonNull WrappedRecordFileBlockHashesComputationInput input) {
        Objects.requireNonNull(input);
        if (!((BlockRecordStreamConfig)this.configProvider.getConfiguration().getConfigData(BlockRecordStreamConfig.class)).writeWrappedRecordFileBlockHashesToDisk()) {
            return CompletableFuture.completedFuture(null);
        }
        if (input.recordStreamItems().isEmpty()) {
            logger.warn("Skipping wrapped record-file block hashes append for block {} because recordStreamItems is empty; input{startRunningHashLen={}, endRunningHashLen={}, sidecars={}}", (Object)input.blockNumber(), (Object)input.startRunningHash().length(), (Object)input.endRunningHash().length(), (Object)input.sidecarRecords().size());
            return CompletableFuture.completedFuture(null);
        }
        this.ensureInitialized();
        return this.tail.updateAndGet(prev -> ((CompletableFuture)prev.thenRunAsync(() -> {
            WrappedRecordFileBlockHashes entry;
            try {
                entry = WrappedRecordFileBlockHashesCalculator.compute(input);
            }
            catch (Exception e) {
                logger.error("Failed to compute wrapped record-file block hashes for block {}", (Object)input.blockNumber(), (Object)e);
                return;
            }
            if (this.index.contains(entry.blockNumber())) {
                logger.info("Skipping wrapped record-file block hashes append for block {} because it is already present in {}", (Object)entry.blockNumber(), (Object)DEFAULT_FILE_NAME);
                return;
            }
            if (logger.isDebugEnabled()) {
                logger.debug("Appending wrapped record-file block hashes for block {}: consensusTimestampLeafHash {}, outputItemsRootHash {}", (Object)entry.blockNumber(), (Object)entry.consensusTimestampHash().toHex(), (Object)entry.outputItemsTreeRootHash().toHex());
            }
            if (!this.appendInternal(entry)) {
                return;
            }
            List<WrappedRecordHashesIndex.GapRange> newlyLoggedGaps = this.index.addAndGetNewGaps(entry.blockNumber());
            for (WrappedRecordHashesIndex.GapRange gap : newlyLoggedGaps) {
                logger.warn("Wrapped record hashes file has a gap: missing record blocks {}..{} (observed range {}..{})", (Object)gap.startInclusive(), (Object)gap.endInclusive(), (Object)this.index.lowestBlock(), (Object)this.index.highestBlock());
            }
            this.blockStreamMetrics.recordWrappedRecordHashesLowestBlock(this.index.lowestBlock());
            this.blockStreamMetrics.recordWrappedRecordHashesHighestBlock(this.index.highestBlock());
            this.blockStreamMetrics.recordWrappedRecordHashesHasGaps(this.index.hasGaps());
        }, this.executor)).exceptionally(ex -> null));
    }

    private void ensureInitialized() {
        if (!this.initialized.compareAndSet(false, true)) {
            return;
        }
        BlockRecordStreamConfig cfg = (BlockRecordStreamConfig)this.configProvider.getConfiguration().getConfigData(BlockRecordStreamConfig.class);
        Path dir = this.fileSystem.getPath(cfg.wrappedRecordHashesDir(), new String[0]);
        Path file = dir.resolve(DEFAULT_FILE_NAME);
        if (!Files.exists(file, new LinkOption[0])) {
            this.blockStreamMetrics.recordWrappedRecordHashesLowestBlock(-1L);
            this.blockStreamMetrics.recordWrappedRecordHashesHighestBlock(-1L);
            this.blockStreamMetrics.recordWrappedRecordHashesHasGaps(false);
            return;
        }
        try {
            byte[] allBytes = Files.readAllBytes(file);
            if (allBytes.length == 0) {
                this.blockStreamMetrics.recordWrappedRecordHashesLowestBlock(-1L);
                this.blockStreamMetrics.recordWrappedRecordHashesHighestBlock(-1L);
                this.blockStreamMetrics.recordWrappedRecordHashesHasGaps(false);
                return;
            }
            WrappedRecordFileBlockHashesLog log = (WrappedRecordFileBlockHashesLog)WrappedRecordFileBlockHashesLog.PROTOBUF.parse(Bytes.wrap((byte[])allBytes).toReadableSequentialData(), false, false, 512, allBytes.length);
            for (WrappedRecordFileBlockHashes entry : log.entries()) {
                this.index.add(entry.blockNumber());
            }
        }
        catch (Exception e) {
            logger.error("Failed to scan existing wrapped record hashes file {}. Recreating...", (Object)file, (Object)e);
            try {
                this.index.reset();
                Files.createDirectories(dir, new FileAttribute[0]);
                OutputStream ignored = Files.newOutputStream(file, StandardOpenOption.CREATE, StandardOpenOption.TRUNCATE_EXISTING, StandardOpenOption.WRITE);
                if (ignored != null) {
                    ignored.close();
                }
            }
            catch (Exception ex) {
                logger.warn("Failed to recreate corrupt wrapped record hashes file {} as empty", (Object)file, (Object)ex);
            }
        }
        if (this.index.highestBlock() >= 0L) {
            List<WrappedRecordHashesIndex.GapRange> initGaps = this.index.addAndGetNewGaps(this.index.highestBlock());
            for (WrappedRecordHashesIndex.GapRange gap : initGaps) {
                logger.warn("Wrapped record hashes file has a gap: missing record blocks {}..{} (observed range {}..{})", (Object)gap.startInclusive(), (Object)gap.endInclusive(), (Object)this.index.lowestBlock(), (Object)this.index.highestBlock());
            }
        }
        this.blockStreamMetrics.recordWrappedRecordHashesLowestBlock(this.index.lowestBlock());
        this.blockStreamMetrics.recordWrappedRecordHashesHighestBlock(this.index.highestBlock());
        this.blockStreamMetrics.recordWrappedRecordHashesHasGaps(this.index.hasGaps());
    }

    private boolean appendInternal(@NonNull WrappedRecordFileBlockHashes entry) {
        Objects.requireNonNull(entry);
        BlockRecordStreamConfig cfg = (BlockRecordStreamConfig)this.configProvider.getConfiguration().getConfigData(BlockRecordStreamConfig.class);
        Path dir = this.fileSystem.getPath(cfg.wrappedRecordHashesDir(), new String[0]);
        Path file = dir.resolve(DEFAULT_FILE_NAME);
        try {
            Files.createDirectories(dir, new FileAttribute[0]);
            try (OutputStream out = Files.newOutputStream(file, StandardOpenOption.CREATE, StandardOpenOption.WRITE, StandardOpenOption.APPEND);
                 BufferedOutputStream buffered = new BufferedOutputStream(out);
                 WritableStreamingData stream = new WritableStreamingData((OutputStream)buffered);){
                Bytes bytes = WrappedRecordFileBlockHashes.PROTOBUF.toBytes((Object)entry);
                stream.writeVarInt(10, false);
                stream.writeVarInt((int)bytes.length(), false);
                stream.writeBytes((RandomAccessData)bytes);
            }
            return true;
        }
        catch (IOException | UncheckedIOException e) {
            logger.error("Failed to append wrapped record-file block hashes for block {} to {}", (Object)entry.blockNumber(), (Object)file, (Object)e);
            return false;
        }
    }

    @Override
    public void close() {
        try {
            this.tail.get().join();
        }
        catch (Exception e) {
            logger.warn("Error while awaiting completion of wrapped record hashes append chain", (Throwable)e);
        }
        finally {
            this.executor.shutdown();
        }
    }
}

