/*
 * Decompiled with CFR 0.152.
 */
package org.hiero.consensus.crypto;

import com.hedera.hapi.platform.event.EventCore;
import com.hedera.hapi.platform.event.EventDescriptor;
import com.hedera.pbj.runtime.io.WritableSequentialData;
import com.hedera.pbj.runtime.io.buffer.Bytes;
import com.hedera.pbj.runtime.io.buffer.RandomAccessData;
import com.hedera.pbj.runtime.io.stream.WritableStreamingData;
import edu.umd.cs.findbugs.annotations.NonNull;
import java.io.IOException;
import java.io.OutputStream;
import java.security.MessageDigest;
import java.util.List;
import java.util.Objects;
import org.hiero.base.crypto.DigestType;
import org.hiero.base.crypto.Hash;
import org.hiero.base.crypto.HashingOutputStream;
import org.hiero.consensus.crypto.EventHasher;
import org.hiero.consensus.model.event.PlatformEvent;
import org.hiero.consensus.model.event.UnsignedEvent;
import org.hiero.consensus.model.transaction.TransactionWrapper;

public class PbjStreamHasher
implements EventHasher {
    private final MessageDigest eventDigest = DigestType.SHA_384.buildDigest();
    final WritableSequentialData eventStream = new WritableStreamingData((OutputStream)new HashingOutputStream(this.eventDigest));
    private final MessageDigest transactionDigest = DigestType.SHA_384.buildDigest();
    final WritableSequentialData transactionStream = new WritableStreamingData((OutputStream)new HashingOutputStream(this.transactionDigest));

    @Override
    @NonNull
    public PlatformEvent hashEvent(@NonNull PlatformEvent event) {
        Objects.requireNonNull(event);
        Hash hash = this.hashEvent(event.getEventCore(), event.getGossipEvent().parents(), event.getTransactions());
        event.setHash(hash);
        return event;
    }

    public void hashUnsignedEvent(@NonNull UnsignedEvent event) {
        Hash hash = this.hashEvent(event.getEventCore(), event.getParents(), event.getTransactions());
        event.setHash(hash);
    }

    @NonNull
    private Hash hashEvent(@NonNull EventCore eventCore, @NonNull List<EventDescriptor> parents, @NonNull List<TransactionWrapper> transactions) {
        boolean success = false;
        try {
            EventCore.PROTOBUF.write((Object)eventCore, this.eventStream);
            for (EventDescriptor parent : parents) {
                EventDescriptor.PROTOBUF.write((Object)parent, this.eventStream);
            }
            for (TransactionWrapper transaction : transactions) {
                this.transactionStream.writeBytes((RandomAccessData)Objects.requireNonNull(transaction.getApplicationTransaction()));
                this.processTransactionHash(transaction);
            }
            success = true;
        }
        catch (IOException e) {
            throw new RuntimeException("An exception occurred while trying to hash an event!", e);
        }
        finally {
            if (!success) {
                this.transactionDigest.reset();
                this.eventDigest.reset();
            }
        }
        return new Hash(this.eventDigest.digest(), DigestType.SHA_384);
    }

    private void processTransactionHash(TransactionWrapper transaction) {
        byte[] hash = this.transactionDigest.digest();
        transaction.setHash(Bytes.wrap((byte[])hash));
        this.eventStream.writeBytes(hash);
    }
}

