/*
 * Decompiled with CFR 0.152.
 */
package io.helidon.http.media;

import io.helidon.common.GenericType;
import io.helidon.http.Header;
import io.helidon.http.HeaderName;
import io.helidon.http.HeaderNames;
import io.helidon.http.HeaderValues;
import io.helidon.http.Headers;
import io.helidon.http.HttpMediaType;
import io.helidon.http.HttpMediaTypes;
import io.helidon.http.WritableHeaders;
import io.helidon.http.media.EntityReader;
import io.helidon.http.media.EntityWriter;
import io.helidon.http.media.InstanceWriter;
import io.helidon.http.media.MediaSupport;
import java.io.IOException;
import java.io.InputStream;
import java.io.OutputStream;
import java.io.UncheckedIOException;
import java.nio.charset.Charset;
import java.nio.charset.StandardCharsets;
import java.util.Objects;
import java.util.Optional;
import java.util.OptionalLong;

public class StringSupport
implements MediaSupport {
    private static final Header HEADER_PLAIN_TEXT = HeaderValues.createCached((HeaderName)HeaderNames.CONTENT_TYPE, (String)HttpMediaTypes.PLAINTEXT_UTF_8.text());
    private static final EntityReader READER = new StringReader();
    private static final EntityWriter WRITER = new StringWriter();
    private final String name;

    protected StringSupport(String name) {
        this.name = Objects.requireNonNull(name);
    }

    public static MediaSupport create() {
        return new StringSupport("string");
    }

    @Override
    public <T> MediaSupport.ReaderResponse<T> reader(GenericType<T> type, Headers requestHeaders) {
        if (type.equals((Object)GenericType.STRING)) {
            return new MediaSupport.ReaderResponse(MediaSupport.SupportLevel.SUPPORTED, StringSupport::reader);
        }
        return MediaSupport.ReaderResponse.unsupported();
    }

    @Override
    public <T> MediaSupport.WriterResponse<T> writer(GenericType<T> type, Headers requestHeaders, WritableHeaders<?> responseHeaders) {
        if (type.equals((Object)GenericType.STRING)) {
            return new MediaSupport.WriterResponse(MediaSupport.SupportLevel.SUPPORTED, StringSupport::writer);
        }
        return MediaSupport.WriterResponse.unsupported();
    }

    @Override
    public <T> MediaSupport.ReaderResponse<T> reader(GenericType<T> type, Headers requestHeaders, Headers responseHeaders) {
        if (type.equals((Object)GenericType.STRING)) {
            return new MediaSupport.ReaderResponse(MediaSupport.SupportLevel.SUPPORTED, StringSupport::reader);
        }
        return MediaSupport.ReaderResponse.unsupported();
    }

    @Override
    public <T> MediaSupport.WriterResponse<T> writer(GenericType<T> type, WritableHeaders<?> requestHeaders) {
        if (type.equals((Object)GenericType.STRING)) {
            return new MediaSupport.WriterResponse(MediaSupport.SupportLevel.SUPPORTED, StringSupport::writer);
        }
        return MediaSupport.WriterResponse.unsupported();
    }

    public String name() {
        return this.name;
    }

    public String type() {
        return "string";
    }

    private static <T> EntityReader<T> reader() {
        return READER;
    }

    private static <T> EntityWriter<T> writer() {
        return WRITER;
    }

    private static final class StringReader
    implements EntityReader<String> {
        private StringReader() {
        }

        @Override
        public String read(GenericType<String> type, InputStream stream, Headers headers) {
            return this.read(stream, headers.contentType());
        }

        @Override
        public String read(GenericType<String> type, InputStream stream, Headers requestHeaders, Headers responseHeaders) {
            return this.read(stream, responseHeaders.contentType());
        }

        private String read(InputStream stream, Optional<HttpMediaType> contentType) {
            String string;
            block8: {
                Charset charset = contentType.flatMap(HttpMediaType::charset).map(Charset::forName).orElse(StandardCharsets.UTF_8);
                InputStream inputStream = stream;
                try {
                    string = new String(stream.readAllBytes(), charset);
                    if (inputStream == null) break block8;
                }
                catch (Throwable throwable) {
                    try {
                        if (inputStream != null) {
                            try {
                                inputStream.close();
                            }
                            catch (Throwable throwable2) {
                                throwable.addSuppressed(throwable2);
                            }
                        }
                        throw throwable;
                    }
                    catch (IOException e) {
                        throw new UncheckedIOException(e);
                    }
                }
                inputStream.close();
            }
            return string;
        }
    }

    private static final class StringWriter
    implements EntityWriter<String> {
        private StringWriter() {
        }

        @Override
        public void write(GenericType<String> type, String object, OutputStream outputStream, Headers requestHeaders, WritableHeaders<?> responseHeaders) {
            this.write(object, outputStream, responseHeaders);
        }

        @Override
        public void write(GenericType<String> type, String object, OutputStream outputStream, WritableHeaders<?> headers) {
            this.write(object, outputStream, headers);
        }

        @Override
        public boolean supportsInstanceWriter() {
            return true;
        }

        @Override
        public InstanceWriter instanceWriter(GenericType<String> type, String object, WritableHeaders<?> requestHeaders) {
            return new StringInstanceWriter(object, requestHeaders);
        }

        @Override
        public InstanceWriter instanceWriter(GenericType<String> type, String object, Headers requestHeaders, WritableHeaders<?> responseHeaders) {
            return new StringInstanceWriter(object, responseHeaders);
        }

        private void write(String toWrite, OutputStream outputStream, WritableHeaders<?> writableHeaders) {
            Charset charset;
            if (writableHeaders.contains(HeaderNames.CONTENT_TYPE)) {
                charset = writableHeaders.contentType().flatMap(HttpMediaType::charset).map(Charset::forName).orElse(StandardCharsets.UTF_8);
            } else {
                writableHeaders.set(HEADER_PLAIN_TEXT);
                charset = StandardCharsets.UTF_8;
            }
            try (OutputStream outputStream2 = outputStream;){
                outputStream.write(toWrite.getBytes(charset));
            }
            catch (IOException e) {
                throw new UncheckedIOException(e);
            }
        }
    }

    private static final class StringInstanceWriter
    implements InstanceWriter {
        private final byte[] bytes;

        private StringInstanceWriter(String object, WritableHeaders<?> headers) {
            Charset charset;
            if (headers.contains(HeaderNames.CONTENT_TYPE)) {
                charset = headers.contentType().flatMap(HttpMediaType::charset).map(Charset::forName).orElse(StandardCharsets.UTF_8);
            } else {
                headers.set(HEADER_PLAIN_TEXT);
                charset = StandardCharsets.UTF_8;
            }
            this.bytes = object.getBytes(charset);
        }

        @Override
        public boolean alwaysInMemory() {
            return true;
        }

        @Override
        public OptionalLong contentLength() {
            return OptionalLong.of(this.bytes.length);
        }

        @Override
        public void write(OutputStream stream) {
            try (OutputStream outputStream = stream;){
                stream.write(this.bytes);
            }
            catch (IOException e) {
                throw new UncheckedIOException(e);
            }
        }

        @Override
        public byte[] instanceBytes() {
            return this.bytes;
        }
    }
}

