/*
 * Decompiled with CFR 0.152.
 */
package com.hedera.hapi.node.state.history;

import com.hedera.hapi.node.base.Timestamp;
import com.hedera.hapi.node.state.history.HistoryProof;
import com.hedera.hapi.node.state.history.WrapsSigningState;
import com.hedera.hapi.node.state.history.codec.HistoryProofConstructionJsonCodec;
import com.hedera.hapi.node.state.history.codec.HistoryProofConstructionProtoCodec;
import com.hedera.hapi.node.state.history.schema.HistoryProofConstructionSchema;
import com.hedera.pbj.runtime.Codec;
import com.hedera.pbj.runtime.EnumWithProtoMetadata;
import com.hedera.pbj.runtime.FieldDefinition;
import com.hedera.pbj.runtime.JsonCodec;
import com.hedera.pbj.runtime.OneOf;
import com.hedera.pbj.runtime.ProtoWriterTools;
import com.hedera.pbj.runtime.UnknownField;
import com.hedera.pbj.runtime.io.buffer.Bytes;
import com.hedera.pbj.runtime.io.buffer.RandomAccessData;
import edu.umd.cs.findbugs.annotations.NonNull;
import edu.umd.cs.findbugs.annotations.Nullable;
import java.util.Collections;
import java.util.List;
import java.util.Objects;

public final class HistoryProofConstruction {
    public static final Codec<HistoryProofConstruction> PROTOBUF = new HistoryProofConstructionProtoCodec();
    public static final JsonCodec<HistoryProofConstruction> JSON = new HistoryProofConstructionJsonCodec();
    public static final HistoryProofConstruction DEFAULT = HistoryProofConstruction.newBuilder().build();
    private final long constructionId;
    @NonNull
    private final Bytes sourceRosterHash;
    @NonNull
    private final Bytes targetRosterHash;
    private final OneOf<ProofStateOneOfType> proofState;
    private final int wrapsRetryCount;
    private int $hashCode = -1;
    private int $protobufEncodedSize = -1;
    private final List<UnknownField> $unknownFields;

    public HistoryProofConstruction(long constructionId, Bytes sourceRosterHash, Bytes targetRosterHash, OneOf<ProofStateOneOfType> proofState, int wrapsRetryCount) {
        this.$unknownFields = null;
        this.constructionId = constructionId;
        this.sourceRosterHash = sourceRosterHash != null ? sourceRosterHash : Bytes.EMPTY;
        Bytes bytes = this.targetRosterHash = targetRosterHash != null ? targetRosterHash : Bytes.EMPTY;
        if (proofState == null) {
            throw new NullPointerException("Parameter 'proofState' must be supplied and can not be null");
        }
        this.proofState = proofState;
        this.wrapsRetryCount = wrapsRetryCount;
    }

    public HistoryProofConstruction(long constructionId, Bytes sourceRosterHash, Bytes targetRosterHash, OneOf<ProofStateOneOfType> proofState, int wrapsRetryCount, List<UnknownField> $unknownFields) {
        this.$unknownFields = $unknownFields == null ? null : Collections.unmodifiableList($unknownFields);
        this.constructionId = constructionId;
        this.sourceRosterHash = sourceRosterHash != null ? sourceRosterHash : Bytes.EMPTY;
        Bytes bytes = this.targetRosterHash = targetRosterHash != null ? targetRosterHash : Bytes.EMPTY;
        if (proofState == null) {
            throw new NullPointerException("Parameter 'proofState' must be supplied and can not be null");
        }
        this.proofState = proofState;
        this.wrapsRetryCount = wrapsRetryCount;
    }

    public long constructionId() {
        return this.constructionId;
    }

    public Bytes sourceRosterHash() {
        return this.sourceRosterHash;
    }

    public Bytes targetRosterHash() {
        return this.targetRosterHash;
    }

    public OneOf<ProofStateOneOfType> proofState() {
        return this.proofState;
    }

    public int wrapsRetryCount() {
        return this.wrapsRetryCount;
    }

    @NonNull
    public List<UnknownField> getUnknownFields() {
        return this.$unknownFields == null ? Collections.EMPTY_LIST : this.$unknownFields;
    }

    public int protobufSize() {
        if (this.$protobufEncodedSize == -1) {
            int _size = 0;
            _size += ProtoWriterTools.sizeOfLong((FieldDefinition)HistoryProofConstructionSchema.CONSTRUCTION_ID, (long)this.constructionId, (boolean)true);
            _size += ProtoWriterTools.sizeOfBytes((FieldDefinition)HistoryProofConstructionSchema.SOURCE_ROSTER_HASH, (RandomAccessData)this.sourceRosterHash, (boolean)true);
            _size += ProtoWriterTools.sizeOfBytes((FieldDefinition)HistoryProofConstructionSchema.TARGET_ROSTER_HASH, (RandomAccessData)this.targetRosterHash, (boolean)true);
            if (this.proofState.kind() == ProofStateOneOfType.GRACE_PERIOD_END_TIME) {
                _size += ProtoWriterTools.sizeOfMessage((FieldDefinition)HistoryProofConstructionSchema.GRACE_PERIOD_END_TIME, (Object)((Timestamp)this.proofState.as()), Timestamp.PROTOBUF);
            }
            if (this.proofState.kind() == ProofStateOneOfType.ASSEMBLY_START_TIME) {
                _size += ProtoWriterTools.sizeOfMessage((FieldDefinition)HistoryProofConstructionSchema.ASSEMBLY_START_TIME, (Object)((Timestamp)this.proofState.as()), Timestamp.PROTOBUF);
            }
            if (this.proofState.kind() == ProofStateOneOfType.TARGET_PROOF) {
                _size += ProtoWriterTools.sizeOfMessage((FieldDefinition)HistoryProofConstructionSchema.TARGET_PROOF, (Object)((HistoryProof)this.proofState.as()), HistoryProof.PROTOBUF);
            }
            if (this.proofState.kind() == ProofStateOneOfType.FAILURE_REASON) {
                _size += ProtoWriterTools.sizeOfString((FieldDefinition)HistoryProofConstructionSchema.FAILURE_REASON, (String)((String)this.proofState.as()), (boolean)true);
            }
            if (this.proofState.kind() == ProofStateOneOfType.WRAPS_SIGNING_STATE) {
                _size += ProtoWriterTools.sizeOfMessage((FieldDefinition)HistoryProofConstructionSchema.WRAPS_SIGNING_STATE, (Object)((WrapsSigningState)this.proofState.as()), WrapsSigningState.PROTOBUF);
            }
            _size += ProtoWriterTools.sizeOfInteger((FieldDefinition)HistoryProofConstructionSchema.WRAPS_RETRY_COUNT, (int)this.wrapsRetryCount, (boolean)true);
            if (this.$unknownFields != null) {
                for (int i = 0; i < this.$unknownFields.size(); ++i) {
                    UnknownField uf = this.$unknownFields.get(i);
                    _size += ProtoWriterTools.sizeOfVarInt32((int)(uf.field() << 3 | uf.wireType().ordinal()));
                    _size += Math.toIntExact(uf.bytes().length());
                }
            }
            this.$protobufEncodedSize = _size;
        }
        return this.$protobufEncodedSize;
    }

    public int hashCode() {
        if (this.$hashCode == -1) {
            int result = 1;
            if (this.constructionId != HistoryProofConstruction.DEFAULT.constructionId) {
                result = 31 * result + Long.hashCode(this.constructionId);
            }
            if (this.sourceRosterHash != null && !this.sourceRosterHash.equals((Object)HistoryProofConstruction.DEFAULT.sourceRosterHash)) {
                result = 31 * result + this.sourceRosterHash.hashCode();
            }
            if (this.targetRosterHash != null && !this.targetRosterHash.equals((Object)HistoryProofConstruction.DEFAULT.targetRosterHash)) {
                result = 31 * result + this.targetRosterHash.hashCode();
            }
            if (this.proofState != null && !this.proofState.equals(HistoryProofConstruction.DEFAULT.proofState)) {
                result = 31 * result + this.proofState.hashCode();
            }
            if (this.wrapsRetryCount != HistoryProofConstruction.DEFAULT.wrapsRetryCount) {
                result = 31 * result + Integer.hashCode(this.wrapsRetryCount);
            }
            if (this.$unknownFields != null) {
                for (int i = 0; i < this.$unknownFields.size(); ++i) {
                    result = 31 * result + this.$unknownFields.get(i).hashCode();
                }
            }
            long hashCode = result;
            hashCode += hashCode << 30;
            hashCode ^= hashCode >>> 27;
            hashCode += hashCode << 16;
            hashCode ^= hashCode >>> 20;
            hashCode += hashCode << 5;
            hashCode ^= hashCode >>> 18;
            hashCode += hashCode << 10;
            hashCode ^= hashCode >>> 24;
            hashCode += hashCode << 30;
            this.$hashCode = (int)hashCode;
        }
        return this.$hashCode;
    }

    public boolean equals(Object that) {
        if (that == null || this.getClass() != that.getClass()) {
            return false;
        }
        HistoryProofConstruction thatObj = (HistoryProofConstruction)that;
        if (this.$hashCode != -1 && thatObj.$hashCode != -1 && this.$hashCode != thatObj.$hashCode) {
            return false;
        }
        if (this.constructionId != thatObj.constructionId) {
            return false;
        }
        if (this.sourceRosterHash == null && thatObj.sourceRosterHash != null) {
            return false;
        }
        if (this.sourceRosterHash != null && !this.sourceRosterHash.equals((Object)thatObj.sourceRosterHash)) {
            return false;
        }
        if (this.targetRosterHash == null && thatObj.targetRosterHash != null) {
            return false;
        }
        if (this.targetRosterHash != null && !this.targetRosterHash.equals((Object)thatObj.targetRosterHash)) {
            return false;
        }
        if (this.proofState == null && thatObj.proofState != null) {
            return false;
        }
        if (this.proofState != null && !this.proofState.equals(thatObj.proofState)) {
            return false;
        }
        if (this.wrapsRetryCount != thatObj.wrapsRetryCount) {
            return false;
        }
        if (this.$unknownFields != null && !this.$unknownFields.isEmpty()) {
            if (thatObj.$unknownFields == null || this.$unknownFields.size() != thatObj.$unknownFields.size()) {
                return false;
            }
            if (!this.$unknownFields.equals(thatObj.$unknownFields)) {
                return false;
            }
        } else if (thatObj.$unknownFields != null && !thatObj.$unknownFields.isEmpty()) {
            return false;
        }
        return true;
    }

    public String toString() {
        String $ufstr = null;
        if (this.$unknownFields != null && !this.$unknownFields.isEmpty()) {
            StringBuilder sb = new StringBuilder();
            for (int i = 0; i < this.$unknownFields.size(); ++i) {
                if (i > 0) {
                    sb.append(", ");
                }
                this.$unknownFields.get(i).printToString(sb);
            }
            $ufstr = sb.toString();
        }
        return "HistoryProofConstruction[constructionId=" + this.constructionId + ", sourceRosterHash=" + String.valueOf(this.sourceRosterHash) + ", targetRosterHash=" + String.valueOf(this.targetRosterHash) + ", proofState=" + String.valueOf(this.proofState) + ", wrapsRetryCount=" + this.wrapsRetryCount + (String)($ufstr == null ? "" : ", " + $ufstr) + "]";
    }

    @Nullable
    public Timestamp gracePeriodEndTime() {
        return this.proofState.kind() == ProofStateOneOfType.GRACE_PERIOD_END_TIME ? (Timestamp)this.proofState.value() : null;
    }

    public boolean hasGracePeriodEndTime() {
        return this.proofState.kind() == ProofStateOneOfType.GRACE_PERIOD_END_TIME;
    }

    public Timestamp gracePeriodEndTimeOrElse(@NonNull Timestamp defaultValue) {
        return this.hasGracePeriodEndTime() ? this.gracePeriodEndTime() : defaultValue;
    }

    @NonNull
    public Timestamp gracePeriodEndTimeOrThrow() {
        return Objects.requireNonNull(this.gracePeriodEndTime(), "Field gracePeriodEndTime is null");
    }

    @Nullable
    public Timestamp assemblyStartTime() {
        return this.proofState.kind() == ProofStateOneOfType.ASSEMBLY_START_TIME ? (Timestamp)this.proofState.value() : null;
    }

    public boolean hasAssemblyStartTime() {
        return this.proofState.kind() == ProofStateOneOfType.ASSEMBLY_START_TIME;
    }

    public Timestamp assemblyStartTimeOrElse(@NonNull Timestamp defaultValue) {
        return this.hasAssemblyStartTime() ? this.assemblyStartTime() : defaultValue;
    }

    @NonNull
    public Timestamp assemblyStartTimeOrThrow() {
        return Objects.requireNonNull(this.assemblyStartTime(), "Field assemblyStartTime is null");
    }

    @Nullable
    public HistoryProof targetProof() {
        return this.proofState.kind() == ProofStateOneOfType.TARGET_PROOF ? (HistoryProof)this.proofState.value() : null;
    }

    public boolean hasTargetProof() {
        return this.proofState.kind() == ProofStateOneOfType.TARGET_PROOF;
    }

    public HistoryProof targetProofOrElse(@NonNull HistoryProof defaultValue) {
        return this.hasTargetProof() ? this.targetProof() : defaultValue;
    }

    @NonNull
    public HistoryProof targetProofOrThrow() {
        return Objects.requireNonNull(this.targetProof(), "Field targetProof is null");
    }

    @Nullable
    public String failureReason() {
        return this.proofState.kind() == ProofStateOneOfType.FAILURE_REASON ? (String)this.proofState.value() : null;
    }

    public boolean hasFailureReason() {
        return this.proofState.kind() == ProofStateOneOfType.FAILURE_REASON;
    }

    public String failureReasonOrElse(@NonNull String defaultValue) {
        return this.hasFailureReason() ? this.failureReason() : defaultValue;
    }

    @NonNull
    public String failureReasonOrThrow() {
        return Objects.requireNonNull(this.failureReason(), "Field failureReason is null");
    }

    @Nullable
    public WrapsSigningState wrapsSigningState() {
        return this.proofState.kind() == ProofStateOneOfType.WRAPS_SIGNING_STATE ? (WrapsSigningState)this.proofState.value() : null;
    }

    public boolean hasWrapsSigningState() {
        return this.proofState.kind() == ProofStateOneOfType.WRAPS_SIGNING_STATE;
    }

    public WrapsSigningState wrapsSigningStateOrElse(@NonNull WrapsSigningState defaultValue) {
        return this.hasWrapsSigningState() ? this.wrapsSigningState() : defaultValue;
    }

    @NonNull
    public WrapsSigningState wrapsSigningStateOrThrow() {
        return Objects.requireNonNull(this.wrapsSigningState(), "Field wrapsSigningState is null");
    }

    public Builder copyBuilder() {
        return new Builder(this.constructionId, this.sourceRosterHash, this.targetRosterHash, this.proofState, this.wrapsRetryCount, this.$unknownFields);
    }

    public static Builder newBuilder() {
        return new Builder();
    }

    public static enum ProofStateOneOfType implements EnumWithProtoMetadata
    {
        UNSET(-1, "UNSET"),
        GRACE_PERIOD_END_TIME(5, "grace_period_end_time"),
        ASSEMBLY_START_TIME(6, "assembly_start_time"),
        TARGET_PROOF(7, "target_proof"),
        FAILURE_REASON(8, "failure_reason"),
        WRAPS_SIGNING_STATE(9, "wraps_signing_state");

        private final int protoOrdinal;
        private final String protoName;

        private ProofStateOneOfType(int protoOrdinal, String protoName) {
            this.protoOrdinal = protoOrdinal;
            this.protoName = protoName;
        }

        public int protoOrdinal() {
            return this.protoOrdinal;
        }

        public String protoName() {
            return this.protoName;
        }

        public static ProofStateOneOfType fromProtobufOrdinal(int ordinal) {
            return switch (ordinal) {
                case 5 -> GRACE_PERIOD_END_TIME;
                case 6 -> ASSEMBLY_START_TIME;
                case 7 -> TARGET_PROOF;
                case 8 -> FAILURE_REASON;
                case 9 -> WRAPS_SIGNING_STATE;
                default -> UNSET;
            };
        }

        public static ProofStateOneOfType fromString(String name) {
            return switch (name) {
                case "grace_period_end_time", "GRACE_PERIOD_END_TIME" -> GRACE_PERIOD_END_TIME;
                case "assembly_start_time", "ASSEMBLY_START_TIME" -> ASSEMBLY_START_TIME;
                case "target_proof", "TARGET_PROOF" -> TARGET_PROOF;
                case "failure_reason", "FAILURE_REASON" -> FAILURE_REASON;
                case "wraps_signing_state", "WRAPS_SIGNING_STATE" -> WRAPS_SIGNING_STATE;
                default -> throw new IllegalArgumentException("Unknown token kyc status " + name);
            };
        }

        public static ProofStateOneOfType fromObject(Object obj) {
            if (obj == null) {
                return ProofStateOneOfType.fromProtobufOrdinal(0);
            }
            if (obj instanceof ProofStateOneOfType) {
                ProofStateOneOfType pbjEnum = (ProofStateOneOfType)((Object)obj);
                return pbjEnum;
            }
            return UNSET;
        }

        public static List<ProofStateOneOfType> fromObjects(List<?> list) {
            return list.stream().map(ProofStateOneOfType::fromObject).toList();
        }

        public static int toProtoOrdinal(Object obj) {
            if (obj instanceof ProofStateOneOfType) {
                ProofStateOneOfType pbjEnum = (ProofStateOneOfType)((Object)obj);
                return pbjEnum.protoOrdinal();
            }
            if (obj instanceof Integer) {
                Integer i = (Integer)obj;
                return i;
            }
            throw new IllegalArgumentException("Neither ProofStateOneOfType, nor Integer, but: " + obj.getClass().getName());
        }

        public static List<Integer> toProtoOrdinals(List<?> list) {
            return list.stream().map(ProofStateOneOfType::toProtoOrdinal).toList();
        }

        public static int compare(Object o1, Object o2) {
            int i2;
            int i1;
            if (o1 instanceof ProofStateOneOfType) {
                ProofStateOneOfType e1 = (ProofStateOneOfType)((Object)o1);
                if (o2 instanceof ProofStateOneOfType) {
                    ProofStateOneOfType e2 = (ProofStateOneOfType)((Object)o2);
                    return e1.compareTo(e2);
                }
            }
            if (o1 == null && o2 != null) {
                return -1;
            }
            if (o1 != null && o2 == null) {
                return 1;
            }
            if (o1 instanceof ProofStateOneOfType) {
                ProofStateOneOfType e1 = (ProofStateOneOfType)((Object)o1);
                i1 = e1.protoOrdinal();
            } else if (o1 instanceof Integer) {
                Integer ii1 = (Integer)o1;
                i1 = ii1;
            } else {
                throw new IllegalArgumentException("o1 is neither ProofStateOneOfType, nor Integer. It's: " + o1.getClass().getName());
            }
            if (o2 instanceof ProofStateOneOfType) {
                ProofStateOneOfType e2 = (ProofStateOneOfType)((Object)o2);
                i2 = e2.protoOrdinal();
            } else if (o2 instanceof Integer) {
                Integer ii2 = (Integer)o2;
                i2 = ii2;
            } else {
                throw new IllegalArgumentException("o2 is neither ProofStateOneOfType, nor Integer. It's: " + o2.getClass().getName());
            }
            return Integer.compare(i1, i2);
        }
    }

    public static final class Builder {
        private long constructionId = 0L;
        @NonNull
        private Bytes sourceRosterHash = Bytes.EMPTY;
        @NonNull
        private Bytes targetRosterHash = Bytes.EMPTY;
        private OneOf<ProofStateOneOfType> proofState = HistoryProofConstructionProtoCodec.PROOF_STATE_UNSET;
        private int wrapsRetryCount = 0;
        private final List<UnknownField> $unknownFields;

        public Builder() {
            this.$unknownFields = null;
        }

        public Builder(long constructionId, Bytes sourceRosterHash, Bytes targetRosterHash, OneOf<ProofStateOneOfType> proofState, int wrapsRetryCount) {
            this.$unknownFields = null;
            this.constructionId = constructionId;
            this.sourceRosterHash = sourceRosterHash != null ? sourceRosterHash : Bytes.EMPTY;
            this.targetRosterHash = targetRosterHash != null ? targetRosterHash : Bytes.EMPTY;
            this.proofState = proofState;
            this.wrapsRetryCount = wrapsRetryCount;
        }

        public Builder(long constructionId, Bytes sourceRosterHash, Bytes targetRosterHash, OneOf<ProofStateOneOfType> proofState, int wrapsRetryCount, List<UnknownField> $unknownFields) {
            this.$unknownFields = $unknownFields == null ? null : Collections.unmodifiableList($unknownFields);
            this.constructionId = constructionId;
            this.sourceRosterHash = sourceRosterHash != null ? sourceRosterHash : Bytes.EMPTY;
            this.targetRosterHash = targetRosterHash != null ? targetRosterHash : Bytes.EMPTY;
            this.proofState = proofState;
            this.wrapsRetryCount = wrapsRetryCount;
        }

        public HistoryProofConstruction build() {
            return new HistoryProofConstruction(this.constructionId, this.sourceRosterHash, this.targetRosterHash, this.proofState, this.wrapsRetryCount);
        }

        public Builder constructionId(long constructionId) {
            this.constructionId = constructionId;
            return this;
        }

        public Builder sourceRosterHash(@NonNull Bytes sourceRosterHash) {
            this.sourceRosterHash = sourceRosterHash != null ? sourceRosterHash : Bytes.EMPTY;
            return this;
        }

        public Builder targetRosterHash(@NonNull Bytes targetRosterHash) {
            this.targetRosterHash = targetRosterHash != null ? targetRosterHash : Bytes.EMPTY;
            return this;
        }

        public void clearProofState() {
            this.proofState = HistoryProofConstructionProtoCodec.PROOF_STATE_UNSET;
        }

        public Builder gracePeriodEndTime(@Nullable Timestamp gracePeriodEndTime) {
            this.proofState = new OneOf((Enum)ProofStateOneOfType.GRACE_PERIOD_END_TIME, (Object)gracePeriodEndTime);
            return this;
        }

        public Builder gracePeriodEndTime(Timestamp.Builder builder) {
            this.proofState = new OneOf((Enum)ProofStateOneOfType.GRACE_PERIOD_END_TIME, (Object)builder.build());
            return this;
        }

        public Builder assemblyStartTime(@Nullable Timestamp assemblyStartTime) {
            this.proofState = new OneOf((Enum)ProofStateOneOfType.ASSEMBLY_START_TIME, (Object)assemblyStartTime);
            return this;
        }

        public Builder assemblyStartTime(Timestamp.Builder builder) {
            this.proofState = new OneOf((Enum)ProofStateOneOfType.ASSEMBLY_START_TIME, (Object)builder.build());
            return this;
        }

        public Builder targetProof(@Nullable HistoryProof targetProof) {
            this.proofState = new OneOf((Enum)ProofStateOneOfType.TARGET_PROOF, (Object)targetProof);
            return this;
        }

        public Builder targetProof(HistoryProof.Builder builder) {
            this.proofState = new OneOf((Enum)ProofStateOneOfType.TARGET_PROOF, (Object)builder.build());
            return this;
        }

        public Builder failureReason(@NonNull String failureReason) {
            this.proofState = new OneOf((Enum)ProofStateOneOfType.FAILURE_REASON, (Object)failureReason);
            return this;
        }

        public Builder wrapsSigningState(@Nullable WrapsSigningState wrapsSigningState) {
            this.proofState = new OneOf((Enum)ProofStateOneOfType.WRAPS_SIGNING_STATE, (Object)wrapsSigningState);
            return this;
        }

        public Builder wrapsSigningState(WrapsSigningState.Builder builder) {
            this.proofState = new OneOf((Enum)ProofStateOneOfType.WRAPS_SIGNING_STATE, (Object)builder.build());
            return this;
        }

        public Builder wrapsRetryCount(int wrapsRetryCount) {
            this.wrapsRetryCount = wrapsRetryCount;
            return this;
        }

        public long constructionId() {
            return this.constructionId;
        }

        public Bytes sourceRosterHash() {
            return this.sourceRosterHash;
        }

        public Bytes targetRosterHash() {
            return this.targetRosterHash;
        }

        public OneOf<ProofStateOneOfType> proofState() {
            return this.proofState;
        }

        public int wrapsRetryCount() {
            return this.wrapsRetryCount;
        }
    }
}

