/*
 * Decompiled with CFR 0.152.
 */
package com.hedera.node.app.hints.impl;

import com.swirlds.metrics.api.Counter;
import com.swirlds.metrics.api.MetricConfig;
import com.swirlds.metrics.api.Metrics;
import edu.umd.cs.findbugs.annotations.NonNull;
import java.util.Objects;
import javax.inject.Inject;
import javax.inject.Singleton;
import org.hiero.consensus.metrics.RunningAverageMetric;

@Singleton
public class HintsSigningMetrics {
    private static final String CATEGORY = "app";
    private final Counter signaturesProduced;
    private final Counter attemptsWithoutSignature;
    private final RunningAverageMetric successfulAttemptMillisAvg;

    @Inject
    public HintsSigningMetrics(@NonNull Metrics metrics) {
        Objects.requireNonNull(metrics);
        this.signaturesProduced = (Counter)metrics.getOrCreate((MetricConfig)new Counter.Config(CATEGORY, "hintsSignaturesProduced").withDescription("Number of aggregated hinTS signatures produced"));
        this.attemptsWithoutSignature = (Counter)metrics.getOrCreate((MetricConfig)new Counter.Config(CATEGORY, "hintsSigningNoSigCompletions").withDescription("Number of hinTS signing attempts completed without producing a signature"));
        this.successfulAttemptMillisAvg = (RunningAverageMetric)metrics.getOrCreate((MetricConfig)new RunningAverageMetric.Config(CATEGORY, "hintsSigningSuccessMsAvg").withDescription("Average milliseconds for successful hinTS signing attempts to complete").withUnit("ms").withFormat("%,13.3f"));
    }

    public void recordSignatureProduced(long elapsedMillis) {
        this.signaturesProduced.increment();
        this.successfulAttemptMillisAvg.update((double)Math.max(0L, elapsedMillis));
    }

    public void recordAttemptCompletedWithoutSignature() {
        this.attemptsWithoutSignature.increment();
    }
}

