/*
 * Decompiled with CFR 0.152.
 */
package com.hedera.node.app.history.impl;

import com.swirlds.metrics.api.Counter;
import com.swirlds.metrics.api.MetricConfig;
import com.swirlds.metrics.api.Metrics;
import edu.umd.cs.findbugs.annotations.NonNull;
import java.time.Duration;
import java.time.Instant;
import java.util.List;
import java.util.Map;
import java.util.Objects;
import java.util.concurrent.ConcurrentHashMap;
import javax.inject.Inject;
import javax.inject.Singleton;
import org.hiero.consensus.metrics.RunningAverageMetric;

@Singleton
public class HistoryProofMetrics {
    private static final String CATEGORY = "app";
    private final Metrics metrics;
    private final Counter proofsProduced;
    private final Counter wrapsRetriesStarted;
    private final Counter wrapsRetriesOnCompletedProofs;
    private final RunningAverageMetric wrapsRetriesPerCompletedProof;
    private final Map<Long, StageObservation> stageObservations = new ConcurrentHashMap<Long, StageObservation>();
    private final Map<StageTransition, TransitionMetrics> transitionMetrics = new ConcurrentHashMap<StageTransition, TransitionMetrics>();

    @Inject
    public HistoryProofMetrics(@NonNull Metrics metrics) {
        this.metrics = Objects.requireNonNull(metrics);
        this.proofsProduced = (Counter)this.metrics.getOrCreate((MetricConfig)new Counter.Config(CATEGORY, "historyProofsProduced").withDescription("Number of completed history proofs produced"));
        this.wrapsRetriesStarted = (Counter)this.metrics.getOrCreate((MetricConfig)new Counter.Config(CATEGORY, "historyProofWrapsRetriesStarted").withDescription("Number of WRAPS retry attempts started for history proofs"));
        this.wrapsRetriesOnCompletedProofs = (Counter)this.metrics.getOrCreate((MetricConfig)new Counter.Config(CATEGORY, "historyProofRetriesTotal").withDescription("Total WRAPS retries consumed by completed history proofs"));
        this.wrapsRetriesPerCompletedProof = (RunningAverageMetric)this.metrics.getOrCreate((MetricConfig)new RunningAverageMetric.Config(CATEGORY, "historyProofRetriesAvg").withDescription("Average WRAPS retries consumed per completed history proof").withUnit("retries").withFormat("%,13.3f"));
        this.registerEagerTransitionMetrics();
    }

    public void observeStage(long constructionId, @NonNull Stage stage, @NonNull Instant consensusNow) {
        Objects.requireNonNull(stage);
        Objects.requireNonNull(consensusNow);
        this.stageObservations.compute(constructionId, (id, previous) -> {
            if (previous == null) {
                return new StageObservation(stage, consensusNow);
            }
            if (previous.stage() != stage) {
                long elapsedMillis = HistoryProofMetrics.elapsedMillis(previous.enteredAt(), consensusNow);
                TransitionMetrics transitionMetrics = this.transitionMetricsFor(previous.stage(), stage);
                if (transitionMetrics != null) {
                    transitionMetrics.update(elapsedMillis);
                }
                return new StageObservation(stage, consensusNow);
            }
            return previous;
        });
    }

    public void recordRetryStarted() {
        this.wrapsRetriesStarted.increment();
    }

    public void recordProofCompleted(long constructionId, int wrapsRetryCount) {
        int retries = Math.max(0, wrapsRetryCount);
        this.proofsProduced.increment();
        if (retries > 0) {
            this.wrapsRetriesOnCompletedProofs.add((long)retries);
        }
        this.wrapsRetriesPerCompletedProof.update((double)retries);
        this.stageObservations.remove(constructionId);
    }

    public void forgetConstruction(long constructionId) {
        this.stageObservations.remove(constructionId);
    }

    private TransitionMetrics transitionMetricsFor(@NonNull Stage from, @NonNull Stage to) {
        return this.transitionMetrics.get(new StageTransition(Objects.requireNonNull(from), Objects.requireNonNull(to)));
    }

    private void registerEagerTransitionMetrics() {
        this.registerTransition(Stage.WAITING_FOR_METADATA, Stage.WAITING_FOR_ASSEMBLY);
        this.registerTransition(Stage.WAITING_FOR_ASSEMBLY, Stage.WRAPS_R1);
        this.registerTransition(Stage.WRAPS_R1, Stage.WRAPS_R2);
        this.registerTransition(Stage.WRAPS_R2, Stage.WRAPS_R3);
        this.registerTransition(Stage.WRAPS_R3, Stage.WRAPS_AGGREGATE);
        this.registerTransition(Stage.WRAPS_AGGREGATE, Stage.COMPLETED);
        for (Stage stage : List.of(Stage.WAITING_FOR_METADATA, Stage.WAITING_FOR_ASSEMBLY, Stage.WRAPS_R1, Stage.WRAPS_R2, Stage.WRAPS_R3, Stage.WRAPS_AGGREGATE)) {
            this.registerTransition(stage, Stage.FAILED);
        }
    }

    private void registerTransition(@NonNull Stage from, @NonNull Stage to) {
        StageTransition transition = new StageTransition(Objects.requireNonNull(from), Objects.requireNonNull(to));
        this.transitionMetrics.putIfAbsent(transition, this.newTransitionMetrics(transition));
    }

    private TransitionMetrics newTransitionMetrics(@NonNull StageTransition transition) {
        String suffix = transition.from().metricToken + "To" + transition.to().metricToken;
        Counter count = (Counter)this.metrics.getOrCreate((MetricConfig)new Counter.Config(CATEGORY, "historyProofTrans" + suffix + "Cnt").withDescription("Number of history proof controller transitions from " + transition.from().label + " to " + transition.to().label));
        RunningAverageMetric averageConsensusMillis = (RunningAverageMetric)this.metrics.getOrCreate((MetricConfig)new RunningAverageMetric.Config(CATEGORY, "historyProofTrans" + suffix + "Ms").withDescription("Average consensus milliseconds elapsed while transitioning from " + transition.from().label + " to " + transition.to().label).withUnit("ms").withFormat("%,13.3f"));
        return new TransitionMetrics(count, averageConsensusMillis);
    }

    private static long elapsedMillis(@NonNull Instant start, @NonNull Instant end) {
        return Math.max(0L, Duration.between(Objects.requireNonNull(start), Objects.requireNonNull(end)).toMillis());
    }

    public static enum Stage {
        WAITING_FOR_METADATA("WMeta", "waiting for metadata"),
        WAITING_FOR_ASSEMBLY("WAsm", "waiting for assembly"),
        WRAPS_R1("R1", "WRAPS R1"),
        WRAPS_R2("R2", "WRAPS R2"),
        WRAPS_R3("R3", "WRAPS R3"),
        WRAPS_AGGREGATE("Agg", "WRAPS aggregate"),
        COMPLETED("Done", "completed"),
        FAILED("Fail", "failed");

        private final String metricToken;
        private final String label;

        private Stage(String metricToken, String label) {
            this.metricToken = Objects.requireNonNull(metricToken);
            this.label = Objects.requireNonNull(label);
        }
    }

    private record StageTransition(Stage from, Stage to) {
    }

    private record TransitionMetrics(Counter count, RunningAverageMetric averageConsensusMillis) {
        void update(long elapsedMillis) {
            this.count.increment();
            this.averageConsensusMillis.update((double)elapsedMillis);
        }
    }

    private record StageObservation(Stage stage, Instant enteredAt) {
    }
}

