/*
 * Decompiled with CFR 0.152.
 */
package com.hedera.node.app.history.impl;

import com.hedera.hapi.node.base.Timestamp;
import com.hedera.hapi.node.state.history.HistoryProof;
import com.hedera.hapi.node.state.history.HistoryProofConstruction;
import com.hedera.hapi.node.state.history.HistoryProofVote;
import com.hedera.hapi.node.state.history.ProofKey;
import com.hedera.hapi.node.state.history.WrapsPhase;
import com.hedera.hapi.node.state.history.WrapsSigningState;
import com.hedera.hapi.util.HapiUtils;
import com.hedera.node.app.history.HistoryLibrary;
import com.hedera.node.app.history.HistoryService;
import com.hedera.node.app.history.ReadableHistoryStore;
import com.hedera.node.app.history.WritableHistoryStore;
import com.hedera.node.app.history.impl.HistoryProofMetrics;
import com.hedera.node.app.history.impl.HistoryProver;
import com.hedera.node.app.history.impl.HistorySubmissions;
import com.hedera.node.app.history.impl.ProofController;
import com.hedera.node.app.history.impl.ProofControllers;
import com.hedera.node.app.history.impl.ProofKeysAccessorImpl;
import com.hedera.node.app.history.impl.WrapsHistoryProver;
import com.hedera.node.app.history.impl.WrapsMpcStateMachine;
import com.hedera.node.app.service.roster.impl.RosterTransitionWeights;
import com.hedera.node.config.data.TssConfig;
import com.hedera.pbj.runtime.io.buffer.Bytes;
import edu.umd.cs.findbugs.annotations.NonNull;
import edu.umd.cs.findbugs.annotations.Nullable;
import java.lang.runtime.SwitchBootstraps;
import java.time.Instant;
import java.util.List;
import java.util.Map;
import java.util.Objects;
import java.util.Optional;
import java.util.TreeMap;
import java.util.concurrent.CompletableFuture;
import java.util.concurrent.Executor;
import java.util.stream.Collectors;
import org.apache.logging.log4j.LogManager;
import org.apache.logging.log4j.Logger;

public class ProofControllerImpl
implements ProofController {
    private static final Logger log = LogManager.getLogger(ProofControllerImpl.class);
    public static final String PROOF_COMPLETE_MSG = "History proof constructed";
    private final long selfId;
    private final Executor executor;
    private final ProofKeysAccessorImpl.SchnorrKeyPair schnorrKeyPair;
    private final HistoryLibrary historyLibrary;
    private final HistoryService historyService;
    private final HistorySubmissions submissions;
    private final RosterTransitionWeights weights;
    private final HistoryProver.Factory proverFactory;
    private final HistoryProofMetrics historyProofMetrics;
    @Nullable
    private final HistoryProof sourceProof;
    private final Map<Long, HistoryProofVote> votes = new TreeMap<Long, HistoryProofVote>();
    private final Map<Long, Bytes> targetProofKeys = new TreeMap<Long, Bytes>();
    private HistoryProofConstruction construction;
    @Nullable
    private CompletableFuture<Void> publicationFuture;
    @Nullable
    private HistoryProver prover;

    public ProofControllerImpl(long selfId, @NonNull ProofKeysAccessorImpl.SchnorrKeyPair schnorrKeyPair, @NonNull HistoryProofConstruction construction, @NonNull RosterTransitionWeights weights, @NonNull Executor executor, @NonNull HistorySubmissions submissions, @NonNull WrapsMpcStateMachine machine, @NonNull List<ReadableHistoryStore.ProofKeyPublication> keyPublications, @NonNull List<ReadableHistoryStore.WrapsMessagePublication> wrapsMessagePublications, @NonNull Map<Long, HistoryProofVote> votes, @NonNull HistoryService historyService, @NonNull HistoryLibrary historyLibrary, @NonNull HistoryProver.Factory proverFactory, @Nullable HistoryProof sourceProof, @NonNull HistoryProofMetrics historyProofMetrics, @NonNull TssConfig tssConfig) {
        Objects.requireNonNull(machine);
        Objects.requireNonNull(tssConfig);
        this.selfId = selfId;
        this.executor = Objects.requireNonNull(executor);
        this.submissions = Objects.requireNonNull(submissions);
        this.weights = Objects.requireNonNull(weights);
        this.construction = Objects.requireNonNull(construction);
        this.proverFactory = Objects.requireNonNull(proverFactory);
        this.sourceProof = sourceProof;
        this.historyProofMetrics = Objects.requireNonNull(historyProofMetrics);
        this.historyLibrary = Objects.requireNonNull(historyLibrary);
        this.historyService = Objects.requireNonNull(historyService);
        this.schnorrKeyPair = Objects.requireNonNull(schnorrKeyPair);
        this.votes.putAll(Objects.requireNonNull(votes));
        if (!construction.hasTargetProof()) {
            Instant cutoffTime = construction.hasGracePeriodEndTime() ? HapiUtils.asInstant((Timestamp)construction.gracePeriodEndTimeOrThrow()) : Instant.MAX;
            keyPublications.forEach(publication -> {
                if (!publication.adoptionTime().isAfter(cutoffTime)) {
                    this.maybeUpdateForProofKey((ReadableHistoryStore.ProofKeyPublication)publication);
                }
            });
            this.prover = this.createProver(tssConfig);
            wrapsMessagePublications.stream().sorted().forEach(publication -> Objects.requireNonNull(this.prover).replayWrapsSigningMessage(this.constructionId(), (ReadableHistoryStore.WrapsMessagePublication)publication));
        }
    }

    @Override
    public long constructionId() {
        return this.construction.constructionId();
    }

    @Override
    public boolean isStillInProgress(@NonNull TssConfig tssConfig) {
        Objects.requireNonNull(tssConfig);
        if (this.construction.hasFailureReason()) {
            return false;
        }
        return !HistoryService.isCompleted(this.construction, tssConfig);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     * Enabled force condition propagation
     * Lifted jumps to return sites
     */
    @Override
    public void advanceConstruction(@NonNull Instant now, @Nullable Bytes metadata, @NonNull WritableHistoryStore historyStore, boolean isActive, @NonNull TssConfig tssConfig) {
        Objects.requireNonNull(now);
        Objects.requireNonNull(historyStore);
        Objects.requireNonNull(tssConfig);
        this.historyProofMetrics.observeStage(this.constructionId(), this.currentStage(metadata), now);
        try {
            HistoryProver.Outcome outcome;
            if (this.construction.hasFailureReason() && !this.retryIfRecoverableFailure(this.construction.failureReasonOrThrow(), historyStore, tssConfig)) {
                return;
            }
            if (!this.isStillInProgress(tssConfig)) {
                return;
            }
            if (metadata == null) {
                if (!isActive) return;
                this.ensureProofKeyPublished();
                return;
            }
            if (!(this.construction.hasTargetProof() || this.construction.hasAssemblyStartTime() || this.construction.hasWrapsSigningState())) {
                if (this.shouldAssemble(now)) {
                    log.info("Assembly start time for construction #{} is {}", (Object)this.construction.constructionId(), (Object)now);
                    this.construction = historyStore.setAssemblyTime(this.construction.constructionId(), now);
                    return;
                } else {
                    if (!isActive) return;
                    this.ensureProofKeyPublished();
                }
                return;
            }
            if (!isActive) {
                return;
            }
            HistoryProver.Outcome outcome2 = outcome = Objects.requireNonNull(this.prover).advance(now, this.construction, metadata, this.targetProofKeys, tssConfig, historyStore.getLedgerId());
            Objects.requireNonNull(outcome2);
            HistoryProver.Outcome outcome3 = outcome2;
            int n = 0;
            switch (SwitchBootstraps.typeSwitch("typeSwitch", new Object[]{HistoryProver.Outcome.InProgress.class, HistoryProver.Outcome.Completed.class, HistoryProver.Outcome.Failed.class}, (Object)outcome3, n)) {
                default: {
                    throw new MatchException(null, null);
                }
                case 0: {
                    HistoryProver.Outcome.InProgress ignored = (HistoryProver.Outcome.InProgress)outcome3;
                    this.construction = historyStore.getConstructionOrThrow(this.constructionId());
                    return;
                }
                case 1: {
                    HistoryProver.Outcome.Completed completed = (HistoryProver.Outcome.Completed)outcome3;
                    this.finishProof(historyStore, completed.proof(), now);
                    return;
                }
                case 2: {
                    HistoryProver.Outcome.Failed failed = (HistoryProver.Outcome.Failed)outcome3;
                    if (this.retryIfRecoverableFailure(failed.reason(), historyStore, tssConfig)) return;
                    log.warn("Failed construction #{} due to {}", (Object)this.constructionId(), (Object)failed.reason());
                    this.construction = historyStore.failForReason(this.constructionId(), failed.reason());
                    return;
                }
            }
        }
        finally {
            this.historyProofMetrics.observeStage(this.constructionId(), this.currentStage(metadata), now);
        }
    }

    @Override
    public void addProofKeyPublication(@NonNull ReadableHistoryStore.ProofKeyPublication publication) {
        Objects.requireNonNull(publication);
        if (!this.construction.hasGracePeriodEndTime()) {
            return;
        }
        this.maybeUpdateForProofKey(publication);
    }

    @Override
    public boolean addWrapsMessagePublication(@NonNull ReadableHistoryStore.WrapsMessagePublication publication, @NonNull WritableHistoryStore writableHistoryStore) {
        Objects.requireNonNull(publication);
        Objects.requireNonNull(writableHistoryStore);
        if (this.construction.hasTargetProof()) {
            return false;
        }
        return Objects.requireNonNull(this.prover).addWrapsSigningMessage(this.constructionId(), publication, writableHistoryStore);
    }

    @Override
    public void addProofVote(long nodeId, @NonNull HistoryProofVote vote, @NonNull Instant now, @NonNull WritableHistoryStore historyStore) {
        HistoryProofVote congruentVote;
        Objects.requireNonNull(vote);
        Objects.requireNonNull(now);
        Objects.requireNonNull(historyStore);
        if (this.construction.hasTargetProof() || this.votes.containsKey(nodeId)) {
            return;
        }
        if (vote.hasProof()) {
            this.votes.put(nodeId, vote);
        } else if (vote.hasCongruentNodeId() && (congruentVote = this.votes.get(vote.congruentNodeIdOrThrow())) != null && congruentVote.hasProof()) {
            this.votes.put(nodeId, congruentVote);
        }
        historyStore.addProofVote(nodeId, this.construction.constructionId(), vote);
        Map<HistoryProof, Long> proofWeights = this.votes.entrySet().stream().collect(Collectors.groupingBy(entry -> ((HistoryProofVote)entry.getValue()).proofOrThrow(), Collectors.summingLong(entry -> this.weights.sourceWeightOf(((Long)entry.getKey()).longValue()))));
        Optional<HistoryProof> maybeWinningProof = proofWeights.entrySet().stream().filter(entry -> (Long)entry.getValue() >= this.weights.sourceWeightThreshold()).map(Map.Entry::getKey).findFirst();
        maybeWinningProof.ifPresent(proof -> this.finishProof(historyStore, (HistoryProof)proof, now));
        Objects.requireNonNull(this.prover).observeProofVote(nodeId, vote, maybeWinningProof.isPresent());
    }

    @Override
    public void cancelPendingWork() {
        StringBuilder sb = new StringBuilder("Canceled work on proof construction #").append(this.construction.constructionId());
        boolean canceledSomething = false;
        if (this.publicationFuture != null && !this.publicationFuture.isDone()) {
            sb.append("\n  * In-flight publication");
            this.publicationFuture.cancel(true);
            canceledSomething = true;
        }
        if (this.prover != null && this.prover.cancelPendingWork()) {
            sb.append("\n  * In-flight prover work");
            canceledSomething = true;
        }
        if (canceledSomething) {
            log.info(sb.toString());
        }
        this.historyProofMetrics.forgetConstruction(this.constructionId());
    }

    private void finishProof(@NonNull WritableHistoryStore historyStore, @NonNull HistoryProof proof, @NonNull Instant now) {
        this.construction = historyStore.completeProof(this.construction.constructionId(), proof);
        this.historyProofMetrics.observeStage(this.constructionId(), HistoryProofMetrics.Stage.COMPLETED, now);
        this.historyProofMetrics.recordProofCompleted(this.constructionId(), this.construction.wrapsRetryCount());
        log.info("{} (#{}, WRAPS-extensible? {})", (Object)PROOF_COMPLETE_MSG, (Object)this.construction.constructionId(), (Object)ProofControllers.isWrapsExtensible(proof));
        this.historyService.onFinished(historyStore, this.construction, this.weights.targetNodeWeights());
    }

    private boolean retryIfRecoverableFailure(@NonNull String reason, @NonNull WritableHistoryStore historyStore, @NonNull TssConfig tssConfig) {
        Objects.requireNonNull(reason);
        Objects.requireNonNull(historyStore);
        Objects.requireNonNull(tssConfig);
        if (!WrapsHistoryProver.isRecoverableFailure(reason)) {
            return false;
        }
        int maxWrapsRetries = tssConfig.maxWrapsRetries();
        if (this.construction.wrapsRetryCount() >= maxWrapsRetries) {
            log.warn("Construction #{} exhausted WRAPS retry budget ({}) after recoverable failure '{}'", (Object)this.constructionId(), (Object)maxWrapsRetries, (Object)reason);
            return false;
        }
        if (this.prover != null) {
            this.prover.cancelPendingWork();
        }
        this.construction = historyStore.restartWrapsSigning(this.constructionId(), this.weights.sourceNodeIds());
        this.historyProofMetrics.recordRetryStarted();
        this.prover = this.createProver(tssConfig);
        log.warn("Restarted WRAPS signing for construction #{} (retry {}/{}) after recoverable failure '{}'", (Object)this.constructionId(), (Object)this.construction.wrapsRetryCount(), (Object)maxWrapsRetries, (Object)reason);
        return true;
    }

    private boolean shouldAssemble(@NonNull Instant now) {
        if (this.targetProofKeys.size() == this.weights.numTargetNodesInSource()) {
            log.info("All target nodes have published proof keys for construction #{}", (Object)this.construction.constructionId());
            return true;
        }
        if (now.isBefore(HapiUtils.asInstant((Timestamp)this.construction.gracePeriodEndTimeOrThrow()))) {
            return false;
        }
        return this.publishedWeight() >= this.weights.targetWeightThreshold();
    }

    private void ensureProofKeyPublished() {
        if (this.publicationFuture == null && this.weights.targetIncludes(this.selfId) && !this.targetProofKeys.containsKey(this.selfId)) {
            log.info("Publishing Schnorr key for construction #{}", (Object)this.construction.constructionId());
            this.publicationFuture = CompletableFuture.runAsync(() -> this.submissions.submitProofKeyPublication(this.schnorrKeyPair.publicKey()).join(), this.executor).exceptionally(e -> {
                log.error("Error publishing proof key", e);
                return null;
            });
        }
    }

    private void maybeUpdateForProofKey(@NonNull ReadableHistoryStore.ProofKeyPublication publication) {
        long nodeId = publication.nodeId();
        if (!this.weights.targetIncludes(nodeId)) {
            return;
        }
        this.targetProofKeys.put(nodeId, publication.proofKey());
    }

    private long publishedWeight() {
        return this.targetProofKeys.keySet().stream().mapToLong(arg_0 -> ((RosterTransitionWeights)this.weights).targetWeightOf(arg_0)).sum();
    }

    private HistoryProver createProver(@NonNull TssConfig tssConfig) {
        Map<Long, Bytes> sourceProofKeys = this.sourceProof == null ? this.targetProofKeys : this.sourceProof.targetProofKeys().stream().collect(Collectors.toMap(ProofKey::nodeId, ProofKey::key));
        return this.proverFactory.create(this.selfId, tssConfig, this.schnorrKeyPair, this.sourceProof, this.weights, sourceProofKeys, this.executor, this.historyLibrary, this.submissions);
    }

    private HistoryProofMetrics.Stage currentStage(@Nullable Bytes metadata) {
        if (this.construction.hasTargetProof()) {
            return HistoryProofMetrics.Stage.COMPLETED;
        }
        if (this.construction.hasFailureReason()) {
            return HistoryProofMetrics.Stage.FAILED;
        }
        if (metadata == null) {
            return HistoryProofMetrics.Stage.WAITING_FOR_METADATA;
        }
        if (!this.construction.hasAssemblyStartTime() && !this.construction.hasWrapsSigningState()) {
            return HistoryProofMetrics.Stage.WAITING_FOR_ASSEMBLY;
        }
        WrapsPhase phase = this.construction.wrapsSigningStateOrElse(WrapsSigningState.DEFAULT).phase();
        return switch (phase) {
            default -> throw new MatchException(null, null);
            case WrapsPhase.R1 -> HistoryProofMetrics.Stage.WRAPS_R1;
            case WrapsPhase.R2 -> HistoryProofMetrics.Stage.WRAPS_R2;
            case WrapsPhase.R3 -> HistoryProofMetrics.Stage.WRAPS_R3;
            case WrapsPhase.AGGREGATE, WrapsPhase.POST_AGGREGATION, WrapsPhase.UNRECOGNIZED -> HistoryProofMetrics.Stage.WRAPS_AGGREGATE;
        };
    }
}

