/*
 * Decompiled with CFR 0.152.
 */
package com.swirlds.virtualmap.config;

import com.swirlds.config.api.ConfigData;

@ConfigData(value="virtualMap")
public record VirtualMapConfig(double percentHashThreads, int numHashThreads, int virtualHasherChunkHeight, String reconnectMode, int reconnectFlushInterval, double percentCleanerThreads, int numCleanerThreads, long copyFlushCandidateThreshold, double familyThrottlePercent, long familyThrottleThreshold, int fullRehashTimeoutMs) {
    private static final double UNIT_FRACTION_PERCENT = 100.0;

    public int getNumHashThreads() {
        int threads = this.numHashThreads() == -1 ? (int)((double)Runtime.getRuntime().availableProcessors() * (this.percentHashThreads() / 100.0)) : this.numHashThreads();
        return Math.max(1, threads);
    }

    public int getNumCleanerThreads() {
        int numProcessors = Runtime.getRuntime().availableProcessors();
        int threads = this.numCleanerThreads() == -1 ? (int)((double)numProcessors * (this.percentCleanerThreads() / 100.0)) : this.numCleanerThreads();
        return Math.max(1, threads);
    }

    public long getFamilyThrottleThreshold() {
        long threshold = this.familyThrottleThreshold();
        if (threshold >= 0L) {
            return threshold;
        }
        double percent = this.familyThrottlePercent();
        if (percent > 0.0) {
            long maxHeapSize = Runtime.getRuntime().maxMemory();
            long copyFlushThreshold = this.copyFlushCandidateThreshold();
            return Math.max(copyFlushThreshold, (long)((double)maxHeapSize * percent / 100.0));
        }
        if (Math.abs(percent) < 1.0E-6) {
            return 0L;
        }
        throw new IllegalArgumentException("Wrong family throttle threshold/percent config");
    }
}

