/*
 * Decompiled with CFR 0.152.
 */
package com.hedera.node.app.service.contract.impl.state.hooks;

import com.hedera.hapi.node.base.ContractID;
import com.hedera.hapi.node.state.contract.SlotKey;
import com.hedera.hapi.node.state.contract.SlotValue;
import com.hedera.hapi.node.state.hooks.EvmHookSlotKey;
import com.hedera.hapi.node.state.hooks.EvmHookState;
import com.hedera.hapi.util.HapiUtils;
import com.hedera.node.app.service.contract.impl.exec.scope.HederaNativeOperations;
import com.hedera.node.app.service.contract.impl.exec.systemcontracts.HtsSystemContract;
import com.hedera.node.app.service.contract.impl.state.ContractStateStore;
import com.hedera.node.app.service.contract.impl.state.DispatchingEvmFrameState;
import com.hedera.node.app.service.contract.impl.state.StorageAccess;
import com.hedera.node.app.service.contract.impl.state.StorageAccesses;
import com.hedera.node.app.service.contract.impl.state.TxStorageUsage;
import com.hedera.node.app.service.contract.impl.state.WritableEvmHookStore;
import com.hedera.node.app.service.contract.impl.state.hooks.ProxyEvmHook;
import com.hedera.node.app.service.contract.impl.utils.ConversionUtils;
import com.hedera.node.app.service.entityid.EntityIdFactory;
import edu.umd.cs.findbugs.annotations.NonNull;
import edu.umd.cs.findbugs.annotations.Nullable;
import java.util.ArrayList;
import java.util.HashSet;
import java.util.List;
import java.util.Objects;
import java.util.TreeMap;
import org.apache.tuweni.bytes.Bytes;
import org.apache.tuweni.units.bigints.UInt256;
import org.hyperledger.besu.datatypes.Address;
import org.hyperledger.besu.evm.account.MutableAccount;
import org.hyperledger.besu.evm.code.CodeFactory;

public class HookEvmFrameState
extends DispatchingEvmFrameState {
    private final EvmHookState hook;
    private final CodeFactory codeFactory;
    private final WritableEvmHookStore writableEvmHookStore;
    private final EntityIdFactory entityIdFactory;
    private final ContractID hooksContractId;

    public HookEvmFrameState(@NonNull HederaNativeOperations nativeOperations, @NonNull ContractStateStore contractStateStore, @NonNull WritableEvmHookStore writableEvmHookStore, @NonNull CodeFactory codeFactory, @NonNull EvmHookState hook) {
        super(nativeOperations, contractStateStore, codeFactory);
        this.entityIdFactory = Objects.requireNonNull(nativeOperations).entityIdFactory();
        this.hook = Objects.requireNonNull(hook);
        this.codeFactory = Objects.requireNonNull(codeFactory);
        this.writableEvmHookStore = Objects.requireNonNull(writableEvmHookStore);
        this.hooksContractId = this.entityIdFactory.newContractId(365L);
    }

    @Override
    @Nullable
    public MutableAccount getMutableAccount(@NonNull Address address) {
        if (address.equals((Object)HtsSystemContract.HTS_HOOKS_CONTRACT_ADDRESS)) {
            return new ProxyEvmHook(this, this.hook, this.codeFactory, this.entityIdFactory);
        }
        return super.getMutableAccount(address);
    }

    @Override
    @Nullable
    public Address getAddress(long number) {
        if (number == this.hooksContractId.contractNumOrThrow()) {
            return HtsSystemContract.HTS_HOOKS_CONTRACT_ADDRESS;
        }
        return super.getAddress(number);
    }

    @Override
    @NonNull
    public UInt256 getStorageValue(ContractID contractID, @NonNull UInt256 key) {
        if (this.hooksContractId.equals((Object)contractID)) {
            EvmHookSlotKey slotKey = WritableEvmHookStore.minimalKey(this.hook.hookIdOrThrow(), com.hedera.pbj.runtime.io.buffer.Bytes.wrap((byte[])key.toArrayUnsafe()));
            SlotValue value = this.writableEvmHookStore.getSlotValue(slotKey);
            if (value == null) {
                return UInt256.ZERO;
            }
            return UInt256.fromBytes((Bytes)ConversionUtils.pbjToTuweniBytes(value.value()));
        }
        return super.getStorageValue(contractID, key);
    }

    @Override
    @NonNull
    public UInt256 getOriginalStorageValue(ContractID contractID, @NonNull UInt256 key) {
        if (this.hooksContractId.equals((Object)contractID)) {
            EvmHookSlotKey slotKey = WritableEvmHookStore.minimalKey(this.hook.hookIdOrThrow(), com.hedera.pbj.runtime.io.buffer.Bytes.wrap((byte[])key.toArrayUnsafe()));
            SlotValue value = this.writableEvmHookStore.getOriginalSlotValue(slotKey);
            if (value == null) {
                return UInt256.ZERO;
            }
            return UInt256.fromBytes((Bytes)ConversionUtils.pbjToTuweniBytes(value.value()));
        }
        return super.getOriginalStorageValue(contractID, key);
    }

    @Override
    public void setStorageValue(@NonNull ContractID contractID, @NonNull UInt256 key, @NonNull UInt256 value) {
        if (this.hooksContractId.equals((Object)contractID)) {
            EvmHookSlotKey slotKey = WritableEvmHookStore.minimalKey(this.hook.hookIdOrThrow(), com.hedera.pbj.runtime.io.buffer.Bytes.wrap((byte[])key.toArrayUnsafe()));
            SlotValue oldSlotValue = this.writableEvmHookStore.getSlotValue(slotKey);
            if (oldSlotValue == null && value.isZero()) {
                return;
            }
            SlotValue slotValue = new SlotValue(ConversionUtils.tuweniToPbjBytes((Bytes)Objects.requireNonNull(value)), oldSlotValue == null ? com.hedera.pbj.runtime.io.buffer.Bytes.EMPTY : oldSlotValue.previousKey(), oldSlotValue == null ? com.hedera.pbj.runtime.io.buffer.Bytes.EMPTY : oldSlotValue.nextKey());
            this.writableEvmHookStore.updateStorage(slotKey, slotValue);
            return;
        }
        super.setStorageValue(contractID, key, value);
    }

    @Override
    @NonNull
    public TxStorageUsage getTxStorageUsage(boolean includeChangedKeys) {
        TreeMap<ContractID, List> modifications = new TreeMap<ContractID, List>(HapiUtils.CONTRACT_ID_COMPARATOR);
        HashSet<SlotKey> changedKeys = includeChangedKeys ? new HashSet<SlotKey>() : null;
        this.writableEvmHookStore.getModifiedEvmHookSlotKeys().forEach(slotKey -> {
            StorageAccess access = StorageAccess.newWrite(slotKey.key().equals((Object)WritableEvmHookStore.ZERO_KEY) ? UInt256.ZERO : ConversionUtils.pbjToTuweniUInt256(slotKey.key()), this.valueOrZero(this.writableEvmHookStore.getOriginalSlotValue((EvmHookSlotKey)slotKey)), this.valueOrZero(this.writableEvmHookStore.getSlotValue((EvmHookSlotKey)slotKey)));
            modifications.computeIfAbsent(this.hooksContractId, k -> new ArrayList()).add(access);
            if (includeChangedKeys && access.isLogicalChange()) {
                changedKeys.add(new SlotKey(this.hooksContractId, slotKey.key()));
            }
        });
        ArrayList<StorageAccesses> allChanges = new ArrayList<StorageAccesses>();
        modifications.forEach((number, storageAccesses) -> allChanges.add(new StorageAccesses((ContractID)number, (List<StorageAccess>)storageAccesses)));
        TxStorageUsage contractStorageChanges = super.getTxStorageUsage(includeChangedKeys);
        if (contractStorageChanges.accesses() != null) {
            allChanges.addAll(contractStorageChanges.accesses());
        }
        if (includeChangedKeys && contractStorageChanges.changedKeys() != null) {
            changedKeys.addAll(contractStorageChanges.changedKeys());
        }
        return new TxStorageUsage(allChanges, changedKeys);
    }
}

