/*
 * Decompiled with CFR 0.152.
 */
package com.hedera.node.app.service.contract.impl.handlers;

import com.google.common.annotations.VisibleForTesting;
import com.hedera.hapi.node.base.AccountID;
import com.hedera.hapi.node.base.ContractID;
import com.hedera.hapi.node.base.HookEntityId;
import com.hedera.hapi.node.base.Key;
import com.hedera.hapi.node.base.ResponseCodeEnum;
import com.hedera.hapi.node.base.SubType;
import com.hedera.hapi.node.base.Timestamp;
import com.hedera.hapi.node.contract.ContractUpdateTransactionBody;
import com.hedera.hapi.node.hooks.HookCreationDetails;
import com.hedera.hapi.node.state.token.Account;
import com.hedera.hapi.node.transaction.TransactionBody;
import com.hedera.hapi.util.HapiUtils;
import com.hedera.node.app.hapi.utils.CommonPbjConverters;
import com.hedera.node.app.hapi.utils.fee.SigValueObj;
import com.hedera.node.app.hapi.utils.fee.SmartContractFeeBuilder;
import com.hedera.node.app.hapi.utils.keys.KeyUtils;
import com.hedera.node.app.service.contract.impl.records.ContractUpdateStreamBuilder;
import com.hedera.node.app.service.entityid.EntityIdFactory;
import com.hedera.node.app.service.token.HookDispatchUtils;
import com.hedera.node.app.service.token.ReadableAccountStore;
import com.hedera.node.app.service.token.api.AccountSummariesApi;
import com.hedera.node.app.service.token.api.TokenServiceApi;
import com.hedera.node.app.spi.fees.FeeContext;
import com.hedera.node.app.spi.fees.Fees;
import com.hedera.node.app.spi.validation.ExpiryMeta;
import com.hedera.node.app.spi.validation.Validations;
import com.hedera.node.app.spi.workflows.HandleContext;
import com.hedera.node.app.spi.workflows.HandleException;
import com.hedera.node.app.spi.workflows.PreCheckException;
import com.hedera.node.app.spi.workflows.PreHandleContext;
import com.hedera.node.app.spi.workflows.PureChecksContext;
import com.hedera.node.app.spi.workflows.TransactionHandler;
import com.hedera.node.config.data.EntitiesConfig;
import com.hedera.node.config.data.LedgerConfig;
import com.hedera.node.config.data.TokensConfig;
import com.hederahashgraph.api.proto.java.FeeData;
import edu.umd.cs.findbugs.annotations.NonNull;
import edu.umd.cs.findbugs.annotations.Nullable;
import java.util.List;
import java.util.Objects;
import java.util.Optional;
import javax.inject.Inject;
import javax.inject.Singleton;

@Singleton
public class ContractUpdateHandler
implements TransactionHandler {
    private final SmartContractFeeBuilder usageEstimator = new SmartContractFeeBuilder();
    private final EntityIdFactory entityIdFactory;
    public static final int UNLIMITED_AUTOMATIC_ASSOCIATIONS = -1;

    @Inject
    public ContractUpdateHandler(@NonNull EntityIdFactory entityIdFactory) {
        this.entityIdFactory = Objects.requireNonNull(entityIdFactory);
    }

    public void preHandle(@NonNull PreHandleContext context) throws PreCheckException {
        Objects.requireNonNull(context);
        ContractUpdateTransactionBody op = context.body().contractUpdateInstanceOrThrow();
        if (this.isAdminSigRequired(op)) {
            ContractID targetId;
            ReadableAccountStore accountStore = (ReadableAccountStore)context.createStore(ReadableAccountStore.class);
            Account maybeContract = accountStore.getContractById(targetId = op.contractIDOrThrow());
            if (maybeContract != null && maybeContract.keyOrThrow().key().kind() == Key.KeyOneOfType.CONTRACT_ID) {
                throw new PreCheckException(ResponseCodeEnum.MODIFYING_IMMUTABLE_CONTRACT);
            }
            context.requireKeyOrThrow(targetId, ResponseCodeEnum.INVALID_CONTRACT_ID);
        }
        if (this.hasCryptoAdminKey(op)) {
            context.requireKey(op.adminKeyOrThrow());
        }
        if (op.hasAutoRenewAccountId() && !op.autoRenewAccountIdOrThrow().equals((Object)AccountID.DEFAULT)) {
            context.requireKeyOrThrow(op.autoRenewAccountIdOrThrow(), ResponseCodeEnum.INVALID_AUTORENEW_ACCOUNT);
        }
    }

    public void pureChecks(@NonNull PureChecksContext context) throws PreCheckException {
        Objects.requireNonNull(context);
        TransactionBody txn = context.body();
        ContractUpdateTransactionBody op = txn.contractUpdateInstanceOrThrow();
        Validations.mustExist((Object)op.contractID(), (ResponseCodeEnum)ResponseCodeEnum.INVALID_CONTRACT_ID);
        if (op.hasAdminKey() && this.processAdminKey(op)) {
            throw new PreCheckException(ResponseCodeEnum.INVALID_ADMIN_KEY);
        }
        HookDispatchUtils.validateHookDuplicates((List)op.hookCreationDetails(), (List)op.hookIdsToDelete());
    }

    private boolean isAdminSigRequired(ContractUpdateTransactionBody op) {
        ContractUpdateTransactionBody withDefaultExpirationTimeAndTarget = op.copyBuilder().contractID(ContractUpdateTransactionBody.DEFAULT.contractID()).expirationTime(ContractUpdateTransactionBody.DEFAULT.expirationTime()).build();
        return !withDefaultExpirationTimeAndTarget.equals((Object)ContractUpdateTransactionBody.DEFAULT);
    }

    private boolean hasCryptoAdminKey(ContractUpdateTransactionBody op) {
        return op.hasAdminKey() && !op.adminKeyOrThrow().hasContractID();
    }

    public void handle(@NonNull HandleContext context) throws HandleException {
        TransactionBody txn = Objects.requireNonNull(context).body();
        ContractUpdateTransactionBody op = txn.contractUpdateInstanceOrThrow();
        ContractID target = op.contractIDOrThrow();
        ReadableAccountStore accountStore = (ReadableAccountStore)context.storeFactory().readableStore(ReadableAccountStore.class);
        Account toBeUpdated = accountStore.getContractById(target);
        this.validateSemantics(toBeUpdated, context, op, accountStore);
        Account.Builder changed = this.update(Objects.requireNonNull(toBeUpdated), context, op);
        this.updateHooks(context, op, changed, toBeUpdated);
        ((TokenServiceApi)context.storeFactory().serviceApi(TokenServiceApi.class)).updateContract(changed.build());
        ((ContractUpdateStreamBuilder)context.savepointStack().getBaseBuilder(ContractUpdateStreamBuilder.class)).contractID(this.entityIdFactory.newContractId(toBeUpdated.accountIdOrThrow().accountNumOrThrow().longValue()));
    }

    @VisibleForTesting
    public void updateHooks(@NonNull HandleContext context, @NonNull ContractUpdateTransactionBody op, @NonNull Account.Builder builder, @NonNull Account account) {
        Long headAfterDeletes;
        HookEntityId hookEntityId = HookEntityId.newBuilder().accountId(account.accountIdOrThrow()).build();
        Long l = headAfterDeletes = account.numberHooksInUse() == 0L ? null : Long.valueOf(account.firstHookId());
        if (!op.hookIdsToDelete().isEmpty()) {
            headAfterDeletes = HookDispatchUtils.dispatchHookDeletions((HandleContext)context, (List)op.hookIdsToDelete(), (Long)headAfterDeletes, (HookEntityId)hookEntityId);
        }
        if (!op.hookCreationDetails().isEmpty()) {
            int slotsDelta = HookDispatchUtils.dispatchHookCreations((HandleContext)context, (List)op.hookCreationDetails(), (Long)headAfterDeletes, (HookEntityId)hookEntityId);
            builder.firstHookId(((HookCreationDetails)op.hookCreationDetails().getFirst()).hookId());
            builder.numberEvmHookStorageSlots(account.numberEvmHookStorageSlots() + (long)slotsDelta);
        } else if (!op.hookIdsToDelete().isEmpty()) {
            builder.firstHookId(headAfterDeletes == null ? 0L : headAfterDeletes);
        }
        if (!op.hookCreationDetails().isEmpty() || !op.hookIdsToDelete().isEmpty()) {
            long current = account.numberHooksInUse();
            builder.numberHooksInUse(current - (long)op.hookIdsToDelete().size() + (long)op.hookCreationDetails().size());
        }
    }

    private void validateSemantics(@Nullable Account contract, @NonNull HandleContext context, @NonNull ContractUpdateTransactionBody op, @NonNull ReadableAccountStore accountStore) {
        HandleException.validateTrue((contract != null ? 1 : 0) != 0, (ResponseCodeEnum)ResponseCodeEnum.INVALID_CONTRACT_ID);
        HandleException.validateTrue((!contract.deleted() ? 1 : 0) != 0, (ResponseCodeEnum)ResponseCodeEnum.INVALID_CONTRACT_ID);
        if (op.hasExpirationTime()) {
            try {
                context.attributeValidator().validateExpiry(op.expirationTimeOrThrow().seconds());
            }
            catch (HandleException e) {
                HandleException.validateFalse((boolean)contract.expiredAndPendingRemoval(), (ResponseCodeEnum)ResponseCodeEnum.CONTRACT_EXPIRED_AND_PENDING_REMOVAL);
                throw e;
            }
        }
        HandleException.validateFalse((this.nonExpiryFieldUpdated(op) && !this.isMutable(contract) ? 1 : 0) != 0, (ResponseCodeEnum)ResponseCodeEnum.MODIFYING_IMMUTABLE_CONTRACT);
        HandleException.validateFalse((boolean)this.reducesExpiry(op, contract.expirationSecond()), (ResponseCodeEnum)ResponseCodeEnum.EXPIRATION_REDUCTION_NOT_ALLOWED);
        if (op.hasMaxAutomaticTokenAssociations()) {
            LedgerConfig ledgerConfig = (LedgerConfig)context.configuration().getConfigData(LedgerConfig.class);
            EntitiesConfig entitiesConfig = (EntitiesConfig)context.configuration().getConfigData(EntitiesConfig.class);
            TokensConfig tokensConfig = (TokensConfig)context.configuration().getConfigData(TokensConfig.class);
            long newMaxAssociations = op.maxAutomaticTokenAssociationsOrThrow().intValue();
            if (entitiesConfig.unlimitedAutoAssociationsEnabled() && newMaxAssociations < 0L) {
                HandleException.validateTrue((newMaxAssociations == -1L ? 1 : 0) != 0, (ResponseCodeEnum)ResponseCodeEnum.INVALID_MAX_AUTO_ASSOCIATIONS);
            } else {
                HandleException.validateFalse((newMaxAssociations < 0L ? 1 : 0) != 0, (ResponseCodeEnum)ResponseCodeEnum.INVALID_MAX_AUTO_ASSOCIATIONS);
                HandleException.validateFalse((newMaxAssociations > (long)ledgerConfig.maxAutoAssociations() ? 1 : 0) != 0, (ResponseCodeEnum)ResponseCodeEnum.REQUESTED_NUM_AUTOMATIC_ASSOCIATIONS_EXCEEDS_ASSOCIATION_LIMIT);
                HandleException.validateFalse((newMaxAssociations < (long)contract.maxAutoAssociations() ? 1 : 0) != 0, (ResponseCodeEnum)ResponseCodeEnum.EXISTING_AUTOMATIC_ASSOCIATIONS_EXCEED_GIVEN_LIMIT);
                HandleException.validateFalse((entitiesConfig.limitTokenAssociations() && newMaxAssociations > (long)tokensConfig.maxPerAccount() ? 1 : 0) != 0, (ResponseCodeEnum)ResponseCodeEnum.REQUESTED_NUM_AUTOMATIC_ASSOCIATIONS_EXCEEDS_ASSOCIATION_LIMIT);
            }
        }
        ExpiryMeta currentMetadata = new ExpiryMeta(contract.expirationSecond(), contract.autoRenewSeconds(), contract.autoRenewAccountId());
        ExpiryMeta updateMeta = new ExpiryMeta(op.hasExpirationTime() ? op.expirationTimeOrThrow().seconds() : ExpiryMeta.NA, op.hasAutoRenewPeriod() ? op.autoRenewPeriodOrThrow().seconds() : ExpiryMeta.NA, null);
        context.expiryValidator().resolveUpdateAttempt(currentMetadata, updateMeta);
        ((TokenServiceApi)context.storeFactory().serviceApi(TokenServiceApi.class)).assertValidStakingElectionForUpdate(op.hasDeclineReward(), ((ContractUpdateTransactionBody.StakedIdOneOfType)op.stakedId().kind()).name(), op.stakedAccountId(), op.stakedNodeId(), accountStore, context.networkInfo());
    }

    private boolean processAdminKey(ContractUpdateTransactionBody op) {
        if (HapiUtils.EMPTY_KEY_LIST.equals((Object)op.adminKey())) {
            return false;
        }
        return this.keyIfAcceptable(op.adminKey());
    }

    private boolean keyIfAcceptable(Key candidate) {
        boolean keyIsNotValid = !KeyUtils.isValid((Key)candidate);
        return keyIsNotValid || candidate.contractID() != null;
    }

    private boolean nonExpiryFieldUpdated(ContractUpdateTransactionBody op) {
        return this.isAdminSigRequired(op);
    }

    private boolean affectsMemo(@NonNull ContractUpdateTransactionBody op) {
        return op.hasMemoWrapper() || !op.memoOrElse("").isEmpty();
    }

    private boolean isMutable(Account contract) {
        return Optional.ofNullable(contract.key()).map(key -> !key.hasContractID()).orElse(false);
    }

    private boolean reducesExpiry(ContractUpdateTransactionBody op, long curExpiry) {
        return op.hasExpirationTime() && op.expirationTimeOrThrow().seconds() < curExpiry;
    }

    public Account.Builder update(@NonNull Account contract, @NonNull HandleContext context, @NonNull ContractUpdateTransactionBody op) {
        Account.Builder builder = contract.copyBuilder();
        if (op.hasAdminKey()) {
            if (HapiUtils.EMPTY_KEY_LIST.equals((Object)op.adminKey())) {
                try {
                    ContractID contractID = ContractID.newBuilder().shardNum(contract.accountIdOrThrow().shardNum()).realmNum(contract.accountIdOrThrow().realmNum()).contractNum(contract.accountIdOrThrow().accountNumOrThrow().longValue()).build();
                    Key key = Key.newBuilder().contractID(contractID).build();
                    builder.key(key);
                }
                catch (NullPointerException e) {
                    builder.key(contract.key());
                }
            } else {
                builder.key(op.adminKey());
            }
        }
        if (op.hasExpirationTime()) {
            if (contract.expiredAndPendingRemoval()) {
                builder.expiredAndPendingRemoval(false);
            }
            builder.expirationSecond(op.expirationTimeOrThrow().seconds());
        }
        if (op.hasAutoRenewPeriod()) {
            builder.autoRenewSeconds(op.autoRenewPeriodOrThrow().seconds());
        }
        if (this.affectsMemo(op)) {
            String newMemo = op.hasMemoWrapper() ? op.memoWrapperOrThrow() : op.memo();
            Objects.requireNonNull(newMemo);
            context.attributeValidator().validateMemo(newMemo);
            builder.memo(newMemo);
        }
        if (op.hasStakedAccountId()) {
            if (AccountSummariesApi.SENTINEL_ACCOUNT_ID.equals((Object)op.stakedAccountId())) {
                builder.stakedAccountId((AccountID)null);
            } else {
                builder.stakedAccountId(op.stakedAccountId());
            }
        } else if (op.hasStakedNodeId()) {
            builder.stakedNodeId(op.stakedNodeIdOrThrow().longValue());
        }
        if (op.hasDeclineReward()) {
            builder.declineReward(op.declineRewardOrThrow().booleanValue());
        }
        if (op.hasAutoRenewAccountId()) {
            builder.autoRenewAccountId(op.autoRenewAccountId());
        }
        if (op.hasMaxAutomaticTokenAssociations()) {
            builder.maxAutoAssociations(op.maxAutomaticTokenAssociationsOrThrow().intValue());
        }
        return builder;
    }

    @NonNull
    public Fees calculateFees(@NonNull FeeContext feeContext) {
        Objects.requireNonNull(feeContext);
        TransactionBody op = feeContext.body();
        ContractID contractId = op.contractUpdateInstanceOrThrow().contractIDOrElse(ContractID.DEFAULT);
        ReadableAccountStore accountStore = (ReadableAccountStore)feeContext.readableStore(ReadableAccountStore.class);
        Account contract = accountStore.getContractById(contractId);
        return feeContext.feeCalculatorFactory().feeCalculator(SubType.DEFAULT).legacyCalculate(sigValueObj -> this.usageGiven(CommonPbjConverters.fromPbj((TransactionBody)op), (SigValueObj)sigValueObj, contract));
    }

    private FeeData usageGiven(@NonNull com.hederahashgraph.api.proto.java.TransactionBody txn, @NonNull SigValueObj sigUsage, @Nullable Account contract) {
        if (contract == null) {
            return Fees.CONSTANT_FEE_DATA;
        }
        return this.usageEstimator.getContractUpdateTxFeeMatrices(txn, CommonPbjConverters.fromPbj((Timestamp)new Timestamp(contract.expirationSecond(), 0)), sigUsage);
    }
}

