/*
 * Decompiled with CFR 0.152.
 */
package com.hedera.node.app.blocks.impl.streaming;

import com.hedera.node.app.blocks.impl.streaming.AbstractBlockNodeConnection;
import com.hedera.node.app.blocks.impl.streaming.BlockNodeClientFactory;
import com.hedera.node.app.blocks.impl.streaming.BlockNodeStatus;
import com.hedera.node.app.blocks.impl.streaming.ConnectionState;
import com.hedera.node.app.blocks.impl.streaming.config.BlockNodeConfiguration;
import com.hedera.node.config.ConfigProvider;
import com.hedera.node.config.data.BlockNodeConnectionConfig;
import com.hedera.pbj.runtime.grpc.GrpcException;
import edu.umd.cs.findbugs.annotations.NonNull;
import edu.umd.cs.findbugs.annotations.Nullable;
import java.time.Duration;
import java.util.Objects;
import java.util.concurrent.Callable;
import java.util.concurrent.ExecutionException;
import java.util.concurrent.ExecutorService;
import java.util.concurrent.Future;
import java.util.concurrent.TimeUnit;
import java.util.concurrent.atomic.AtomicLong;
import java.util.concurrent.atomic.AtomicReference;
import org.apache.logging.log4j.LogManager;
import org.apache.logging.log4j.Logger;
import org.hiero.block.api.BlockNodeServiceInterface;
import org.hiero.block.api.ServerStatusRequest;
import org.hiero.block.api.ServerStatusResponse;

public class BlockNodeServiceConnection
extends AbstractBlockNodeConnection {
    private static final Logger logger = LogManager.getLogger(BlockNodeServiceConnection.class);
    private static final AtomicLong clientCtr = new AtomicLong(0L);
    private final AtomicReference<ServiceClientHolder> clientRef = new AtomicReference();
    private final ExecutorService blockingIoExecutor;
    private final BlockNodeClientFactory clientFactory;

    public BlockNodeServiceConnection(@NonNull ConfigProvider configProvider, @NonNull BlockNodeConfiguration nodeConfig, @NonNull ExecutorService blockingIoExecutor, @NonNull BlockNodeClientFactory clientFactory) {
        super(AbstractBlockNodeConnection.ConnectionType.SERVER_STATUS, nodeConfig, configProvider);
        this.blockingIoExecutor = Objects.requireNonNull(blockingIoExecutor, "Blocking I/O executor is required");
        this.clientFactory = Objects.requireNonNull(clientFactory, "client factory is required");
    }

    private Duration operationTimeout() {
        return ((BlockNodeConnectionConfig)this.configProvider().getConfiguration().getConfigData(BlockNodeConnectionConfig.class)).pipelineOperationTimeout();
    }

    @Override
    void initialize() {
        if (this.currentState() != ConnectionState.UNINITIALIZED) {
            logger.debug("{} Connection is already in a non-uninitialized state", (Object)this);
            return;
        }
        Future<?> future = null;
        try {
            future = this.blockingIoExecutor.submit(new CreateClientTask());
            future.get(this.operationTimeout().toMillis(), TimeUnit.MILLISECONDS);
        }
        catch (Exception e) {
            Throwable error;
            logger.warn("{} Error initializing connection", (Object)this, (Object)e);
            if (future != null) {
                future.cancel(true);
            }
            if (e instanceof InterruptedException) {
                Thread.currentThread().interrupt();
            }
            if (e instanceof ExecutionException) {
                ExecutionException ee = (ExecutionException)e;
                error = ee.getCause();
            } else {
                error = e;
            }
            throw new RuntimeException("Error initializing connection", error);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public void close() {
        ServiceClientHolder clientHolder = this.clientRef.get();
        if (clientHolder == null || this.currentState().isTerminal()) {
            return;
        }
        if (!this.clientRef.compareAndSet(clientHolder, null)) {
            logger.debug("{} Another thread has closed the connection", (Object)this);
            return;
        }
        logger.info("{} Closing connection", (Object)this);
        this.updateConnectionState(ConnectionState.CLOSING);
        Future<?> future = null;
        try {
            future = this.blockingIoExecutor.submit(new CloseClientTask(clientHolder));
            future.get(this.operationTimeout().toMillis(), TimeUnit.MILLISECONDS);
        }
        catch (Exception e) {
            logger.warn("{} Error occurred while closing connection; it will be suppressed", (Object)this, (Object)e);
            if (e instanceof InterruptedException) {
                Thread.currentThread().interrupt();
            }
            if (future != null) {
                future.cancel(true);
            }
        }
        finally {
            this.updateConnectionState(ConnectionState.CLOSED);
        }
    }

    @Nullable
    public BlockNodeStatus getBlockNodeStatus() {
        long durationMillis;
        ServerStatusResponse response;
        ServiceClientHolder clientHolder = this.clientRef.get();
        if (clientHolder == null || this.currentState() != ConnectionState.ACTIVE) {
            logger.debug("{} Tried to retrieve block node status, but this connection is not active", (Object)this);
            return null;
        }
        long startMillis = System.currentTimeMillis();
        Future<ServerStatusResponse> future = null;
        try {
            future = this.blockingIoExecutor.submit(new GetBlockNodeStatusTask(this, clientHolder.client));
            response = future.get(this.operationTimeout().toMillis(), TimeUnit.MILLISECONDS);
            durationMillis = System.currentTimeMillis() - startMillis;
        }
        catch (Exception e) {
            GrpcException grpcException = this.findGrpcException(e);
            if (grpcException != null) {
                logger.warn("{} Error retrieving block node status (grpcStatus={})", (Object)this, (Object)grpcException.status(), (Object)e);
            } else {
                logger.warn("{} Error retrieving block node status", (Object)this, (Object)e);
            }
            if (future != null) {
                future.cancel(true);
            }
            if (e instanceof InterruptedException) {
                Thread.currentThread().interrupt();
            }
            return BlockNodeStatus.notReachable();
        }
        logger.debug("{} Received the following block node server status: lastAvailableBlock={} (latency: {}ms)", (Object)this, (Object)response.lastAvailableBlock(), (Object)durationMillis);
        return BlockNodeStatus.reachable(durationMillis, response.lastAvailableBlock());
    }

    class CreateClientTask
    implements Runnable {
        CreateClientTask() {
        }

        @Override
        public void run() {
            Duration timeout = ((BlockNodeConnectionConfig)BlockNodeServiceConnection.this.configProvider().getConfiguration().getConfigData(BlockNodeConnectionConfig.class)).grpcOverallTimeout();
            long clientId = clientCtr.incrementAndGet();
            logger.debug("{} Creating new client (clientId: {})", (Object)BlockNodeServiceConnection.this, (Object)clientId);
            BlockNodeServiceInterface.BlockNodeServiceClient client = BlockNodeServiceConnection.this.clientFactory.createServiceClient(BlockNodeServiceConnection.this.configuration(), timeout);
            if (BlockNodeServiceConnection.this.clientRef.compareAndSet(null, new ServiceClientHolder(clientId, client))) {
                BlockNodeServiceConnection.this.updateConnectionState(ConnectionState.UNINITIALIZED, ConnectionState.ACTIVE);
                logger.info("{} Client initialized successfully (clientId: {})", (Object)BlockNodeServiceConnection.this, (Object)clientId);
            } else {
                logger.debug("{} Another thread has created the client and applied it to this connection; ignoring this attempt", (Object)BlockNodeServiceConnection.this);
                this.closeSilently(new ServiceClientHolder(clientId, client));
            }
        }

        private void closeSilently(@NonNull ServiceClientHolder holder) {
            logger.debug("{} Silently closing client (clientId: {})", (Object)BlockNodeServiceConnection.this, (Object)holder.clientId);
            try {
                Future<?> future = BlockNodeServiceConnection.this.blockingIoExecutor.submit(new CloseClientTask(holder));
                future.get(BlockNodeServiceConnection.this.operationTimeout().toMillis(), TimeUnit.MILLISECONDS);
            }
            catch (Exception e) {
                logger.debug("{} Attempted to close a client (clientId: {}), but it failed; ignoring failure", (Object)BlockNodeServiceConnection.this, (Object)holder.clientId, (Object)e);
            }
        }
    }

    record ServiceClientHolder(long clientId, BlockNodeServiceInterface.BlockNodeServiceClient client) {
    }

    class CloseClientTask
    implements Runnable {
        private final ServiceClientHolder clientHolder;

        CloseClientTask(ServiceClientHolder clientHolder) {
            this.clientHolder = Objects.requireNonNull(clientHolder, "client is required");
        }

        @Override
        public void run() {
            logger.debug("{} Closing client (clientId: {})", (Object)BlockNodeServiceConnection.this, (Object)this.clientHolder.clientId);
            this.clientHolder.client.close();
        }
    }

    class GetBlockNodeStatusTask
    implements Callable<ServerStatusResponse> {
        private final BlockNodeServiceInterface.BlockNodeServiceClient client;

        GetBlockNodeStatusTask(@NonNull BlockNodeServiceConnection this$0, BlockNodeServiceInterface.BlockNodeServiceClient client) {
            this.client = Objects.requireNonNull(client, "client is required");
        }

        @Override
        public ServerStatusResponse call() throws Exception {
            return this.client.serverStatus(new ServerStatusRequest());
        }
    }
}

