/*
 * Decompiled with CFR 0.152.
 */
package org.hiero.consensus.event.creator.impl.tipset;

import com.hedera.hapi.node.state.roster.Roster;
import com.swirlds.base.time.Time;
import com.swirlds.logging.legacy.LogMarker;
import edu.umd.cs.findbugs.annotations.NonNull;
import edu.umd.cs.findbugs.annotations.Nullable;
import java.time.Duration;
import java.util.List;
import java.util.Objects;
import org.apache.logging.log4j.LogManager;
import org.apache.logging.log4j.Logger;
import org.hiero.consensus.concurrent.utility.throttle.RateLimitedLogger;
import org.hiero.consensus.event.creator.impl.tipset.Tipset;
import org.hiero.consensus.model.event.EventDescriptorWrapper;
import org.hiero.consensus.model.event.PlatformEvent;
import org.hiero.consensus.model.hashgraph.EventWindow;
import org.hiero.consensus.model.node.NodeId;
import org.hiero.consensus.model.sequence.map.SequenceMap;
import org.hiero.consensus.model.sequence.map.StandardSequenceMap;

public class TipsetTracker {
    private static final Logger logger = LogManager.getLogger(TipsetTracker.class);
    private static final int INITIAL_TIPSET_MAP_CAPACITY = 64;
    private final SequenceMap<EventDescriptorWrapper, Tipset> tipsets;
    private Tipset latestGenerations;
    private final Roster roster;
    private EventWindow eventWindow;
    private final NodeId selfId;
    private final RateLimitedLogger ancientEventLogger;

    public TipsetTracker(@NonNull Time time, @NonNull NodeId selfId, @NonNull Roster roster) {
        this.roster = Objects.requireNonNull(roster);
        this.selfId = Objects.requireNonNull(selfId);
        this.latestGenerations = new Tipset(roster);
        this.tipsets = new StandardSequenceMap(0L, 64, true, EventDescriptorWrapper::birthRound);
        this.ancientEventLogger = new RateLimitedLogger(logger, time, Duration.ofMinutes(1L));
        this.eventWindow = EventWindow.getGenesisEventWindow();
    }

    public void setEventWindow(@NonNull EventWindow eventWindow) {
        this.eventWindow = Objects.requireNonNull(eventWindow);
        this.tipsets.shiftWindow(eventWindow.ancientThreshold());
    }

    @NonNull
    public EventWindow getEventWindow() {
        return this.eventWindow;
    }

    @NonNull
    public Tipset addSelfEvent(@NonNull EventDescriptorWrapper selfEventDesc, @NonNull List<EventDescriptorWrapper> parents) {
        this.logIfNotSelfEvent(selfEventDesc);
        this.logIfAncient(selfEventDesc);
        List<Tipset> parentTipsets = this.getParentTipsets(parents);
        Tipset eventTipset = new Tipset(this.roster).merge(parentTipsets);
        this.tipsets.put((Object)selfEventDesc, (Object)eventTipset);
        return eventTipset;
    }

    @NonNull
    public Tipset addPeerEvent(@NonNull PlatformEvent event) {
        this.logIfSelfEvent(event.getDescriptor());
        this.logIfAncient(event.getDescriptor());
        List<Tipset> parentTipsets = this.getParentTipsets(event.getAllParents());
        Tipset eventTipset = new Tipset(this.roster).merge(parentTipsets).advance(event.getCreatorId(), event.getNGen());
        this.tipsets.put((Object)event.getDescriptor(), (Object)eventTipset);
        this.latestGenerations = this.latestGenerations.advance(event.getCreatorId(), event.getNGen());
        return eventTipset;
    }

    private void logIfNotSelfEvent(@NonNull EventDescriptorWrapper descriptor) {
        if (!this.selfId.equals((Object)descriptor.creator())) {
            logger.error(LogMarker.EXCEPTION.getMarker(), "Attempt to add peer event as self event to the TipsetTracker. Self Id: {}, Event Creator: {}", (Object)this.selfId.id(), (Object)descriptor.creator());
        }
    }

    private void logIfSelfEvent(@NonNull EventDescriptorWrapper descriptor) {
        if (this.selfId.equals((Object)descriptor.creator())) {
            logger.error(LogMarker.EXCEPTION.getMarker(), "Attempt to add self event as peer event to the TipsetTracker. Self Id: {}, Event Creator: {}", (Object)this.selfId.id(), (Object)descriptor.creator());
        }
    }

    @NonNull
    private List<Tipset> getParentTipsets(@NonNull List<EventDescriptorWrapper> parents) {
        return parents.stream().map(arg_0 -> this.tipsets.get(arg_0)).filter(Objects::nonNull).toList();
    }

    private void logIfAncient(@NonNull EventDescriptorWrapper eventDescriptorWrapper) {
        if (this.eventWindow.isAncient(eventDescriptorWrapper)) {
            this.ancientEventLogger.error(LogMarker.EXCEPTION.getMarker(), "Rejecting ancient event from {} with threshold {}. Current event window is {}", new Object[]{eventDescriptorWrapper.creator(), eventDescriptorWrapper.eventDescriptor().birthRound(), this.eventWindow});
        }
    }

    @Nullable
    public Tipset getTipset(@NonNull EventDescriptorWrapper eventDescriptorWrapper) {
        return (Tipset)this.tipsets.get((Object)eventDescriptorWrapper);
    }

    public long getLatestGenerationForNode(@NonNull NodeId nodeId) {
        return this.latestGenerations.getTipGenerationForNode(nodeId);
    }

    public int size() {
        return this.tipsets.getSize();
    }

    public void clear() {
        this.eventWindow = EventWindow.getGenesisEventWindow();
        this.latestGenerations = new Tipset(this.roster);
        this.tipsets.clear();
    }
}

