/*
 * Decompiled with CFR 0.152.
 */
package com.hedera.hapi.node.contract.codec;

import com.hedera.hapi.node.base.AccountID;
import com.hedera.hapi.node.base.ContractID;
import com.hedera.hapi.node.contract.ContractFunctionResult;
import com.hedera.hapi.node.contract.ContractLoginfo;
import com.hedera.hapi.node.contract.ContractNonceInfo;
import com.hedera.pbj.runtime.JsonCodec;
import com.hedera.pbj.runtime.JsonTools;
import com.hedera.pbj.runtime.ParseException;
import com.hedera.pbj.runtime.UnknownFieldException;
import com.hedera.pbj.runtime.io.buffer.Bytes;
import com.hedera.pbj.runtime.jsonparser.JSONParser;
import edu.umd.cs.findbugs.annotations.NonNull;
import edu.umd.cs.findbugs.annotations.Nullable;
import java.util.ArrayList;
import java.util.Collections;
import java.util.List;

public final class ContractFunctionResultJsonCodec
implements JsonCodec<ContractFunctionResult> {
    @NonNull
    public ContractFunctionResult parse(@Nullable JSONParser.ObjContext root, boolean strictMode, int maxDepth, int maxSize) throws ParseException {
        if (maxDepth < 0) {
            throw new ParseException("Reached maximum allowed depth of nested messages");
        }
        try {
            ContractID temp_contractID = null;
            Bytes temp_contractCallResult = Bytes.EMPTY;
            String temp_errorMessage = "";
            Bytes temp_bloom = Bytes.EMPTY;
            long temp_gasUsed = 0L;
            List temp_logInfo = Collections.emptyList();
            List temp_createdContractIDs = Collections.emptyList();
            Bytes temp_evm_address = null;
            long temp_gas = 0L;
            long temp_amount = 0L;
            Bytes temp_functionParameters = Bytes.EMPTY;
            AccountID temp_sender_id = null;
            List temp_contract_nonces = Collections.emptyList();
            Long temp_signer_nonce = null;
            block34: for (JSONParser.PairContext kvPair : root.pair()) {
                switch (kvPair.STRING().getText()) {
                    case "contractID": {
                        temp_contractID = (ContractID)ContractID.JSON.parse((JSONParser.ObjContext)kvPair.value().getChild(JSONParser.ObjContext.class, 0), false, maxDepth - 1, maxSize);
                        continue block34;
                    }
                    case "contractCallResult": {
                        temp_contractCallResult = Bytes.fromBase64((String)JsonTools.checkSize((String)"contractCallResult", (String)kvPair.value().STRING().getText(), (int)(maxSize < 0x3FFFFFFF ? maxSize * 2 : Integer.MAX_VALUE)));
                        continue block34;
                    }
                    case "errorMessage": {
                        temp_errorMessage = JsonTools.unescape((String)JsonTools.checkSize((String)"errorMessage", (String)kvPair.value().STRING().getText(), (int)maxSize));
                        continue block34;
                    }
                    case "bloom": {
                        temp_bloom = Bytes.fromBase64((String)JsonTools.checkSize((String)"bloom", (String)kvPair.value().STRING().getText(), (int)(maxSize < 0x3FFFFFFF ? maxSize * 2 : Integer.MAX_VALUE)));
                        continue block34;
                    }
                    case "gasUsed": {
                        temp_gasUsed = JsonTools.parseLong((JSONParser.ValueContext)kvPair.value());
                        continue block34;
                    }
                    case "logInfo": {
                        temp_logInfo = JsonTools.parseObjArray((List)JsonTools.checkSize((String)"logInfo", (List)kvPair.value().arr().value(), (int)maxSize), ContractLoginfo.JSON, (int)(maxDepth - 1), (int)maxSize);
                        continue block34;
                    }
                    case "createdContractIDs": {
                        temp_createdContractIDs = JsonTools.parseObjArray((List)JsonTools.checkSize((String)"createdContractIDs", (List)kvPair.value().arr().value(), (int)maxSize), ContractID.JSON, (int)(maxDepth - 1), (int)maxSize);
                        continue block34;
                    }
                    case "evmAddress": {
                        temp_evm_address = Bytes.fromBase64((String)JsonTools.checkSize((String)"evm_address", (String)kvPair.value().STRING().getText(), (int)(maxSize < 0x3FFFFFFF ? maxSize * 2 : Integer.MAX_VALUE)));
                        continue block34;
                    }
                    case "gas": {
                        temp_gas = JsonTools.parseLong((JSONParser.ValueContext)kvPair.value());
                        continue block34;
                    }
                    case "amount": {
                        temp_amount = JsonTools.parseLong((JSONParser.ValueContext)kvPair.value());
                        continue block34;
                    }
                    case "functionParameters": {
                        temp_functionParameters = Bytes.fromBase64((String)JsonTools.checkSize((String)"functionParameters", (String)kvPair.value().STRING().getText(), (int)(maxSize < 0x3FFFFFFF ? maxSize * 2 : Integer.MAX_VALUE)));
                        continue block34;
                    }
                    case "senderId": {
                        temp_sender_id = (AccountID)AccountID.JSON.parse((JSONParser.ObjContext)kvPair.value().getChild(JSONParser.ObjContext.class, 0), false, maxDepth - 1, maxSize);
                        continue block34;
                    }
                    case "contractNonces": {
                        temp_contract_nonces = JsonTools.parseObjArray((List)JsonTools.checkSize((String)"contract_nonces", (List)kvPair.value().arr().value(), (int)maxSize), ContractNonceInfo.JSON, (int)(maxDepth - 1), (int)maxSize);
                        continue block34;
                    }
                    case "signerNonce": {
                        temp_signer_nonce = JsonTools.parseLong((JSONParser.ValueContext)kvPair.value());
                        continue block34;
                    }
                }
                if (!strictMode) continue;
                throw new UnknownFieldException(kvPair.STRING().getText());
            }
            return new ContractFunctionResult(temp_contractID, temp_contractCallResult, temp_errorMessage, temp_bloom, temp_gasUsed, temp_logInfo, temp_createdContractIDs, temp_evm_address, temp_gas, temp_amount, temp_functionParameters, temp_sender_id, temp_contract_nonces, temp_signer_nonce);
        }
        catch (Exception ex) {
            throw new ParseException((Throwable)ex);
        }
    }

    public String toJSON(@NonNull ContractFunctionResult data, String indent, boolean inline) {
        StringBuilder sb = new StringBuilder();
        sb.append((String)(inline ? "{\n" : indent + "{\n"));
        String childIndent = indent + "  ";
        ArrayList<String> fieldLines = new ArrayList<String>();
        if (data.contractID() != null) {
            fieldLines.add(JsonTools.field((String)childIndent, (String)"contractID", ContractID.JSON, (Object)data.contractID()));
        }
        if (data.contractCallResult() != Bytes.EMPTY && data.contractCallResult() != null && data.contractCallResult().length() > 0L) {
            fieldLines.add(JsonTools.field((String)"contractCallResult", (Bytes)data.contractCallResult()));
        }
        if (data.errorMessage() != null && !data.errorMessage().isEmpty()) {
            fieldLines.add(JsonTools.field((String)"errorMessage", (String)data.errorMessage()));
        }
        if (data.bloom() != Bytes.EMPTY && data.bloom() != null && data.bloom().length() > 0L) {
            fieldLines.add(JsonTools.field((String)"bloom", (Bytes)data.bloom()));
        }
        if (data.gasUsed() != 0L) {
            fieldLines.add(JsonTools.field((String)"gasUsed", (long)data.gasUsed()));
        }
        if (!data.logInfo().isEmpty()) {
            fieldLines.add(JsonTools.arrayField((String)childIndent, (String)"logInfo", ContractLoginfo.JSON, data.logInfo()));
        }
        if (!data.createdContractIDs().isEmpty()) {
            fieldLines.add(JsonTools.arrayField((String)childIndent, (String)"createdContractIDs", ContractID.JSON, data.createdContractIDs()));
        }
        if (data.evmAddress() != null) {
            fieldLines.add(JsonTools.field((String)"evmAddress", (Bytes)data.evmAddress()));
        }
        if (data.gas() != 0L) {
            fieldLines.add(JsonTools.field((String)"gas", (long)data.gas()));
        }
        if (data.amount() != 0L) {
            fieldLines.add(JsonTools.field((String)"amount", (long)data.amount()));
        }
        if (data.functionParameters() != Bytes.EMPTY && data.functionParameters() != null && data.functionParameters().length() > 0L) {
            fieldLines.add(JsonTools.field((String)"functionParameters", (Bytes)data.functionParameters()));
        }
        if (data.senderId() != null) {
            fieldLines.add(JsonTools.field((String)childIndent, (String)"senderId", AccountID.JSON, (Object)data.senderId()));
        }
        if (!data.contractNonces().isEmpty()) {
            fieldLines.add(JsonTools.arrayField((String)childIndent, (String)"contractNonces", ContractNonceInfo.JSON, data.contractNonces()));
        }
        if (data.signerNonce() != null) {
            fieldLines.add(JsonTools.field((String)"signerNonce", (Long)data.signerNonce(), (boolean)true));
        }
        if (!fieldLines.isEmpty()) {
            sb.append(childIndent);
            sb.append(String.join((CharSequence)(",\n" + childIndent), fieldLines));
            sb.append("\n");
        }
        sb.append(indent + "}");
        return sb.toString();
    }
}

