/*
 * Decompiled with CFR 0.152.
 */
package com.hedera.node.app.hapi.utils.forensics;

import com.google.protobuf.InvalidProtocolBufferException;
import com.hedera.hapi.util.UnknownHederaFunctionality;
import com.hedera.node.app.hapi.utils.CommonUtils;
import com.hederahashgraph.api.proto.java.HederaFunctionality;
import com.hederahashgraph.api.proto.java.Transaction;
import com.hederahashgraph.api.proto.java.TransactionBody;
import com.hederahashgraph.api.proto.java.TransactionOrBuilder;
import edu.umd.cs.findbugs.annotations.NonNull;
import java.util.Objects;

public record TransactionParts(@NonNull Transaction wrapper, @NonNull TransactionBody body, @NonNull HederaFunctionality function) {
    public TransactionParts {
        Objects.requireNonNull(wrapper);
        Objects.requireNonNull(body);
        Objects.requireNonNull(function);
    }

    public static TransactionParts from(@NonNull Transaction txn) {
        try {
            TransactionBody body = CommonUtils.extractTransactionBody((TransactionOrBuilder)txn);
            return new TransactionParts(txn, body, CommonUtils.functionOf(body));
        }
        catch (InvalidProtocolBufferException | UnknownHederaFunctionality e) {
            throw new IllegalArgumentException(e);
        }
    }
}

