/*
 * Decompiled with CFR 0.152.
 */
package org.hiero.consensus.concurrent.manager;

import com.swirlds.base.state.LifecyclePhase;
import java.util.concurrent.ThreadFactory;
import org.hiero.consensus.concurrent.framework.config.ThreadConfiguration;
import org.hiero.consensus.concurrent.manager.ThreadManager;

public class StandardThreadManager
implements ThreadManager {
    private LifecyclePhase phase = LifecyclePhase.NOT_STARTED;

    @Override
    public Thread createThread(ThreadGroup threadGroup, Runnable runnable) {
        this.throwIfNotInPhase(LifecyclePhase.STARTED);
        return new Thread(threadGroup, runnable);
    }

    @Override
    public ThreadFactory createThreadFactory(String component, String threadName) {
        return ((ThreadConfiguration)((ThreadConfiguration)new ThreadConfiguration(this).setComponent(component)).setThreadName(threadName)).buildFactory();
    }

    public void start() {
        this.throwIfNotInPhase(LifecyclePhase.NOT_STARTED);
        this.phase = LifecyclePhase.STARTED;
    }

    public void stop() {
        this.throwIfNotInPhase(LifecyclePhase.STARTED);
        this.phase = LifecyclePhase.STOPPED;
    }

    public LifecyclePhase getLifecyclePhase() {
        return this.phase;
    }
}

