/*
 * Decompiled with CFR 0.152.
 */
package com.swirlds.cli.utility;

import java.lang.reflect.Method;
import java.nio.file.Path;
import java.util.List;
import picocli.CommandLine;

@CommandLine.Command
public class PlatformCliPreParser
implements Runnable {
    private List<String> cliPackagePrefixes;
    private Path log4jPath;
    private String[] unparsedArgs;
    private boolean colorDisabled;
    private String bootstrapFunction;
    private static final ClassLoader classLoader = PlatformCliPreParser.class.getClassLoader();

    @CommandLine.Option(names={"-C", "--cli"})
    private void setCliPackagePrefixes(List<String> cliPackagePrefixes) {
        this.cliPackagePrefixes = cliPackagePrefixes;
    }

    @CommandLine.Option(names={"-L", "--log4j"})
    private void setLog4jPath(Path log4jPath) {
        this.log4jPath = log4jPath;
    }

    @CommandLine.Option(names={"--no-color"})
    private void setColorDisabled(boolean colorDisabled) {
        this.colorDisabled = colorDisabled;
    }

    @CommandLine.Option(names={"-B", "--bootstrap"})
    private void setBoostrapFunction(String boostrapFunction) {
        this.bootstrapFunction = boostrapFunction;
    }

    public List<String> getCliPackagePrefixes() {
        return this.cliPackagePrefixes;
    }

    public Path getLog4jPath() {
        return this.log4jPath;
    }

    public boolean isColorDisabled() {
        return this.colorDisabled;
    }

    public String[] getUnparsedArgs() {
        return this.unparsedArgs;
    }

    public void setUnparsedArgs(String[] unparsedArgs) {
        this.unparsedArgs = unparsedArgs;
    }

    public static void exampleBootstrapFunction() {
        System.out.println("running example bootstrap function");
    }

    public void runBootstrapFunction() {
        if (this.bootstrapFunction == null) {
            return;
        }
        try {
            int lastPeriodIndex = this.bootstrapFunction.lastIndexOf(46);
            String className = this.bootstrapFunction.substring(0, lastPeriodIndex);
            String methodName = this.bootstrapFunction.substring(lastPeriodIndex + 1);
            Class<?> clazz = classLoader.loadClass(className);
            Method method = clazz.getMethod(methodName, new Class[0]);
            method.invoke(null, new Object[0]);
        }
        catch (Throwable t) {
            System.err.println("Error running bootstrap function " + this.bootstrapFunction);
            t.printStackTrace();
            System.exit(1);
        }
    }

    @Override
    public void run() {
    }
}

