/*
 * Decompiled with CFR 0.152.
 */
package org.hyperledger.besu.evm.precompile;

import com.sun.jna.ptr.IntByReference;
import java.nio.charset.StandardCharsets;
import java.util.Optional;
import javax.annotation.Nonnull;
import org.apache.tuweni.bytes.Bytes;
import org.hyperledger.besu.evm.frame.ExceptionalHaltReason;
import org.hyperledger.besu.evm.frame.MessageFrame;
import org.hyperledger.besu.evm.gascalculator.GasCalculator;
import org.hyperledger.besu.evm.precompile.AbstractPrecompiledContract;
import org.hyperledger.besu.evm.precompile.PrecompiledContract;
import org.hyperledger.besu.nativelib.gnark.LibGnarkEIP196;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public abstract class AbstractAltBnPrecompiledContract
extends AbstractPrecompiledContract {
    private static final Logger LOG = LoggerFactory.getLogger(AbstractAltBnPrecompiledContract.class);
    static boolean useNative;
    private final byte operationId;
    private final int inputLimit;

    public static boolean maybeEnableNative() {
        try {
            useNative = LibGnarkEIP196.ENABLED;
        }
        catch (NoClassDefFoundError | UnsatisfiedLinkError ule) {
            LOG.info("altbn128 native precompile not available: {}", (Object)ule.getMessage());
            useNative = false;
        }
        return useNative;
    }

    public static void disableNative() {
        useNative = false;
    }

    public static boolean isNative() {
        return useNative;
    }

    AbstractAltBnPrecompiledContract(String name, GasCalculator gasCalculator, byte operationId, int inputLen) {
        super(name, gasCalculator);
        this.operationId = operationId;
        this.inputLimit = inputLen + 1;
        if (!LibGnarkEIP196.ENABLED) {
            LOG.info("Native alt bn128 not available");
        }
    }

    @Nonnull
    public PrecompiledContract.PrecompileContractResult computeNative(@Nonnull Bytes input, MessageFrame messageFrame) {
        byte[] result = new byte[128];
        byte[] error = new byte[256];
        IntByReference o_len = new IntByReference(128);
        IntByReference err_len = new IntByReference(256);
        int inputSize = Math.min(this.inputLimit, input.size());
        int errorNo = LibGnarkEIP196.eip196_perform_operation((byte)this.operationId, (byte[])input.slice(0, inputSize).toArrayUnsafe(), (int)inputSize, (byte[])result, (IntByReference)o_len, (byte[])error, (IntByReference)err_len);
        if (errorNo == 0) {
            return PrecompiledContract.PrecompileContractResult.success(Bytes.wrap((byte[])result, (int)0, (int)o_len.getValue()));
        }
        String errorString = new String(error, 0, err_len.getValue(), StandardCharsets.UTF_8);
        messageFrame.setRevertReason(Bytes.wrap((byte[])error, (int)0, (int)err_len.getValue()));
        LOG.trace("Error executing precompiled contract {}: '{}'", (Object)this.getName(), (Object)errorString);
        return PrecompiledContract.PrecompileContractResult.halt(null, Optional.of(ExceptionalHaltReason.PRECOMPILE_ERROR));
    }

    static {
        AbstractAltBnPrecompiledContract.maybeEnableNative();
    }
}

