/*
 * Decompiled with CFR 0.152.
 */
package com.swirlds.logging.api;

import edu.umd.cs.findbugs.annotations.NonNull;
import edu.umd.cs.findbugs.annotations.Nullable;
import java.util.ArrayList;
import java.util.Collections;
import java.util.List;
import java.util.Objects;

public record Marker(@NonNull String name, @Nullable Marker previous) {
    public Marker {
        Objects.requireNonNull(name, "name must not be null");
    }

    public Marker(@NonNull String name) {
        this(name, null);
    }

    @NonNull
    public List<String> getAllMarkerNames() {
        if (this.previous != null) {
            ArrayList<String> result = new ArrayList<String>(this.previous.getAllMarkerNames());
            result.add(this.name);
            return Collections.unmodifiableList(result);
        }
        return List.of(this.name);
    }
}

