/*
 * Decompiled with CFR 0.152.
 */
package com.hedera.node.app.service.file.impl.handlers;

import com.hedera.hapi.node.base.AccountID;
import com.hedera.hapi.node.base.HederaFunctionality;
import com.hedera.hapi.node.transaction.TransactionBody;
import com.hedera.node.app.service.file.FileSignatureWaivers;
import com.hedera.node.app.spi.authorization.Authorizer;
import com.hedera.node.app.spi.authorization.SystemPrivilege;
import edu.umd.cs.findbugs.annotations.NonNull;
import java.util.Objects;
import javax.inject.Inject;
import javax.inject.Singleton;

@Singleton
public class FileSignatureWaiversImpl
implements FileSignatureWaivers {
    private final Authorizer authorizer;

    @Inject
    public FileSignatureWaiversImpl(@NonNull Authorizer authorizer) {
        this.authorizer = Objects.requireNonNull(authorizer);
    }

    public boolean areFileUpdateSignaturesWaived(TransactionBody fileUpdateTxn, AccountID payer) {
        return this.authorizer.hasPrivilegedAuthorization(payer, HederaFunctionality.FILE_UPDATE, fileUpdateTxn) == SystemPrivilege.AUTHORIZED;
    }

    public boolean areFileAppendSignaturesWaived(TransactionBody fileAppendTxn, AccountID payer) {
        return this.authorizer.hasPrivilegedAuthorization(payer, HederaFunctionality.FILE_APPEND, fileAppendTxn) == SystemPrivilege.AUTHORIZED;
    }
}

