/*
 * Decompiled with CFR 0.152.
 */
package com.swirlds.common;

import java.awt.Color;
import java.awt.Component;
import java.awt.Font;
import java.awt.GraphicsEnvironment;
import java.awt.Rectangle;
import java.awt.event.KeyListener;
import java.io.ByteArrayOutputStream;
import java.io.PrintStream;
import javax.swing.JFrame;
import javax.swing.JScrollBar;
import javax.swing.JScrollPane;
import javax.swing.JTextArea;

public class Console {
    public static final double MAX_SIZE_PERCENTAGE = 0.75;
    public final PrintStream out;
    private final boolean headless;
    private final JFrame window;
    private final JTextArea heading;
    private final JTextArea textArea;
    private final JScrollPane scrollPane;
    private static final int MAX_SIZE = 51200;
    private static final int DEFAULT_FONT_SIZE = 12;

    public Console(String name, Rectangle winRect) {
        this(name, winRect, 12, false);
    }

    public Console(String name, Rectangle winRect, int fontSize, boolean visible) {
        if (GraphicsEnvironment.isHeadless()) {
            this.window = null;
            this.heading = null;
            this.textArea = null;
            this.scrollPane = null;
            this.out = null;
            this.headless = true;
        } else {
            this.heading = new JTextArea(2, 40);
            this.heading.setFont(new Font("Monospaced", 0, fontSize));
            this.heading.setEditable(false);
            this.heading.setBackground(Color.BLACK);
            this.heading.setForeground(Color.WHITE);
            this.textArea = new JTextArea(10, 40);
            this.textArea.setFont(new Font("Monospaced", 0, fontSize));
            this.textArea.setEditable(false);
            this.textArea.setBackground(Color.BLACK);
            this.textArea.setForeground(Color.WHITE);
            this.scrollPane = new JScrollPane();
            this.scrollPane.setViewportView(this.textArea);
            this.scrollPane.setColumnHeaderView(this.heading);
            this.scrollPane.setBackground(Color.BLACK);
            this.window = new JFrame(name);
            this.window.setBackground(Color.BLACK);
            this.window.setDefaultCloseOperation(2);
            this.window.setBackground(Color.DARK_GRAY);
            this.window.add((Component)this.scrollPane, "Center");
            this.window.setFocusable(true);
            this.window.requestFocusInWindow();
            this.window.setBounds(winRect);
            this.window.setVisible(visible);
            this.out = new PrintStream(new ConsoleStream(), true);
            this.headless = false;
        }
    }

    public void setHeading(String headingText) {
        if (this.headless) {
            throw new IllegalStateException("Heading can not be defined in headless mode!");
        }
        this.heading.setText(headingText);
        this.heading.revalidate();
    }

    public synchronized void addKeyListener(KeyListener listener) {
        if (this.headless) {
            throw new IllegalStateException("KeyListener can not be added in headless mode!");
        }
        this.window.addKeyListener(listener);
        this.heading.addKeyListener(listener);
        this.scrollPane.addKeyListener(listener);
        this.textArea.addKeyListener(listener);
    }

    public void setVisible(boolean visible) {
        if (this.headless) {
            throw new IllegalStateException("Visible state can not be changed in headless mode!");
        }
        this.window.setVisible(visible);
    }

    public JFrame getWindow() {
        if (this.headless) {
            throw new IllegalStateException("No window accessible in headless mode!");
        }
        return this.window;
    }

    private class ConsoleStream
    extends ByteArrayOutputStream {
        private ConsoleStream() {
        }

        @Override
        public synchronized void flush() {
            Object str = this.toString();
            this.reset();
            if (((String)str).equals("")) {
                return;
            }
            str = Console.this.textArea.getText() + (String)str;
            int n = 38400;
            if (((String)str).length() > n) {
                int i = ((String)str).lastIndexOf("\r", ((String)str).length() - n);
                i = Math.max(i, ((String)str).lastIndexOf("\n", ((String)str).length() - n));
                i = Math.max(i, 0);
                i = Math.max(i, ((String)str).length() - 51200);
                str = ((String)str).substring(i);
            }
            Console.this.textArea.setText((String)str);
            JScrollBar bar = Console.this.scrollPane.getVerticalScrollBar();
            int maxScroll = bar.getMaximum() - bar.getModel().getExtent();
            if ((double)(maxScroll - bar.getValue()) < 0.1 * (double)bar.getMaximum()) {
                bar.setValue(maxScroll);
            }
        }
    }
}

