/*
 * Decompiled with CFR 0.152.
 */
package com.swirlds.common.merkle.synchronization;

import com.swirlds.common.io.streams.MerkleDataInputStream;
import com.swirlds.common.io.streams.MerkleDataOutputStream;
import com.swirlds.common.merkle.MerkleNode;
import com.swirlds.common.merkle.crypto.MerkleCryptography;
import com.swirlds.common.merkle.synchronization.config.ReconnectConfig;
import com.swirlds.common.merkle.synchronization.streams.AsyncOutputStream;
import com.swirlds.common.merkle.synchronization.task.ReconnectNodeCount;
import com.swirlds.common.merkle.synchronization.utility.MerkleSynchronizationException;
import com.swirlds.common.merkle.synchronization.views.LearnerTreeView;
import com.swirlds.logging.legacy.LogMarker;
import com.swirlds.logging.legacy.payload.SynchronizationCompletePayload;
import edu.umd.cs.findbugs.annotations.NonNull;
import java.util.Objects;
import java.util.concurrent.ExecutionException;
import java.util.concurrent.atomic.AtomicReference;
import java.util.function.Function;
import org.apache.logging.log4j.LogManager;
import org.apache.logging.log4j.Logger;
import org.hiero.base.io.SelfSerializable;
import org.hiero.base.io.streams.SerializableDataOutputStream;
import org.hiero.consensus.concurrent.manager.ThreadManager;
import org.hiero.consensus.concurrent.pool.StandardWorkGroup;

public class LearningSynchronizer
implements ReconnectNodeCount {
    private static final String WORK_GROUP_NAME = "learning-synchronizer";
    private static final Logger logger = LogManager.getLogger(LearningSynchronizer.class);
    private final MerkleDataInputStream inputStream;
    private final MerkleDataOutputStream outputStream;
    private final Runnable breakConnection;
    private final MerkleNode newRoot;
    private final LearnerTreeView<?> view;
    private int leafNodesReceived;
    private int internalNodesReceived;
    private int redundantLeafNodes;
    private int redundantInternalNodes;
    private long synchronizationTimeMilliseconds;
    private long hashTimeMilliseconds;
    private final MerkleCryptography merkleCryptography;
    protected final ReconnectConfig reconnectConfig;
    private final ThreadManager threadManager;

    public LearningSynchronizer(@NonNull ThreadManager threadManager, @NonNull MerkleDataInputStream in, @NonNull MerkleDataOutputStream out, @NonNull MerkleNode newRoot, @NonNull LearnerTreeView<?> view, @NonNull Runnable breakConnection, @NonNull MerkleCryptography merkleCryptography, @NonNull ReconnectConfig reconnectConfig) {
        this.threadManager = Objects.requireNonNull(threadManager, "threadManager is null");
        this.inputStream = Objects.requireNonNull(in, "inputStream is null");
        this.outputStream = Objects.requireNonNull(out, "outputStream is null");
        this.merkleCryptography = Objects.requireNonNull(merkleCryptography, "merkleCryptography is null");
        this.reconnectConfig = Objects.requireNonNull(reconnectConfig, "reconnectConfig is null");
        this.newRoot = Objects.requireNonNull(newRoot, "newRoot is null");
        this.view = Objects.requireNonNull(view, "view is null");
        this.breakConnection = breakConnection;
    }

    public void synchronize() throws InterruptedException {
        logger.info(LogMarker.RECONNECT.getMarker(), "learner calls receiveTree()");
        long syncStartTime = System.currentTimeMillis();
        this.receiveTree();
        this.synchronizationTimeMilliseconds = System.currentTimeMillis() - syncStartTime;
        logger.info(LogMarker.RECONNECT.getMarker(), "learner calls hash()");
        long hashStartTime = System.currentTimeMillis();
        this.hash();
        this.hashTimeMilliseconds = System.currentTimeMillis() - hashStartTime;
        logger.info(LogMarker.RECONNECT.getMarker(), "learner calls logStatistics()");
        this.logStatistics();
        logger.info(LogMarker.RECONNECT.getMarker(), "learner is done synchronizing");
    }

    private void hash() throws InterruptedException {
        logger.info(LogMarker.RECONNECT.getMarker(), "hashing tree");
        try {
            this.merkleCryptography.digestTreeAsync(this.newRoot).get();
        }
        catch (ExecutionException e) {
            logger.error(LogMarker.EXCEPTION.getMarker(), "exception while computing hash of reconstructed tree", (Throwable)e);
            return;
        }
        logger.info(LogMarker.RECONNECT.getMarker(), "hashing complete");
    }

    private void logStatistics() {
        logger.info(LogMarker.RECONNECT.getMarker(), () -> new SynchronizationCompletePayload("Finished synchronization").setTimeInSeconds((double)this.synchronizationTimeMilliseconds * 0.001).setHashTimeInSeconds((double)this.hashTimeMilliseconds * 0.001).setTotalNodes(this.leafNodesReceived + this.internalNodesReceived).setLeafNodes(this.leafNodesReceived).setRedundantLeafNodes(this.redundantLeafNodes).setInternalNodes(this.internalNodesReceived).setRedundantInternalNodes(this.redundantInternalNodes).toString());
    }

    private void receiveTree() throws InterruptedException {
        AtomicReference firstReconnectException = new AtomicReference();
        Function<Throwable, Boolean> reconnectExceptionListener = t -> {
            firstReconnectException.compareAndSet(null, t);
            return false;
        };
        StandardWorkGroup workGroup = this.createStandardWorkGroup(this.threadManager, this.breakConnection, reconnectExceptionListener);
        this.view.startLearnerTasks(this, workGroup, this.inputStream, this.outputStream);
        InterruptedException interruptException = null;
        try {
            workGroup.waitForTermination();
        }
        catch (InterruptedException e) {
            interruptException = e;
            logger.warn(LogMarker.RECONNECT.getMarker(), "interrupted while waiting for work group termination");
        }
        catch (Throwable t2) {
            logger.info(LogMarker.RECONNECT.getMarker(), "caught exception while receiving tree", t2);
            throw t2;
        }
        if (interruptException != null || workGroup.hasExceptions()) {
            this.view.abort();
            if (interruptException != null) {
                throw interruptException;
            }
            throw new MerkleSynchronizationException("Synchronization failed with exceptions", (Throwable)firstReconnectException.get());
        }
    }

    protected StandardWorkGroup createStandardWorkGroup(ThreadManager threadManager, Runnable breakConnection, Function<Throwable, Boolean> reconnectExceptionListener) {
        return new StandardWorkGroup(threadManager, WORK_GROUP_NAME, breakConnection, reconnectExceptionListener);
    }

    public <T extends SelfSerializable> AsyncOutputStream<T> buildOutputStream(StandardWorkGroup workGroup, SerializableDataOutputStream out) {
        return new AsyncOutputStream(out, workGroup, this.reconnectConfig);
    }

    @Override
    public void incrementLeafCount() {
        ++this.leafNodesReceived;
    }

    @Override
    public void incrementRedundantLeafCount() {
        ++this.redundantLeafNodes;
    }

    @Override
    public void incrementInternalCount() {
        ++this.internalNodesReceived;
    }

    @Override
    public void incrementRedundantInternalCount() {
        ++this.redundantInternalNodes;
    }
}

