/*
 * Decompiled with CFR 0.152.
 */
package com.swirlds.virtualmap.internal.reconnect;

import com.swirlds.base.time.Time;
import com.swirlds.common.io.exceptions.MerkleSerializationException;
import com.swirlds.common.merkle.synchronization.config.ReconnectConfig;
import com.swirlds.common.merkle.synchronization.streams.AsyncOutputStream;
import com.swirlds.common.merkle.synchronization.utility.MerkleSynchronizationException;
import com.swirlds.logging.legacy.LogMarker;
import com.swirlds.virtualmap.internal.reconnect.PullVirtualTreeRequest;
import com.swirlds.virtualmap.internal.reconnect.PullVirtualTreeResponse;
import com.swirlds.virtualmap.internal.reconnect.TeacherPullVirtualTreeView;
import edu.umd.cs.findbugs.annotations.NonNull;
import java.util.concurrent.TimeUnit;
import org.apache.logging.log4j.LogManager;
import org.apache.logging.log4j.Logger;
import org.hiero.base.crypto.Hash;
import org.hiero.base.io.SelfSerializable;
import org.hiero.base.io.streams.SerializableDataInputStream;
import org.hiero.consensus.concurrent.pool.StandardWorkGroup;
import org.hiero.consensus.concurrent.utility.throttle.RateLimiter;

public class TeacherPullVirtualTreeReceiveTask {
    private static final Logger logger = LogManager.getLogger(TeacherPullVirtualTreeReceiveTask.class);
    private static final String NAME = "reconnect-teacher-receiver";
    private final StandardWorkGroup workGroup;
    private final SerializableDataInputStream in;
    private final AsyncOutputStream<PullVirtualTreeResponse> out;
    private final TeacherPullVirtualTreeView view;
    private final RateLimiter rateLimiter;
    private final int sleepNanos;

    public TeacherPullVirtualTreeReceiveTask(@NonNull Time time, @NonNull ReconnectConfig reconnectConfig, StandardWorkGroup workGroup, SerializableDataInputStream in, AsyncOutputStream<PullVirtualTreeResponse> out, TeacherPullVirtualTreeView view) {
        this.workGroup = workGroup;
        this.in = in;
        this.out = out;
        this.view = view;
        int maxRate = reconnectConfig.teacherMaxNodesPerSecond();
        if (maxRate > 0) {
            this.rateLimiter = new RateLimiter(time, (double)maxRate);
            this.sleepNanos = (int)reconnectConfig.teacherRateLimiterSleep().toNanos();
        } else {
            this.rateLimiter = null;
            this.sleepNanos = -1;
        }
    }

    void exec() {
        this.workGroup.execute(NAME, this::run);
    }

    private void rateLimit() throws InterruptedException {
        if (this.rateLimiter != null) {
            while (!this.rateLimiter.requestAndTrigger()) {
                TimeUnit.NANOSECONDS.sleep(this.sleepNanos);
            }
        }
    }

    private void run() {
        try (AsyncOutputStream<PullVirtualTreeResponse> asyncOutputStream = this.out;){
            while (true) {
                this.rateLimit();
                PullVirtualTreeRequest request = new PullVirtualTreeRequest();
                request.deserialize(this.in, 0);
                logger.debug(LogMarker.RECONNECT.getMarker(), "Teacher receive path: " + request.getPath());
                if (request.getPath() == -1L) break;
                long path = request.getPath();
                Hash learnerHash = request.getHash();
                Hash teacherHash = this.view.loadHash(path);
                if (teacherHash == null && path != 0L) {
                    throw new MerkleSerializationException("Cannot load node hash (bad request from learner?), path = " + path);
                }
                PullVirtualTreeResponse response = new PullVirtualTreeResponse(this.view, path, learnerHash, teacherHash);
                this.out.sendAsync((SelfSerializable)response);
            }
            logger.info(LogMarker.RECONNECT.getMarker(), "Teacher receiver is complete as requested by the learner");
            logger.debug(LogMarker.RECONNECT.getMarker(), "Teacher receive done");
        }
        catch (InterruptedException ex) {
            logger.warn(LogMarker.RECONNECT.getMarker(), "Teacher's receiving task is interrupted");
            Thread.currentThread().interrupt();
        }
        catch (Exception ex) {
            throw new MerkleSynchronizationException("Exception in the teacher's receiving task", (Throwable)ex);
        }
    }
}

