/*
 * Decompiled with CFR 0.152.
 */
package io.helidon.webclient.http2;

import io.helidon.common.tls.Tls;
import io.helidon.common.uri.UriQueryWriteable;
import io.helidon.http.Headers;
import io.helidon.http.Method;
import io.helidon.webclient.api.ClientRequest;
import io.helidon.webclient.api.ClientUri;
import io.helidon.webclient.api.ConnectionKey;
import io.helidon.webclient.api.DnsAddressLookup;
import io.helidon.webclient.api.FullClientRequest;
import io.helidon.webclient.api.Proxy;
import io.helidon.webclient.api.WebClient;
import io.helidon.webclient.http2.Http2Client;
import io.helidon.webclient.http2.Http2ClientConfig;
import io.helidon.webclient.http2.Http2ClientProtocolConfig;
import io.helidon.webclient.http2.Http2ClientRequest;
import io.helidon.webclient.http2.Http2ClientRequestImpl;
import io.helidon.webclient.http2.Http2ConnectionCache;
import io.helidon.webclient.spi.DnsResolver;
import io.helidon.webclient.spi.HttpClientSpi;

public class Http2ClientImpl
implements Http2Client,
HttpClientSpi {
    private final WebClient webClient;
    private final Http2ClientConfig clientConfig;
    private final Http2ClientProtocolConfig protocolConfig;
    private final Http2ConnectionCache connectionCache;
    private final Http2ConnectionCache clientCache;

    Http2ClientImpl(WebClient webClient, Http2ClientConfig clientConfig) {
        this.webClient = webClient;
        this.clientConfig = clientConfig;
        this.protocolConfig = clientConfig.protocolConfig();
        if (clientConfig.shareConnectionCache()) {
            this.connectionCache = Http2ConnectionCache.shared();
            this.clientCache = null;
        } else {
            this.clientCache = this.connectionCache = Http2ConnectionCache.create();
        }
    }

    public Http2ClientRequest method(Method method) {
        ClientUri clientUri = this.clientConfig.baseUri().map(ClientUri::create).orElseGet(ClientUri::create);
        UriQueryWriteable query = UriQueryWriteable.create();
        this.clientConfig.baseQuery().ifPresent(arg_0 -> ((UriQueryWriteable)query).from(arg_0));
        return new Http2ClientRequestImpl(this, null, method, clientUri, this.clientConfig.properties());
    }

    public Http2ClientConfig prototype() {
        return this.clientConfig;
    }

    public HttpClientSpi.SupportLevel supports(FullClientRequest<?> clientRequest, ClientUri clientUri) {
        ConnectionKey ck = ConnectionKey.create((String)clientUri.scheme(), (String)clientUri.host(), (int)clientUri.port(), (Tls)clientRequest.tls(), (DnsResolver)this.clientConfig.dnsResolver(), (DnsAddressLookup)this.clientConfig.dnsAddressLookup(), (Proxy)clientRequest.proxy());
        if (this.connectionCache.supports(ck)) {
            return HttpClientSpi.SupportLevel.SUPPORTED;
        }
        return HttpClientSpi.SupportLevel.NOT_SUPPORTED;
    }

    public ClientRequest<?> clientRequest(FullClientRequest<?> clientRequest, ClientUri clientUri) {
        Http2ClientRequestImpl request = new Http2ClientRequestImpl(this, clientRequest, clientRequest.method(), clientUri, clientRequest.properties());
        clientRequest.connection().ifPresent(arg_0 -> ((Http2ClientRequest)request).connection(arg_0));
        clientRequest.pathParams().forEach((arg_0, arg_1) -> ((Http2ClientRequest)request).pathParam(arg_0, arg_1));
        return ((Http2ClientRequest)((Http2ClientRequest)((Http2ClientRequest)((Http2ClientRequest)((Http2ClientRequest)((Http2ClientRequest)request.readTimeout(clientRequest.readTimeout())).followRedirects(clientRequest.followRedirects())).maxRedirects(clientRequest.maxRedirects())).proxy(clientRequest.proxy())).tls(clientRequest.tls())).headers((Headers)clientRequest.headers())).fragment(clientUri.fragment());
    }

    public void closeResource() {
        if (this.clientCache != null) {
            this.clientCache.closeResource();
        }
    }

    WebClient webClient() {
        return this.webClient;
    }

    Http2ClientConfig clientConfig() {
        return this.clientConfig;
    }

    Http2ClientProtocolConfig protocolConfig() {
        return this.protocolConfig;
    }

    Http2ConnectionCache connectionCache() {
        return this.connectionCache;
    }
}

