/*
 * Decompiled with CFR 0.152.
 */
package com.hedera.node.app.service.contract.impl;

import com.hedera.node.app.service.contract.ContractService;
import com.hedera.node.app.service.contract.impl.ContractServiceComponent;
import com.hedera.node.app.service.contract.impl.DaggerContractServiceComponent;
import com.hedera.node.app.service.contract.impl.exec.ActionSidecarContentTracer;
import com.hedera.node.app.service.contract.impl.exec.metrics.ContractMetrics;
import com.hedera.node.app.service.contract.impl.exec.scope.DefaultVerificationStrategies;
import com.hedera.node.app.service.contract.impl.exec.scope.VerificationStrategies;
import com.hedera.node.app.service.contract.impl.exec.systemcontracts.common.AbstractCallAttempt;
import com.hedera.node.app.service.contract.impl.exec.systemcontracts.common.CallTranslator;
import com.hedera.node.app.service.contract.impl.exec.utils.SystemContractMethodRegistry;
import com.hedera.node.app.service.contract.impl.handlers.ContractHandlers;
import com.hedera.node.app.service.contract.impl.handlers.HookStoreHandler;
import com.hedera.node.app.service.contract.impl.nativelibverification.NativeLibVerifier;
import com.hedera.node.app.service.contract.impl.schemas.V0490ContractSchema;
import com.hedera.node.app.service.contract.impl.schemas.V065ContractSchema;
import com.hedera.node.app.spi.AppContext;
import com.hedera.node.app.spi.fees.ServiceFeeCalculator;
import com.hedera.node.config.data.ContractsConfig;
import com.swirlds.config.api.Configuration;
import com.swirlds.metrics.api.Metrics;
import com.swirlds.state.lifecycle.Schema;
import com.swirlds.state.lifecycle.SchemaRegistry;
import edu.umd.cs.findbugs.annotations.NonNull;
import edu.umd.cs.findbugs.annotations.Nullable;
import java.util.ArrayList;
import java.util.Collection;
import java.util.List;
import java.util.Objects;
import java.util.Optional;
import java.util.Set;
import java.util.function.Supplier;
import org.hyperledger.besu.evm.operation.Operation;

public class ContractServiceImpl
implements ContractService {
    public static final long INTRINSIC_GAS_LOWER_BOUND = 21000L;
    private final ContractServiceComponent component;

    public ContractServiceImpl(@NonNull AppContext appContext, @NonNull Metrics metrics) {
        this(appContext, metrics, null, null, Set.of());
    }

    public ContractServiceImpl(@NonNull AppContext appContext, @NonNull Metrics metrics, @Nullable VerificationStrategies verificationStrategies, @Nullable Supplier<List<ActionSidecarContentTracer>> addOnTracers, @NonNull Set<Operation> customOps) {
        Objects.requireNonNull(appContext);
        Objects.requireNonNull(customOps);
        Objects.requireNonNull(metrics);
        Supplier<ContractsConfig> contractsConfigSupplier = () -> (ContractsConfig)((Configuration)appContext.configSupplier().get()).getConfigData(ContractsConfig.class);
        SystemContractMethodRegistry systemContractMethodRegistry = new SystemContractMethodRegistry();
        ContractMetrics contractMetrics = new ContractMetrics(metrics, contractsConfigSupplier, systemContractMethodRegistry);
        NativeLibVerifier nativeLibVerifier = new NativeLibVerifier(contractsConfigSupplier);
        this.component = DaggerContractServiceComponent.factory().create(appContext.instantSource(), appContext.signatureVerifier(), Optional.ofNullable(verificationStrategies).orElseGet(DefaultVerificationStrategies::new), addOnTracers, contractMetrics, systemContractMethodRegistry, customOps, appContext.idFactory(), nativeLibVerifier);
    }

    public void registerSchemas(@NonNull SchemaRegistry registry) {
        registry.registerAll(new Schema[]{new V0490ContractSchema(), new V065ContractSchema()});
    }

    public Set<ServiceFeeCalculator> serviceFeeCalculators() {
        return Set.of(new HookStoreHandler.FeeCalculator());
    }

    public void createMetrics() {
        ContractMetrics contractMetrics = Objects.requireNonNull(this.component.contractMetrics());
        List<CallTranslator<? extends AbstractCallAttempt<?>>> allTranslators = this.allCallTranslators();
        contractMetrics.createContractPrimaryMetrics();
        contractMetrics.createContractSecondaryMetrics();
    }

    public ContractHandlers handlers() {
        return this.component.handlers();
    }

    public NativeLibVerifier nativeLibVerifier() {
        return this.component.nativeLibVerifier();
    }

    @NonNull
    private List<CallTranslator<? extends AbstractCallAttempt<?>>> allCallTranslators() {
        ArrayList allCallTranslators = new ArrayList();
        allCallTranslators.addAll((Collection)this.component.hasCallTranslators().get());
        allCallTranslators.addAll((Collection)this.component.hssCallTranslators().get());
        allCallTranslators.addAll((Collection)this.component.htsCallTranslators().get());
        return allCallTranslators;
    }
}

