/*
 * Decompiled with CFR 0.152.
 */
package com.hedera.node.app.service.contract.impl.utils;

import com.hedera.hapi.node.base.ResponseCodeEnum;
import com.hedera.hapi.node.hooks.EvmHook;
import com.hedera.hapi.node.hooks.EvmHookMappingEntries;
import com.hedera.hapi.node.hooks.EvmHookMappingEntry;
import com.hedera.hapi.node.hooks.EvmHookStorageSlot;
import com.hedera.hapi.node.hooks.EvmHookStorageUpdate;
import com.hedera.hapi.node.hooks.HookCreationDetails;
import com.hedera.node.app.hapi.utils.contracts.HookUtils;
import com.hedera.node.app.spi.workflows.PreCheckException;
import com.hedera.pbj.runtime.io.buffer.Bytes;
import edu.umd.cs.findbugs.annotations.NonNull;

public class HookValidationUtils {
    public static void validateHook(HookCreationDetails hook) throws PreCheckException {
        PreCheckException.validateTruePreCheck((hook.extensionPoint() != null ? 1 : 0) != 0, (ResponseCodeEnum)ResponseCodeEnum.HOOK_EXTENSION_EMPTY);
        PreCheckException.validateTruePreCheck((boolean)hook.hasEvmHook(), (ResponseCodeEnum)ResponseCodeEnum.INVALID_HOOK_CREATION_SPEC);
        EvmHook evmHook = hook.evmHookOrThrow();
        PreCheckException.validateTruePreCheck((evmHook.hasSpec() && evmHook.specOrThrow().hasContractId() ? 1 : 0) != 0, (ResponseCodeEnum)ResponseCodeEnum.INVALID_HOOK_CREATION_SPEC);
        for (EvmHookStorageUpdate storage : evmHook.storageUpdates()) {
            PreCheckException.validateTruePreCheck((storage.hasStorageSlot() || storage.hasMappingEntries() ? 1 : 0) != 0, (ResponseCodeEnum)ResponseCodeEnum.EMPTY_EVM_HOOK_STORAGE_UPDATE);
            if (storage.hasStorageSlot()) {
                EvmHookStorageSlot s = storage.storageSlotOrThrow();
                HookValidationUtils.validateWord(s.key());
                HookValidationUtils.validateWord(s.value());
                continue;
            }
            if (!storage.hasMappingEntries()) continue;
            EvmHookMappingEntries mapping = storage.mappingEntriesOrThrow();
            for (EvmHookMappingEntry e : mapping.entries()) {
                PreCheckException.validateTruePreCheck((e.hasKey() || e.hasPreimage() ? 1 : 0) != 0, (ResponseCodeEnum)ResponseCodeEnum.EMPTY_EVM_HOOK_STORAGE_UPDATE);
                if (e.hasKey()) {
                    HookValidationUtils.validateWord(e.keyOrThrow());
                }
                HookValidationUtils.validateWord(e.value());
            }
        }
    }

    private static void validateWord(@NonNull Bytes bytes) throws PreCheckException {
        PreCheckException.validateTruePreCheck((bytes.length() <= 32L ? 1 : 0) != 0, (ResponseCodeEnum)ResponseCodeEnum.HOOK_CREATION_BYTES_TOO_LONG);
        Bytes minimalBytes = HookUtils.minimalRepresentationOf((Bytes)bytes);
        PreCheckException.validateTruePreCheck((boolean)bytes.equals((Object)minimalBytes), (ResponseCodeEnum)ResponseCodeEnum.HOOK_CREATION_BYTES_MUST_USE_MINIMAL_REPRESENTATION);
    }
}

