/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.collections.impl.lazy.primitive;

import java.util.NoSuchElementException;
import org.eclipse.collections.api.LazyShortIterable;
import org.eclipse.collections.api.ShortIterable;
import org.eclipse.collections.api.bag.primitive.MutableShortBag;
import org.eclipse.collections.api.block.procedure.primitive.ShortProcedure;
import org.eclipse.collections.api.factory.primitive.ShortBags;
import org.eclipse.collections.api.factory.primitive.ShortLists;
import org.eclipse.collections.api.factory.primitive.ShortSets;
import org.eclipse.collections.api.iterator.ShortIterator;
import org.eclipse.collections.api.list.primitive.MutableShortList;
import org.eclipse.collections.api.list.primitive.ShortList;
import org.eclipse.collections.api.set.primitive.MutableShortSet;
import org.eclipse.collections.impl.lazy.primitive.AbstractLazyShortIterable;
import org.eclipse.collections.impl.lazy.primitive.LazyShortIterableAdapter;

public class ReverseShortIterable
extends AbstractLazyShortIterable {
    private final ShortList adapted;

    public ReverseShortIterable(ShortList newAdapted) {
        this.adapted = newAdapted;
    }

    public static ReverseShortIterable adapt(ShortList shortList) {
        return new ReverseShortIterable(shortList);
    }

    public ShortIterator shortIterator() {
        return new ReverseShortIterator();
    }

    public void each(ShortProcedure procedure) {
        ShortIterator iterator = this.shortIterator();
        while (iterator.hasNext()) {
            procedure.value(iterator.next());
        }
    }

    @Override
    public long sum() {
        return this.adapted.sum();
    }

    @Override
    public short max() {
        return this.adapted.max();
    }

    @Override
    public short min() {
        return this.adapted.min();
    }

    @Override
    public short minIfEmpty(short defaultValue) {
        if (this.adapted.isEmpty()) {
            return defaultValue;
        }
        return this.adapted.min();
    }

    @Override
    public short maxIfEmpty(short defaultValue) {
        if (this.adapted.isEmpty()) {
            return defaultValue;
        }
        return this.adapted.max();
    }

    @Override
    public double average() {
        return this.adapted.average();
    }

    @Override
    public double median() {
        return this.adapted.median();
    }

    @Override
    public short[] toSortedArray() {
        return this.adapted.toSortedArray();
    }

    @Override
    public short[] toArray() {
        short[] results = new short[this.adapted.size()];
        int index = 0;
        ShortIterator iterator = this.shortIterator();
        while (iterator.hasNext()) {
            results[index] = iterator.next();
            ++index;
        }
        return results;
    }

    @Override
    public boolean contains(short value) {
        return this.adapted.contains(value);
    }

    @Override
    public boolean containsAll(short ... source) {
        return this.adapted.containsAll(source);
    }

    @Override
    public boolean containsAll(ShortIterable source) {
        return this.adapted.containsAll(source);
    }

    @Override
    public int size() {
        return this.adapted.size();
    }

    @Override
    public boolean isEmpty() {
        return this.adapted.isEmpty();
    }

    @Override
    public boolean notEmpty() {
        return this.adapted.notEmpty();
    }

    @Override
    public MutableShortList toList() {
        return ShortLists.mutable.withAll((ShortIterable)this);
    }

    @Override
    public MutableShortSet toSet() {
        return ShortSets.mutable.withAll((ShortIterable)this);
    }

    @Override
    public MutableShortBag toBag() {
        return ShortBags.mutable.withAll((ShortIterable)this);
    }

    @Override
    public LazyShortIterable asLazy() {
        return new LazyShortIterableAdapter((ShortIterable)this);
    }

    private class ReverseShortIterator
    implements ShortIterator {
        private int currentIndex;

        private ReverseShortIterator() {
            this.currentIndex = ReverseShortIterable.this.adapted.size() - 1;
        }

        public boolean hasNext() {
            return this.currentIndex != -1;
        }

        public short next() {
            if (!this.hasNext()) {
                throw new NoSuchElementException();
            }
            short next = ReverseShortIterable.this.adapted.get(this.currentIndex);
            --this.currentIndex;
            return next;
        }
    }
}

