/*
 * Decompiled with CFR 0.152.
 */
package org.hiero.hapi.fees;

import com.hedera.hapi.node.base.HederaFunctionality;
import java.util.HashSet;
import java.util.Objects;
import org.hiero.hapi.support.fees.Extra;
import org.hiero.hapi.support.fees.ExtraFeeDefinition;
import org.hiero.hapi.support.fees.ExtraFeeReference;
import org.hiero.hapi.support.fees.FeeSchedule;
import org.hiero.hapi.support.fees.ServiceFeeDefinition;
import org.hiero.hapi.support.fees.ServiceFeeSchedule;

public class FeeScheduleUtils {
    public static ExtraFeeDefinition makeExtraDef(Extra extra, long fee) {
        return ExtraFeeDefinition.newBuilder().name(extra).fee(fee).build();
    }

    public static ExtraFeeReference makeExtraIncluded(Extra extra, int included) {
        return ExtraFeeReference.DEFAULT.copyBuilder().name(extra).includedCount(included).build();
    }

    public static ServiceFeeDefinition makeServiceFee(HederaFunctionality name, long baseFee, ExtraFeeReference ... reference) {
        return ServiceFeeDefinition.DEFAULT.copyBuilder().name(name).baseFee(baseFee).extras(reference).build();
    }

    public static ServiceFeeSchedule makeService(String name, ServiceFeeDefinition ... services) {
        return ServiceFeeSchedule.DEFAULT.copyBuilder().name(name).schedule(services).build();
    }

    public static ExtraFeeDefinition lookupExtraFee(FeeSchedule feeSchedule, Extra ref) {
        for (ExtraFeeDefinition def : feeSchedule.extras()) {
            if (!def.name().equals((Object)ref)) continue;
            return def;
        }
        return null;
    }

    public static ServiceFeeDefinition lookupServiceFee(FeeSchedule feeSchedule, HederaFunctionality api) {
        for (ServiceFeeSchedule service : feeSchedule.services()) {
            for (ServiceFeeDefinition def : service.schedule()) {
                if (def.name() != api) continue;
                return def;
            }
        }
        return null;
    }

    public static boolean isValid(FeeSchedule feeSchedule) {
        Objects.requireNonNull(feeSchedule);
        if (feeSchedule.node() == null) {
            return false;
        }
        if (feeSchedule.network() == null) {
            return false;
        }
        if (feeSchedule.network().multiplier() < 1) {
            return false;
        }
        if (feeSchedule.services().isEmpty()) {
            return false;
        }
        HashSet<Extra> extraNames = new HashSet<Extra>();
        for (Object def : feeSchedule.extras()) {
            if (def.fee() <= 0L) {
                return false;
            }
            if (extraNames.add(def.name())) continue;
            return false;
        }
        HashSet<String> serviceNames = new HashSet<String>();
        for (ServiceFeeSchedule service : feeSchedule.services()) {
            if (!serviceNames.add(service.name())) {
                return false;
            }
            if (service.schedule().isEmpty()) {
                return false;
            }
            HashSet<HederaFunctionality> txNames = new HashSet<HederaFunctionality>();
            for (ServiceFeeDefinition def : service.schedule()) {
                if (!txNames.add(def.name())) {
                    return false;
                }
                if (def.baseFee() < 0L) {
                    return false;
                }
                HashSet<Extra> refNames = new HashSet<Extra>();
                for (ExtraFeeReference ref : def.extras()) {
                    if (ref.includedCount() < 0) {
                        return false;
                    }
                    if (!refNames.add(ref.name())) {
                        return false;
                    }
                    if (FeeScheduleUtils.lookupExtraFee(feeSchedule, ref.name()) != null) continue;
                    return false;
                }
            }
        }
        if (feeSchedule.node().baseFee() < 0L) {
            return false;
        }
        HashSet<Extra> nodeRefNames = new HashSet<Extra>();
        for (ExtraFeeReference ref : feeSchedule.node().extras()) {
            if (ref.includedCount() < 0) {
                return false;
            }
            if (!nodeRefNames.add(ref.name())) {
                return false;
            }
            if (FeeScheduleUtils.lookupExtraFee(feeSchedule, ref.name()) != null) continue;
            return false;
        }
        return true;
    }
}

