/*
 * Decompiled with CFR 0.152.
 */
package io.helidon.service.registry;

import io.helidon.common.types.TypeName;
import io.helidon.service.registry.Lookup;
import io.helidon.service.registry.Qualifier;
import io.helidon.service.registry.ServiceInfo;
import io.helidon.service.registry.ServiceInstance;
import io.helidon.service.registry.ServiceManager;
import java.util.List;
import java.util.Set;
import java.util.stream.Collectors;

final class LookupTrace {
    private static final System.Logger LOGGER = System.getLogger(LookupTrace.class.getName());

    private LookupTrace() {
    }

    static void traceLookup(Lookup lookup, String message, Object ... args) {
        if (LOGGER.isLoggable(System.Logger.Level.DEBUG)) {
            LOGGER.log(System.Logger.Level.DEBUG, LookupTrace.prefix(lookup) + message, args);
        }
    }

    static <T> void traceLookupInstance(Lookup lookup, ServiceManager<T> manager, List<ServiceInstance<T>> instances) {
        if (LOGGER.isLoggable(System.Logger.Level.TRACE)) {
            String serviceType = manager.descriptor().serviceType().fqName();
            if (instances.isEmpty()) {
                LOGGER.log(System.Logger.Level.TRACE, LookupTrace.prefix(lookup) + "service {0} added 0 instances", serviceType);
                return;
            }
            for (ServiceInstance<T> instance : instances) {
                LOGGER.log(System.Logger.Level.TRACE, LookupTrace.prefix(lookup) + "service {0} adding instance: {1}", serviceType, LookupTrace.instanceInfo(instance));
            }
        }
    }

    static <T> void traceLookupInstances(Lookup lookup, List<ServiceInstance<T>> instances) {
        if (LOGGER.isLoggable(System.Logger.Level.DEBUG)) {
            LOGGER.log(System.Logger.Level.DEBUG, LookupTrace.prefix(lookup) + "sorted instances by weight and service:{0}", instances.stream().map(it -> it.serviceType().fqName() + " [" + it.weight() + "]").collect(Collectors.joining(", ")));
        }
    }

    static void traceLookup(Lookup lookup, String message, List<ServiceInfo> services) {
        if (LOGGER.isLoggable(System.Logger.Level.DEBUG)) {
            LOGGER.log(System.Logger.Level.DEBUG, "{0}matching service providers {1}: {2}", LookupTrace.prefix(lookup), message, services.stream().map(ServiceInfo::serviceType).map(rec$ -> ((TypeName)rec$).fqName()).collect(Collectors.toUnmodifiableList()));
        }
    }

    private static String instanceInfo(ServiceInstance<?> instance) {
        double weight = instance.weight();
        TypeName scope = instance.scope();
        Set<Qualifier> qualifiers = instance.qualifiers();
        Object o = instance.get();
        return "weight(" + weight + "), scope(" + LookupTrace.scope(scope) + "), qualifiers(" + qualifiers.stream().map(rec$ -> ((Qualifier)rec$).typeName()).map(rec$ -> ((TypeName)rec$).fqName()).collect(Collectors.joining(", ")) + "), instance(" + String.valueOf(o) + ")";
    }

    private static String scope(TypeName typeName) {
        if (typeName.packageName().startsWith("io.helidon.service.registry")) {
            return typeName.classNameWithEnclosingNames();
        }
        return typeName.fqName();
    }

    private static String prefix(Lookup lookup) {
        return "[" + System.identityHashCode(lookup) + "] ";
    }
}

