/*
 * Decompiled with CFR 0.152.
 */
package ethereum.ckzg4844;

import java.util.Arrays;

public class CKZGException
extends RuntimeException {
    private final CKZGError error;
    private final String errorMessage;

    public CKZGException(int errorCode, String errorMessage) {
        super(String.format("%s (%s)", new Object[]{errorMessage, CKZGError.fromErrorCode(errorCode)}));
        this.error = CKZGError.fromErrorCode(errorCode);
        this.errorMessage = errorMessage;
    }

    public CKZGError getError() {
        return this.error;
    }

    public String getErrorMessage() {
        return this.errorMessage;
    }

    public static enum CKZGError {
        UNKNOWN(0),
        C_KZG_BADARGS(1),
        C_KZG_ERROR(2),
        C_KZG_MALLOC(3);

        public final int errorCode;

        private CKZGError(int errorCode) {
            this.errorCode = errorCode;
        }

        public static CKZGError fromErrorCode(int errorCode) {
            return Arrays.stream(CKZGError.values()).filter(error -> error.errorCode == errorCode).findFirst().orElse(UNKNOWN);
        }
    }
}

