/*
 * Decompiled with CFR 0.152.
 */
package io.helidon.service.registry;

import io.helidon.common.GenericType;
import io.helidon.common.LazyValue;
import io.helidon.common.types.ResolvedType;
import io.helidon.common.types.TypeName;
import io.helidon.common.types.TypeNames;
import io.helidon.service.registry.ActivationPhase;
import io.helidon.service.registry.ActivationRequest;
import io.helidon.service.registry.ActivationResult;
import io.helidon.service.registry.Activator;
import io.helidon.service.registry.ActivatorsPerLookup;
import io.helidon.service.registry.BindingDependencyContext;
import io.helidon.service.registry.Bindings;
import io.helidon.service.registry.CoreServiceRegistry;
import io.helidon.service.registry.Dependency;
import io.helidon.service.registry.DependencyContext;
import io.helidon.service.registry.FactoryType;
import io.helidon.service.registry.GeneratedService;
import io.helidon.service.registry.InterceptionMetadata;
import io.helidon.service.registry.Lookup;
import io.helidon.service.registry.Qualifier;
import io.helidon.service.registry.Service;
import io.helidon.service.registry.ServiceDescriptor;
import io.helidon.service.registry.ServiceInfo;
import io.helidon.service.registry.ServiceInstance;
import io.helidon.service.registry.ServiceProvider;
import io.helidon.service.registry.ServiceRegistryException;
import io.helidon.service.registry.SupplierDependencyContext;
import java.lang.invoke.LambdaMetafactory;
import java.util.ArrayList;
import java.util.Collection;
import java.util.HashMap;
import java.util.LinkedHashSet;
import java.util.List;
import java.util.Optional;
import java.util.Set;
import java.util.concurrent.locks.ReadWriteLock;
import java.util.concurrent.locks.ReentrantLock;
import java.util.concurrent.locks.ReentrantReadWriteLock;
import java.util.function.Predicate;
import java.util.function.Supplier;
import java.util.stream.Collectors;

final class Activators {
    private Activators() {
    }

    static <T> Activator<T> create(ServiceProvider<T> provider, T instance) {
        return switch (provider.descriptor().factoryType()) {
            default -> throw new MatchException(null, null);
            case FactoryType.NONE, FactoryType.SERVICE, FactoryType.SUPPLIER -> {
                if (instance instanceof Supplier) {
                    Supplier supplier = (Supplier)instance;
                    yield new FixedSupplierActivator<T>(provider, supplier);
                }
                yield new FixedActivator<T>(provider, instance);
            }
            case FactoryType.SERVICES -> new FixedServicesFactoryActivator<T>(provider, (Service.ServicesFactory)instance);
            case FactoryType.INJECTION_POINT -> new FixedIpFactoryActivator<T>(provider, (Service.InjectionPointFactory)instance);
            case FactoryType.QUALIFIED -> new FixedQualifiedFactoryActivator<T>(provider, (Service.QualifiedFactory)instance);
        };
    }

    static <T> Supplier<Activator<T>> create(CoreServiceRegistry registry, ServiceProvider<T> provider) {
        ServiceDescriptor descriptor = provider.descriptor();
        Bindings.ServiceBindingPlan bindingPlan = registry.bindings().bindingPlan(descriptor);
        BindingDependencyContext dependencyContext = new BindingDependencyContext(bindingPlan);
        if (descriptor.scope().equals((Object)Service.PerLookup.TYPE)) {
            return switch (descriptor.factoryType()) {
                default -> throw new MatchException(null, null);
                case FactoryType.NONE -> new MissingDescribedActivator<T>(provider);
                case FactoryType.SERVICE -> {
                    if (descriptor instanceof GeneratedService.PerInstanceDescriptor) {
                        GeneratedService.PerInstanceDescriptor dbd = (GeneratedService.PerInstanceDescriptor)((Object)descriptor);
                        yield () -> new ActivatorsPerLookup.PerInstanceActivator(registry, dependencyContext, bindingPlan, provider, dbd);
                    }
                    yield () -> new ActivatorsPerLookup.SingleServiceActivator(provider, dependencyContext);
                }
                case FactoryType.SUPPLIER -> () -> new ActivatorsPerLookup.SupplierActivator(provider, dependencyContext);
                case FactoryType.SERVICES -> () -> new ActivatorsPerLookup.ServicesFactoryActivator(provider, dependencyContext);
                case FactoryType.INJECTION_POINT -> () -> new ActivatorsPerLookup.IpFactoryActivator(provider, dependencyContext);
                case FactoryType.QUALIFIED -> () -> new ActivatorsPerLookup.QualifiedFactoryActivator(provider, dependencyContext, (GeneratedService.QualifiedFactoryDescriptor)((Object)descriptor));
            };
        }
        return switch (descriptor.factoryType()) {
            default -> throw new MatchException(null, null);
            case FactoryType.NONE -> new MissingDescribedActivator<T>(provider);
            case FactoryType.SERVICE -> {
                if (descriptor instanceof GeneratedService.PerInstanceDescriptor) {
                    GeneratedService.PerInstanceDescriptor dbd = (GeneratedService.PerInstanceDescriptor)((Object)descriptor);
                    yield () -> new PerInstanceActivator(registry, provider, dependencyContext, bindingPlan, dbd);
                }
                yield () -> new SingleServiceActivator(provider, dependencyContext);
            }
            case FactoryType.SUPPLIER -> () -> new SupplierActivator(provider, dependencyContext);
            case FactoryType.SERVICES -> () -> new ServicesFactoryActivator(provider, dependencyContext);
            case FactoryType.INJECTION_POINT -> () -> new IpFactoryActivator(provider, dependencyContext);
            case FactoryType.QUALIFIED -> () -> new QualifiedFactoryActivator(provider, dependencyContext, (GeneratedService.QualifiedFactoryDescriptor)((Object)descriptor));
        };
    }

    static class FixedSupplierActivator<T>
    extends BaseActivator<T> {
        private final Supplier<Optional<List<Service.QualifiedInstance<T>>>> instances = LazyValue.create(() -> {
            List values = List.of(Service.QualifiedInstance.create(instanceSupplier.get(), provider.descriptor().qualifiers()));
            return Optional.of(values);
        });

        FixedSupplierActivator(ServiceProvider<T> provider, Supplier<T> instanceSupplier) {
            super(provider, null);
        }

        @Override
        protected Optional<List<Service.QualifiedInstance<T>>> targetInstances() {
            return this.instances.get();
        }
    }

    static class FixedActivator<T>
    extends BaseActivator<T> {
        private final Optional<List<Service.QualifiedInstance<T>>> instances;

        FixedActivator(ServiceProvider<T> provider, T instance) {
            super(provider, null);
            List<Service.QualifiedInstance<T>> values = List.of(Service.QualifiedInstance.create(instance, provider.descriptor().qualifiers()));
            this.instances = Optional.of(values);
        }

        @Override
        protected Optional<List<Service.QualifiedInstance<T>>> targetInstances() {
            return this.instances;
        }
    }

    static class FixedServicesFactoryActivator<T>
    extends ServicesFactoryActivator<T> {
        FixedServicesFactoryActivator(ServiceProvider<T> provider, Service.ServicesFactory<T> factory) {
            super(provider, null);
            this.serviceInstance = InstanceHolder.create(factory);
        }
    }

    static class FixedIpFactoryActivator<T>
    extends IpFactoryActivator<T> {
        FixedIpFactoryActivator(ServiceProvider<T> provider, Service.InjectionPointFactory<T> instance) {
            super(provider, null);
            this.serviceInstance = InstanceHolder.create(instance);
        }
    }

    static class FixedQualifiedFactoryActivator<T>
    extends QualifiedFactoryActivator<T> {
        FixedQualifiedFactoryActivator(ServiceProvider<T> provider, Service.QualifiedFactory<T, ?> factory) {
            super(provider, null, (GeneratedService.QualifiedFactoryDescriptor)((Object)provider.descriptor()));
            this.serviceInstance = InstanceHolder.create(factory);
        }
    }

    private static class MissingDescribedActivator<T>
    implements Supplier<Activator<T>> {
        private static final System.Logger LOGGER = System.getLogger(Activators.class.getName());
        private final String serviceType;

        private MissingDescribedActivator(ServiceProvider<T> provider) {
            this.serviceType = provider.descriptor().serviceType().fqName();
            if (LOGGER.isLoggable(System.Logger.Level.DEBUG)) {
                LOGGER.log(System.Logger.Level.DEBUG, "The registry knows of a descriptor that was generated on demand (@" + Service.Describe.class.getName() + "), which expects an instance configured for it, either when creating the registry through configuration, or when creating a scope. Service that does not have an instance registered: " + this.serviceType + ", if there is an attempt on injecting this type, a runtime exception will be thrown");
            }
        }

        @Override
        public Activator<T> get() {
            throw new ServiceRegistryException("Instance for " + this.serviceType + " must be provided explicitly either during startup, or when creating a scope. Cannot provide an instance for a descriptor without a service.");
        }
    }

    static class QualifiedFactoryActivator<T>
    extends SingleServiceActivator<T> {
        private final TypeName supportedQualifier;
        private final Set<ResolvedType> supportedContracts;
        private final boolean anyMatch;

        QualifiedFactoryActivator(ServiceProvider<T> provider, DependencyContext dependencyContext, GeneratedService.QualifiedFactoryDescriptor qpd) {
            super(provider, dependencyContext);
            this.supportedQualifier = qpd.qualifierType();
            this.supportedContracts = provider.descriptor().contracts().stream().filter(it -> !Service.QualifiedFactory.TYPE.equals((Object)it.type())).collect(Collectors.toSet());
            this.anyMatch = this.supportedContracts.contains(ResolvedType.create((TypeName)TypeNames.OBJECT));
        }

        @Override
        protected void setTargetInstances() {
        }

        @Override
        protected Optional<List<Service.QualifiedInstance<T>>> targetInstances(Lookup lookup) {
            if (this.serviceInstance == null) {
                return Optional.empty();
            }
            return lookup.qualifiers().stream().filter(it -> this.supportedQualifier.equals((Object)it.typeName())).findFirst().flatMap(qualifier -> this.targetInstances(lookup, (Qualifier)qualifier));
        }

        private Optional<List<Service.QualifiedInstance<T>>> targetInstances(Lookup lookup, Qualifier qualifier) {
            if (lookup.contracts().size() == 1 && (this.anyMatch || this.supportedContracts.containsAll(lookup.contracts()))) {
                Optional<GenericType> genericType = lookup.dependency().map(Dependency::contractType);
                GenericType contract = genericType.or(lookup::contractType).orElse(GenericType.OBJECT);
                return Optional.of(this.targetInstances(lookup, qualifier, contract));
            }
            return Optional.empty();
        }

        private List<Service.QualifiedInstance<T>> targetInstances(Lookup lookup, Qualifier qualifier, GenericType<T> contract) {
            Service.QualifiedFactory qProvider = (Service.QualifiedFactory)this.serviceInstance.get();
            return qProvider.list(qualifier, lookup, contract);
        }
    }

    static class IpFactoryActivator<T>
    extends SingleServiceActivator<T> {
        IpFactoryActivator(ServiceProvider<T> provider, DependencyContext dependencyContext) {
            super(provider, dependencyContext);
        }

        @Override
        protected void setTargetInstances() {
        }

        @Override
        protected Optional<List<Service.QualifiedInstance<T>>> targetInstances(Lookup lookup) {
            if (this.serviceInstance == null) {
                return Optional.empty();
            }
            Service.InjectionPointFactory ipProvider = (Service.InjectionPointFactory)this.serviceInstance.get();
            if (this.requestedProvider(lookup, FactoryType.INJECTION_POINT)) {
                Service.InjectionPointFactory instance = ipProvider;
                return Optional.of(List.of(Service.QualifiedInstance.create(instance, this.provider.descriptor().qualifiers())));
            }
            try {
                return Optional.of(ipProvider.list(lookup));
            }
            catch (RuntimeException e) {
                throw new ServiceRegistryException("Failed to list instances in InjectionPointProvider: " + ipProvider.getClass().getName(), e);
            }
        }
    }

    static class ServicesFactoryActivator<T>
    extends SingleServiceActivator<T> {
        ServicesFactoryActivator(ServiceProvider<T> provider, DependencyContext dependencyContext) {
            super(provider, dependencyContext);
        }

        @Override
        protected void construct(ActivationResult.Builder response) {
            super.construct(response);
        }

        @Override
        protected void setTargetInstances() {
            if (this.serviceInstance == null) {
                return;
            }
            Service.ServicesFactory instanceSupplier = (Service.ServicesFactory)this.serviceInstance.get();
            this.targetInstances = instanceSupplier.services();
        }

        @Override
        protected Optional<List<Service.QualifiedInstance<T>>> targetInstances(Lookup lookup) {
            if (this.requestedProvider(lookup, FactoryType.SERVICES)) {
                return Optional.of(List.of(Service.QualifiedInstance.create(this.serviceInstance.get(), this.descriptor().qualifiers())));
            }
            if (this.targetInstances == null) {
                return Optional.empty();
            }
            ArrayList<Service.QualifiedInstance> response = new ArrayList<Service.QualifiedInstance>();
            for (Service.QualifiedInstance instance : this.targetInstances) {
                if (!lookup.matchesQualifiers(instance.qualifiers())) continue;
                response.add(instance);
            }
            return Optional.of(List.copyOf(response));
        }
    }

    static class SupplierActivator<T>
    extends SingleServiceActivator<T> {
        SupplierActivator(ServiceProvider<T> provider, DependencyContext dependencyContext) {
            super(provider, dependencyContext);
        }

        @Override
        protected Optional<List<Service.QualifiedInstance<T>>> targetInstances(Lookup lookup) {
            if (this.requestedProvider(lookup, FactoryType.SUPPLIER)) {
                Object instance = this.serviceInstance.get();
                return Optional.of(List.of(Service.QualifiedInstance.create(instance, this.provider.descriptor().qualifiers())));
            }
            return super.targetInstances(lookup);
        }

        @Override
        protected void setTargetInstances() {
            if (this.serviceInstance == null) {
                return;
            }
            Supplier instanceSupplier = (Supplier)this.serviceInstance.get();
            Object value = instanceSupplier.get();
            if (value instanceof Optional) {
                Optional opt = (Optional)value;
                if (opt.isPresent()) {
                    value = opt.get();
                    this.targetInstances = List.of(Service.QualifiedInstance.create(value, this.provider.descriptor().qualifiers()));
                } else {
                    this.targetInstances = List.of();
                }
            } else {
                this.targetInstances = List.of(Service.QualifiedInstance.create(value, this.provider.descriptor().qualifiers()));
            }
        }
    }

    static class SingleServiceActivator<T>
    extends BaseActivator<T> {
        private final ReentrantLock lock = new ReentrantLock();
        protected InstanceHolder<T> serviceInstance;
        protected List<Service.QualifiedInstance<T>> targetInstances;

        SingleServiceActivator(ServiceProvider<T> provider, DependencyContext dependencyContext) {
            super(provider, dependencyContext);
        }

        @Override
        protected Optional<List<Service.QualifiedInstance<T>>> targetInstances() {
            return Optional.ofNullable(this.targetInstances);
        }

        @Override
        protected void construct(ActivationResult.Builder response) {
            if (this.lock.isHeldByCurrentThread()) {
                throw new ServiceRegistryException("Cyclic dependency, attempting to obtain an instance of " + this.provider.descriptor().serviceType().fqName() + " while instantiating it");
            }
            try {
                this.lock.lock();
                if (this.serviceInstance == null) {
                    this.serviceInstance = InstanceHolder.create(this.provider, this.dependencyContext);
                }
                this.serviceInstance.construct();
            }
            finally {
                this.lock.unlock();
            }
        }

        @Override
        protected void setTargetInstances() {
            if (this.serviceInstance != null) {
                this.targetInstances = List.of(Service.QualifiedInstance.create(this.serviceInstance.get(), this.provider.descriptor().qualifiers()));
            }
        }

        @Override
        protected void inject(ActivationResult.Builder response) {
            if (this.serviceInstance != null) {
                this.serviceInstance.inject();
            }
        }

        @Override
        protected void postConstruct(ActivationResult.Builder response) {
            if (this.serviceInstance != null) {
                this.serviceInstance.postConstruct();
            }
        }

        @Override
        protected void preDestroy(ActivationResult.Builder response) {
            if (this.serviceInstance != null) {
                this.serviceInstance.preDestroy();
            }
            this.serviceInstance = null;
            this.targetInstances = null;
        }
    }

    static class PerInstanceActivator<T>
    extends BaseActivator<T> {
        private final CoreServiceRegistry registry;
        private final ResolvedType createFor;
        private final Lookup createForLookup;
        private final Bindings.ServiceBindingPlan bindingPlan;
        private List<QualifiedServiceInstance<T>> serviceInstances;
        private List<Service.QualifiedInstance<T>> targetInstances;

        PerInstanceActivator(CoreServiceRegistry registry, ServiceProvider<T> provider, DependencyContext dependencyContext, Bindings.ServiceBindingPlan bindingPlan, GeneratedService.PerInstanceDescriptor dbd) {
            super(provider, dependencyContext);
            this.registry = registry;
            this.bindingPlan = bindingPlan;
            this.createFor = ResolvedType.create((TypeName)dbd.createFor());
            this.createForLookup = ((Lookup.Builder)Lookup.builder().addContract(this.createFor)).build();
        }

        static DependencyContext updatePlan(Bindings.ServiceBindingPlan injectionPlan, DependencyContext dependencyContext, ServiceInstance<?> driver, Qualifier name) {
            Set<ResolvedType> contracts = driver.contracts();
            HashMap<Dependency, Supplier<Object>> targetPlan = new HashMap<Dependency, Supplier<Object>>();
            for (Bindings.DependencyBinding binding : injectionPlan.allBindings()) {
                Dependency dependency = binding.dependency();
                boolean updated = false;
                if (contracts.contains(ResolvedType.create((TypeName)dependency.contract())) && dependency.qualifiers().isEmpty()) {
                    updated = true;
                    if (dependency.isServiceInstance()) {
                        targetPlan.put(dependency, () -> driver);
                    } else {
                        targetPlan.put(dependency, driver::get);
                    }
                }
                if (TypeNames.STRING.equals((Object)dependency.contract()) && dependency.qualifiers().stream().anyMatch(it -> Service.InstanceName.TYPE.equals((Object)it.typeName()))) {
                    updated = true;
                    targetPlan.put(dependency, () -> name.value().orElse("@default"));
                }
                if (updated) continue;
                targetPlan.put(dependency, () -> dependencyContext.dependency(dependency));
            }
            return new SupplierDependencyContext(targetPlan);
        }

        @Override
        protected void construct(ActivationResult.Builder response) {
            List drivingInstances = this.driversFromPlan(this.bindingPlan, this.createFor).stream().map(this.registry::serviceManager).flatMap(it -> it.activator().instances(this.createForLookup).stream().flatMap(Collection::stream).map(qi -> it.registryInstance(this.createForLookup, qi))).toList();
            this.serviceInstances = drivingInstances.stream().map(it -> QualifiedServiceInstance.create(this.provider, this.bindingPlan, this.dependencyContext, it)).toList();
            for (QualifiedServiceInstance<T> serviceInstance : this.serviceInstances) {
                serviceInstance.serviceInstance().construct();
            }
        }

        @Override
        protected void inject(ActivationResult.Builder response) {
            for (QualifiedServiceInstance<T> instance : this.serviceInstances) {
                instance.serviceInstance().inject();
            }
        }

        @Override
        protected void postConstruct(ActivationResult.Builder response) {
            for (QualifiedServiceInstance<T> instance : this.serviceInstances) {
                instance.serviceInstance().postConstruct();
            }
        }

        @Override
        protected void setTargetInstances() {
            if (this.serviceInstances != null) {
                this.targetInstances = this.serviceInstances.stream().map(it -> Service.QualifiedInstance.create(it.serviceInstance().get(), it.qualifiers())).toList();
            }
        }

        @Override
        protected void preDestroy(ActivationResult.Builder response) {
            if (this.serviceInstances != null) {
                this.serviceInstances.stream().map(QualifiedServiceInstance::serviceInstance).forEach(InstanceHolder::preDestroy);
            }
            this.serviceInstances = null;
            this.targetInstances = null;
        }

        @Override
        protected Optional<List<Service.QualifiedInstance<T>>> targetInstances(Lookup lookup) {
            if (this.targetInstances == null) {
                return Optional.empty();
            }
            ArrayList<Service.QualifiedInstance<T>> response = new ArrayList<Service.QualifiedInstance<T>>();
            for (Service.QualifiedInstance<T> instance : this.targetInstances) {
                if (!lookup.matchesQualifiers(instance.qualifiers())) continue;
                response.add(instance);
            }
            return Optional.of(List.copyOf(response));
        }

        private List<ServiceInfo> driversFromPlan(Bindings.ServiceBindingPlan ipSupplierMap, ResolvedType createFor) {
            for (Bindings.DependencyBinding binding : ipSupplierMap.allBindings()) {
                Dependency dependency = binding.dependency();
                if (!createFor.equals((Object)ResolvedType.create((TypeName)dependency.contract())) || dependency.qualifiers().size() != 1 || !dependency.qualifiers().contains(Qualifier.WILDCARD_NAMED)) continue;
                return binding.descriptors();
            }
            return this.registry.servicesByContract(createFor);
        }

        private record QualifiedServiceInstance<T>(InstanceHolder<T> serviceInstance, Set<Qualifier> qualifiers) {
            static <T> QualifiedServiceInstance<T> create(ServiceProvider<T> provider, Bindings.ServiceBindingPlan bindingPlan, DependencyContext dependencyContext, ServiceInstance<?> driver) {
                Set<Qualifier> qualifiers = driver.qualifiers();
                Qualifier name = qualifiers.stream().filter(Predicate.not((Predicate<Qualifier>)LambdaMetafactory.metafactory(null, null, null, (Ljava/lang/Object;)Z, equals(java.lang.Object ), (Lio/helidon/service/registry/Qualifier;)Z)((Qualifier)Qualifier.WILDCARD_NAMED))).filter(it -> Service.Named.TYPE.equals((Object)it.typeName())).findFirst().orElse(Qualifier.DEFAULT_NAMED);
                Set<Qualifier> newQualifiers = provider.descriptor().qualifiers().stream().filter(Predicate.not((Predicate<Qualifier>)LambdaMetafactory.metafactory(null, null, null, (Ljava/lang/Object;)Z, equals(java.lang.Object ), (Lio/helidon/service/registry/Qualifier;)Z)((Qualifier)Qualifier.WILDCARD_NAMED))).collect(Collectors.toSet());
                newQualifiers.add(name);
                DependencyContext targetDependencyContext = PerInstanceActivator.updatePlan(bindingPlan, dependencyContext, driver, name);
                return new QualifiedServiceInstance<T>(InstanceHolder.create(provider, targetDependencyContext), newQualifiers);
            }
        }
    }

    private static class InstanceHolderImpl<T>
    implements InstanceHolder<T> {
        private final DependencyContext ctx;
        private final InterceptionMetadata interceptionMetadata;
        private final ServiceDescriptor<T> source;
        private volatile T instance;

        private InstanceHolderImpl(DependencyContext ctx, InterceptionMetadata interceptionMetadata, ServiceDescriptor<T> source) {
            this.ctx = ctx;
            this.interceptionMetadata = interceptionMetadata;
            this.source = source;
        }

        @Override
        public T get() {
            return this.instance;
        }

        @Override
        public void construct() {
            this.instance = this.source.instantiate(this.ctx, this.interceptionMetadata);
        }

        @Override
        public void inject() {
            LinkedHashSet<String> injected = new LinkedHashSet<String>();
            this.source.inject(this.ctx, this.interceptionMetadata, injected, this.instance);
        }

        @Override
        public void postConstruct() {
            if (this.instance != null) {
                this.source.postConstruct(this.instance);
            }
        }

        @Override
        public void preDestroy() {
            if (this.instance != null) {
                this.source.preDestroy(this.instance);
            }
        }
    }

    private static class FixedInstanceHolder<T>
    implements InstanceHolder<T> {
        private final T instance;

        private FixedInstanceHolder(T instance) {
            this.instance = instance;
        }

        @Override
        public T get() {
            return this.instance;
        }
    }

    static abstract class BaseActivator<T>
    implements Activator<T> {
        final ServiceProvider<T> provider;
        final DependencyContext dependencyContext;
        private final ReadWriteLock instanceLock = new ReentrantReadWriteLock();
        volatile ActivationPhase currentPhase = ActivationPhase.INIT;

        BaseActivator(ServiceProvider<T> provider, DependencyContext dependencyContext) {
            this.provider = provider;
            this.dependencyContext = dependencyContext;
        }

        /*
         * WARNING - Removed try catching itself - possible behaviour change.
         */
        @Override
        public Optional<List<Service.QualifiedInstance<T>>> instances(Lookup lookup) {
            this.instanceLock.readLock().lock();
            try {
                if (this.currentPhase == ActivationPhase.ACTIVE) {
                    Optional<List<Service.QualifiedInstance<T>>> optional = this.targetInstances(lookup);
                    return optional;
                }
            }
            finally {
                this.instanceLock.readLock().unlock();
            }
            this.instanceLock.writeLock().lock();
            try {
                ActivationResult res;
                if (this.currentPhase != ActivationPhase.ACTIVE && (res = this.activate(this.provider.activationRequest())).failure()) {
                    Optional<List<Service.QualifiedInstance<T>>> optional = Optional.empty();
                    return optional;
                }
                Optional<List<Service.QualifiedInstance<T>>> optional = this.targetInstances(lookup);
                return optional;
            }
            finally {
                this.instanceLock.writeLock().unlock();
            }
        }

        @Override
        public ServiceDescriptor<T> descriptor() {
            return this.provider.descriptor();
        }

        @Override
        public String description() {
            return this.provider.descriptor().serviceType().classNameWithEnclosingNames() + ":" + String.valueOf((Object)this.currentPhase);
        }

        @Override
        public ActivationResult activate(ActivationRequest request) {
            this.instanceLock.writeLock().lock();
            try {
                if (this.currentPhase == request.targetPhase()) {
                    ActivationResult activationResult = ((ActivationResult.Builder)((ActivationResult.Builder)((ActivationResult.Builder)((ActivationResult.Builder)ActivationResult.builder().startingActivationPhase(this.currentPhase)).finishingActivationPhase(this.currentPhase)).targetActivationPhase(this.currentPhase)).success(true)).build();
                    return activationResult;
                }
                if (this.currentPhase.ordinal() > request.targetPhase().ordinal()) {
                    ActivationResult activationResult = ((ActivationResult.Builder)((ActivationResult.Builder)((ActivationResult.Builder)((ActivationResult.Builder)ActivationResult.builder().startingActivationPhase(this.currentPhase)).finishingActivationPhase(this.currentPhase)).targetActivationPhase(request.targetPhase())).success(false)).build();
                    return activationResult;
                }
                ActivationResult activationResult = this.doActivate(request);
                return activationResult;
            }
            finally {
                this.instanceLock.writeLock().unlock();
            }
        }

        @Override
        public ActivationResult deactivate() {
            this.instanceLock.writeLock().lock();
            try {
                ActivationResult.Builder response = (ActivationResult.Builder)ActivationResult.builder().success(true);
                if (!this.currentPhase.eligibleForDeactivation()) {
                    this.stateTransitionStart(response, ActivationPhase.DESTROYED);
                    ActivationResult activationResult = ((ActivationResult.Builder)((ActivationResult.Builder)((ActivationResult.Builder)ActivationResult.builder().targetActivationPhase(ActivationPhase.DESTROYED)).finishingActivationPhase(this.currentPhase)).success(true)).build();
                    return activationResult;
                }
                response.startingActivationPhase(this.currentPhase);
                this.stateTransitionStart(response, ActivationPhase.PRE_DESTROYING);
                this.preDestroy(response);
                this.stateTransitionStart(response, ActivationPhase.DESTROYED);
                ActivationResult activationResult = response.build();
                return activationResult;
            }
            finally {
                this.instanceLock.writeLock().unlock();
            }
        }

        @Override
        public ActivationPhase phase() {
            return this.currentPhase;
        }

        public String toString() {
            return this.getClass().getSimpleName() + " for " + String.valueOf(this.provider);
        }

        protected void construct(ActivationResult.Builder response) {
        }

        protected void inject(ActivationResult.Builder response) {
        }

        protected void postConstruct(ActivationResult.Builder response) {
        }

        protected void finishActivation(ActivationResult.Builder response) {
        }

        protected void preDestroy(ActivationResult.Builder response) {
        }

        protected void setTargetInstances() {
        }

        protected Optional<List<Service.QualifiedInstance<T>>> targetInstances(Lookup lookup) {
            return this.targetInstances();
        }

        protected Optional<List<Service.QualifiedInstance<T>>> targetInstances() {
            return Optional.empty();
        }

        protected boolean requestedProvider(Lookup lookup, FactoryType providerType) {
            if (lookup.factoryTypes().contains((Object)providerType)) {
                return true;
            }
            if (lookup.contracts().size() == 1) {
                ResolvedType requestedContract = lookup.contracts().iterator().next();
                if (requestedContract.equals((Object)ResolvedType.create((TypeName)this.descriptor().serviceType()))) {
                    return true;
                }
                if (this.descriptor().factoryContracts().contains(requestedContract) && !this.descriptor().contracts().contains(requestedContract)) {
                    return true;
                }
            }
            return lookup.serviceType().isPresent() && lookup.serviceType().get().equals((Object)this.descriptor().serviceType());
        }

        private void stateTransitionStart(ActivationResult.Builder res, ActivationPhase phase) {
            res.finishingActivationPhase(phase);
            this.currentPhase = phase;
        }

        private ActivationResult doActivate(ActivationRequest request) {
            ActivationPhase initialPhase = this.currentPhase;
            ActivationPhase startingPhase = request.startingPhase().orElse(initialPhase);
            ActivationPhase targetPhase = request.targetPhase();
            this.currentPhase = startingPhase;
            ActivationPhase finishingPhase = startingPhase;
            ActivationResult.Builder response = (ActivationResult.Builder)((ActivationResult.Builder)((ActivationResult.Builder)((ActivationResult.Builder)ActivationResult.builder().startingActivationPhase(initialPhase)).finishingActivationPhase(startingPhase)).targetActivationPhase(targetPhase)).success(true);
            if (targetPhase.ordinal() > ActivationPhase.ACTIVATION_STARTING.ordinal() && initialPhase == ActivationPhase.INIT && (ActivationPhase.INIT == startingPhase || ActivationPhase.ACTIVATION_STARTING == startingPhase || ActivationPhase.DESTROYED == startingPhase)) {
                this.stateTransitionStart(response, ActivationPhase.ACTIVATION_STARTING);
            }
            finishingPhase = response.finishingActivationPhase().orElse(finishingPhase);
            if (response.targetActivationPhase().ordinal() >= ActivationPhase.CONSTRUCTING.ordinal()) {
                this.stateTransitionStart(response, ActivationPhase.CONSTRUCTING);
                this.construct(response);
            }
            finishingPhase = response.finishingActivationPhase().orElse(finishingPhase);
            if (response.targetActivationPhase().ordinal() >= ActivationPhase.INJECTING.ordinal() && ActivationPhase.CONSTRUCTING == finishingPhase) {
                this.stateTransitionStart(response, ActivationPhase.INJECTING);
                this.inject(response);
            }
            finishingPhase = response.finishingActivationPhase().orElse(finishingPhase);
            if (response.targetActivationPhase().ordinal() >= ActivationPhase.POST_CONSTRUCTING.ordinal() && ActivationPhase.INJECTING == finishingPhase) {
                this.stateTransitionStart(response, ActivationPhase.POST_CONSTRUCTING);
                this.postConstruct(response);
            }
            finishingPhase = response.finishingActivationPhase().orElse(finishingPhase);
            if (response.targetActivationPhase().ordinal() >= ActivationPhase.ACTIVATION_FINISHING.ordinal() && ActivationPhase.POST_CONSTRUCTING == finishingPhase) {
                this.stateTransitionStart(response, ActivationPhase.ACTIVATION_FINISHING);
                this.finishActivation(response);
            }
            finishingPhase = response.finishingActivationPhase().orElse(finishingPhase);
            if (response.targetActivationPhase().ordinal() >= ActivationPhase.ACTIVE.ordinal() && ActivationPhase.ACTIVATION_FINISHING == finishingPhase) {
                this.stateTransitionStart(response, ActivationPhase.ACTIVE);
            }
            if (startingPhase.ordinal() < ActivationPhase.CONSTRUCTING.ordinal() && this.currentPhase.ordinal() >= ActivationPhase.CONSTRUCTING.ordinal()) {
                this.setTargetInstances();
            }
            return response.build();
        }
    }

    static interface InstanceHolder<T> {
        public static <T> InstanceHolder<T> create(ServiceProvider<T> serviceProvider, DependencyContext dependencyContext) {
            return new InstanceHolderImpl<T>(dependencyContext, serviceProvider.interceptionMetadata(), serviceProvider.descriptor());
        }

        public static <T> InstanceHolder<T> create(Object instance) {
            return new FixedInstanceHolder<Object>(instance);
        }

        public T get();

        default public void construct() {
        }

        default public void inject() {
        }

        default public void postConstruct() {
        }

        default public void preDestroy() {
        }
    }
}

