/*
 * Decompiled with CFR 0.152.
 */
package com.hedera.pbj.grpc.helidon;

import com.hedera.pbj.runtime.grpc.GrpcStatus;
import edu.umd.cs.findbugs.annotations.NonNull;
import io.helidon.http.Header;
import io.helidon.http.HeaderName;
import io.helidon.http.HeaderNames;
import io.helidon.http.HeaderValues;
import io.helidon.http.HttpMediaType;

final class GrpcHeaders {
    static final HeaderName GRPC_TIMEOUT = HeaderNames.create((String)"grpc-timeout");
    static final HeaderName GRPC_ENCODING = HeaderNames.create((String)"grpc-encoding");
    static final HeaderName GRPC_ACCEPT_ENCODING = HeaderNames.create((String)"grpc-accept-encoding");
    static final HeaderName GRPC_MESSAGE = HeaderNames.createFromLowercase((String)"grpc-message");
    static final HeaderName GRPC_STATUS = HeaderNames.createFromLowercase((String)"grpc-status");
    static final HttpMediaType APPLICATION_GRPC_PROTO_TYPE = HttpMediaType.create((String)"application/grpc");
    static final Header OK = HeaderValues.createCached((HeaderName)GRPC_STATUS, (int)GrpcStatus.OK.ordinal());
    static final Header CANCELLED = HeaderValues.createCached((HeaderName)GRPC_STATUS, (int)GrpcStatus.CANCELLED.ordinal());
    static final Header UNKNOWN = HeaderValues.createCached((HeaderName)GRPC_STATUS, (int)GrpcStatus.UNKNOWN.ordinal());
    static final Header INVALID_ARGUMENT = HeaderValues.createCached((HeaderName)GRPC_STATUS, (int)GrpcStatus.INVALID_ARGUMENT.ordinal());
    static final Header DEADLINE_EXCEEDED = HeaderValues.createCached((HeaderName)GRPC_STATUS, (int)GrpcStatus.DEADLINE_EXCEEDED.ordinal());
    static final Header NOT_FOUND = HeaderValues.createCached((HeaderName)GRPC_STATUS, (int)GrpcStatus.NOT_FOUND.ordinal());
    static final Header ALREADY_EXISTS = HeaderValues.createCached((HeaderName)GRPC_STATUS, (int)GrpcStatus.ALREADY_EXISTS.ordinal());
    static final Header PERMISSION_DENIED = HeaderValues.createCached((HeaderName)GRPC_STATUS, (int)GrpcStatus.PERMISSION_DENIED.ordinal());
    static final Header RESOURCE_EXHAUSTED = HeaderValues.createCached((HeaderName)GRPC_STATUS, (int)GrpcStatus.RESOURCE_EXHAUSTED.ordinal());
    static final Header FAILED_PRECONDITION = HeaderValues.createCached((HeaderName)GRPC_STATUS, (int)GrpcStatus.FAILED_PRECONDITION.ordinal());
    static final Header ABORTED = HeaderValues.createCached((HeaderName)GRPC_STATUS, (int)GrpcStatus.ABORTED.ordinal());
    static final Header OUT_OF_RANGE = HeaderValues.createCached((HeaderName)GRPC_STATUS, (int)GrpcStatus.OUT_OF_RANGE.ordinal());
    static final Header UNIMPLEMENTED = HeaderValues.createCached((HeaderName)GRPC_STATUS, (int)GrpcStatus.UNIMPLEMENTED.ordinal());
    static final Header INTERNAL = HeaderValues.createCached((HeaderName)GRPC_STATUS, (int)GrpcStatus.INTERNAL.ordinal());
    static final Header UNAVAILABLE = HeaderValues.createCached((HeaderName)GRPC_STATUS, (int)GrpcStatus.UNAVAILABLE.ordinal());
    static final Header DATA_LOSS = HeaderValues.createCached((HeaderName)GRPC_STATUS, (int)GrpcStatus.DATA_LOSS.ordinal());
    static final Header UNAUTHENTICATED = HeaderValues.createCached((HeaderName)GRPC_STATUS, (int)GrpcStatus.UNAUTHENTICATED.ordinal());

    private GrpcHeaders() {
    }

    @NonNull
    static Header header(@NonNull GrpcStatus status) {
        return switch (status) {
            default -> throw new MatchException(null, null);
            case GrpcStatus.OK -> OK;
            case GrpcStatus.CANCELLED -> CANCELLED;
            case GrpcStatus.UNKNOWN -> UNKNOWN;
            case GrpcStatus.INVALID_ARGUMENT -> INVALID_ARGUMENT;
            case GrpcStatus.DEADLINE_EXCEEDED -> DEADLINE_EXCEEDED;
            case GrpcStatus.NOT_FOUND -> NOT_FOUND;
            case GrpcStatus.ALREADY_EXISTS -> ALREADY_EXISTS;
            case GrpcStatus.PERMISSION_DENIED -> PERMISSION_DENIED;
            case GrpcStatus.RESOURCE_EXHAUSTED -> RESOURCE_EXHAUSTED;
            case GrpcStatus.FAILED_PRECONDITION -> FAILED_PRECONDITION;
            case GrpcStatus.ABORTED -> ABORTED;
            case GrpcStatus.OUT_OF_RANGE -> OUT_OF_RANGE;
            case GrpcStatus.UNIMPLEMENTED -> UNIMPLEMENTED;
            case GrpcStatus.INTERNAL -> INTERNAL;
            case GrpcStatus.UNAVAILABLE -> UNAVAILABLE;
            case GrpcStatus.DATA_LOSS -> DATA_LOSS;
            case GrpcStatus.UNAUTHENTICATED -> UNAUTHENTICATED;
        };
    }
}

