/*
 * Decompiled with CFR 0.152.
 */
package io.helidon.metadata.hson;

import io.helidon.metadata.hson.Hson;
import java.io.PrintWriter;
import java.math.BigDecimal;
import java.util.Objects;

final class HsonValues {
    private HsonValues() {
    }

    static final class BooleanValue
    implements Hson.Value<Boolean> {
        private final boolean value;

        BooleanValue(boolean value) {
            this.value = value;
        }

        public static BooleanValue create(boolean value) {
            return new BooleanValue(value);
        }

        @Override
        public void write(PrintWriter writer) {
            writer.write(String.valueOf(this.value));
        }

        @Override
        public Boolean value() {
            return this.value;
        }

        @Override
        public Hson.Type type() {
            return Hson.Type.BOOLEAN;
        }

        public boolean equals(Object o) {
            if (this == o) {
                return true;
            }
            if (!(o instanceof BooleanValue)) {
                return false;
            }
            BooleanValue that = (BooleanValue)o;
            return this.value == that.value;
        }

        public int hashCode() {
            return Objects.hashCode(this.value);
        }

        public String toString() {
            return String.valueOf(this.value);
        }
    }

    static final class NullValue
    implements Hson.Value<Void> {
        static final NullValue INSTANCE = new NullValue();

        private NullValue() {
        }

        @Override
        public void write(PrintWriter writer) {
            writer.write("null");
        }

        @Override
        public Void value() {
            return null;
        }

        @Override
        public Hson.Type type() {
            return Hson.Type.NULL;
        }
    }

    static final class NumberValue
    implements Hson.Value<BigDecimal> {
        private final BigDecimal value;

        NumberValue(BigDecimal value) {
            this.value = value;
        }

        public static NumberValue create(BigDecimal value) {
            return new NumberValue(value);
        }

        @Override
        public void write(PrintWriter writer) {
            writer.write(String.valueOf(this.value));
        }

        @Override
        public BigDecimal value() {
            return this.value;
        }

        @Override
        public Hson.Type type() {
            return Hson.Type.NUMBER;
        }

        public boolean equals(Object o) {
            if (this == o) {
                return true;
            }
            if (!(o instanceof NumberValue)) {
                return false;
            }
            NumberValue that = (NumberValue)o;
            return Objects.equals(this.value, that.value);
        }

        public int hashCode() {
            return Objects.hashCode(this.value);
        }

        public String toString() {
            return String.valueOf(this.value);
        }
    }

    static final class StringValue
    implements Hson.Value<String> {
        private final String value;

        StringValue(String value) {
            this.value = value;
        }

        public static StringValue create(String value) {
            return new StringValue(value);
        }

        @Override
        public void write(PrintWriter writer) {
            writer.write(this.quote(this.escape(this.value)));
        }

        @Override
        public String value() {
            return this.value;
        }

        @Override
        public Hson.Type type() {
            return Hson.Type.STRING;
        }

        public boolean equals(Object o) {
            if (this == o) {
                return true;
            }
            if (!(o instanceof StringValue)) {
                return false;
            }
            StringValue that = (StringValue)o;
            return Objects.equals(this.value, that.value);
        }

        public int hashCode() {
            return Objects.hashCode(this.value);
        }

        public String toString() {
            return this.quote(this.value);
        }

        private String quote(String value) {
            return "\"" + value + "\"";
        }

        private String escape(String string) {
            String result = string.replaceAll("\n", "\\\\n");
            result = result.replaceAll("\"", "\\\\\"");
            result = result.replaceAll("\t", "\\\\t");
            result = result.replaceAll("\r", "\\\\r");
            result = result.replaceAll("\\\\\\\\", "\\\\\\\\\\\\\\\\");
            result = result.replaceAll("\f", "\\\\f");
            return result;
        }
    }
}

