/*
 * Decompiled with CFR 0.152.
 */
package com.hedera.node.app.service.contract.impl.exec.scope;

import com.hedera.hapi.node.base.Key;
import com.hedera.node.app.service.contract.impl.exec.scope.VerificationStrategy;
import edu.umd.cs.findbugs.annotations.NonNull;
import java.util.Objects;

public class EitherOrVerificationStrategy
implements VerificationStrategy {
    private final VerificationStrategy firstStrategy;
    private final VerificationStrategy secondStrategy;

    public EitherOrVerificationStrategy(@NonNull VerificationStrategy firstStrategy, @NonNull VerificationStrategy secondStrategy) {
        this.firstStrategy = firstStrategy;
        this.secondStrategy = secondStrategy;
    }

    @Override
    public VerificationStrategy.Decision decideForPrimitive(@NonNull Key key) {
        Objects.requireNonNull(key);
        VerificationStrategy.Decision firstDecision = this.firstStrategy.decideForPrimitive(key);
        if (firstDecision == VerificationStrategy.Decision.VALID) {
            return VerificationStrategy.Decision.VALID;
        }
        VerificationStrategy.Decision secondDecision = this.secondStrategy.decideForPrimitive(key);
        if (secondDecision == VerificationStrategy.Decision.VALID) {
            return VerificationStrategy.Decision.VALID;
        }
        return secondDecision == VerificationStrategy.Decision.INVALID ? firstDecision : secondDecision;
    }
}

