/*
 * Decompiled with CFR 0.152.
 */
package io.helidon.http;

import io.helidon.common.GenericType;
import io.helidon.common.mapper.MapperException;
import io.helidon.common.mapper.MapperManager;
import io.helidon.common.mapper.Mappers;
import io.helidon.common.mapper.Value;
import io.helidon.http.DateTime;
import io.helidon.http.Header;
import io.helidon.http.HeaderName;
import io.helidon.http.HeaderNames;
import java.net.URLDecoder;
import java.net.URLEncoder;
import java.nio.charset.StandardCharsets;
import java.time.ZonedDateTime;
import java.util.LinkedHashMap;
import java.util.List;
import java.util.Map;
import java.util.Optional;
import java.util.OptionalLong;
import java.util.function.Function;
import java.util.regex.Matcher;
import java.util.regex.Pattern;

public class ContentDisposition
implements Header {
    private static final String NAME_PARAMETER = "name";
    private static final String FILENAME_PARAMETER = "filename";
    private static final String CREATION_DATE_PARAMETER = "creation-date";
    private static final String MODIFICATION_DATE_PARAMETER = "modification-date";
    private static final String READ_DATE_PARAMETER = "read-date";
    private static final String SIZE_PARAMETER = "size";
    private static final ContentDisposition EMPTY = ContentDisposition.builder().type("").build();
    private static final Pattern DISPOSITION_PART_PATTERN = Pattern.compile("^(.+?)=\"?(.+?)\"?$");
    private final String type;
    private final Map<String, String> parameters;
    private String value;

    private ContentDisposition(Builder builder) {
        this.type = builder.type;
        this.parameters = new LinkedHashMap<String, String>(builder.parameters);
    }

    public static Builder builder() {
        return new Builder();
    }

    public static ContentDisposition parse(String headerValue) {
        Builder builder = ContentDisposition.builder();
        String[] parts = headerValue.split("(?<=[^\\\\]);");
        if (parts.length > 0) {
            String type = parts[0];
            if (type.indexOf(61) > -1) {
                throw new IllegalArgumentException("No type defined");
            }
            builder.type(type.trim());
            for (int i = 1; i < parts.length; ++i) {
                String part = parts[i];
                Matcher matcher = DISPOSITION_PART_PATTERN.matcher(part.trim());
                if (!matcher.matches()) continue;
                String name = matcher.group(1);
                String value = matcher.group(2);
                value = value.replace("\\\\", "\\");
                value = value.replace("\\\"", "\"");
                value = value.replace("\\;", ";");
                builder.parameter(name, value);
            }
        }
        return builder.build();
    }

    public static ContentDisposition empty() {
        return EMPTY;
    }

    @Override
    public String name() {
        return HeaderNames.CONTENT_DISPOSITION.defaultCase();
    }

    @Override
    public HeaderName headerName() {
        return HeaderNames.CONTENT_DISPOSITION;
    }

    public String get() {
        if (this.value == null) {
            StringBuilder sb = new StringBuilder();
            sb.append(this.type);
            for (Map.Entry<String, String> param : this.parameters.entrySet()) {
                sb.append(";");
                sb.append(param.getKey());
                sb.append("=");
                if (SIZE_PARAMETER.equals(param.getKey())) {
                    sb.append(param.getValue());
                    continue;
                }
                sb.append("\"");
                sb.append(param.getValue());
                sb.append("\"");
            }
            this.value = sb.toString();
        }
        return this.value;
    }

    public <N> Value<N> as(Class<N> type) throws MapperException {
        return this.asString().as(type);
    }

    public <N> Value<N> as(GenericType<N> type) throws MapperException {
        return this.asString().as(type);
    }

    public <N> Value<N> as(Function<? super String, ? extends N> mapper) {
        return this.asString().as(mapper);
    }

    public Optional<String> asOptional() throws MapperException {
        return this.asString().asOptional();
    }

    public Value<Boolean> asBoolean() {
        return this.asString().asBoolean();
    }

    public Value<String> asString() {
        return Value.create((Mappers)MapperManager.global(), (String)this.name(), (Object)this.get(), (GenericType)GenericType.STRING, (String[])new String[]{"http", "header"});
    }

    public Value<Integer> asInt() {
        return this.asString().asInt();
    }

    public Value<Long> asLong() {
        return this.asString().asLong();
    }

    public Value<Double> asDouble() {
        return this.asString().asDouble();
    }

    @Override
    public List<String> allValues() {
        return List.of(this.get());
    }

    @Override
    public int valueCount() {
        return 1;
    }

    @Override
    public boolean sensitive() {
        return false;
    }

    @Override
    public boolean changing() {
        return true;
    }

    public String toString() {
        return this.get();
    }

    public Optional<String> contentName() {
        return Optional.ofNullable(this.parameters.get(NAME_PARAMETER));
    }

    public Optional<String> filename() {
        String filename = null;
        String value = this.parameters.get(FILENAME_PARAMETER);
        if (value != null) {
            filename = URLDecoder.decode(value, StandardCharsets.UTF_8);
        }
        return Optional.ofNullable(filename);
    }

    public Optional<ZonedDateTime> creationDate() {
        return Optional.ofNullable(this.parameters.get(CREATION_DATE_PARAMETER)).map(DateTime::parse);
    }

    public Optional<ZonedDateTime> modificationDate() {
        return Optional.ofNullable(this.parameters.get(MODIFICATION_DATE_PARAMETER)).map(DateTime::parse);
    }

    public Optional<ZonedDateTime> readDate() {
        return Optional.ofNullable(this.parameters.get(READ_DATE_PARAMETER)).map(DateTime::parse);
    }

    public OptionalLong size() {
        String size = this.parameters.get(SIZE_PARAMETER);
        if (size != null) {
            return OptionalLong.of(Long.parseLong(size));
        }
        return OptionalLong.empty();
    }

    public Map<String, String> parameters() {
        return Map.copyOf(this.parameters);
    }

    public String type() {
        return this.type;
    }

    public static final class Builder
    implements io.helidon.common.Builder<Builder, ContentDisposition> {
        public static final String TYPE_FORM_DATA = "form-data";
        private final Map<String, String> parameters = new LinkedHashMap<String, String>();
        private String type = "form-data";

        private Builder() {
        }

        public ContentDisposition build() {
            return new ContentDisposition(this);
        }

        public Builder type(String type) {
            this.type = type.toLowerCase();
            return this;
        }

        public Builder name(String name) {
            this.parameters.put(ContentDisposition.NAME_PARAMETER, name);
            return this;
        }

        public Builder filename(String filename) {
            this.parameters.put(ContentDisposition.FILENAME_PARAMETER, URLEncoder.encode(filename, StandardCharsets.UTF_8));
            return this;
        }

        public Builder creationDate(ZonedDateTime date) {
            this.parameters.put(ContentDisposition.CREATION_DATE_PARAMETER, date.format(DateTime.RFC_1123_DATE_TIME));
            return this;
        }

        public Builder modificationDate(ZonedDateTime date) {
            this.parameters.put(ContentDisposition.MODIFICATION_DATE_PARAMETER, date.format(DateTime.RFC_1123_DATE_TIME));
            return this;
        }

        public Builder readDate(ZonedDateTime date) {
            this.parameters.put(ContentDisposition.READ_DATE_PARAMETER, date.format(DateTime.RFC_1123_DATE_TIME));
            return this;
        }

        public Builder size(long size) {
            this.parameters.put(ContentDisposition.SIZE_PARAMETER, Long.toString(size));
            return this;
        }

        public Builder parameter(String name, String value) {
            this.parameters.put(name, value);
            return this;
        }
    }
}

