/*
 * Decompiled with CFR 0.152.
 */
package io.helidon.http.http2;

import io.helidon.http.http2.Http2ErrorCode;
import io.helidon.http.http2.Http2Exception;
import java.util.HashMap;
import java.util.Map;

public enum Http2FrameType {
    DATA(0, -1),
    HEADERS(1, -1),
    PRIORITY(2, 5),
    RST_STREAM(3, 4),
    SETTINGS(4, -1),
    PUSH_PROMISE(5, -1),
    PING(6, 8),
    GO_AWAY(7, -1),
    WINDOW_UPDATE(8, 4),
    CONTINUATION(9, -1),
    UNKNOWN(Short.MAX_VALUE, -1);

    private static final Map<Integer, Http2FrameType> BY_ID;
    private final int type;
    private final int exactLength;

    private Http2FrameType(int type, int exactLength) {
        this.type = type;
        this.exactLength = exactLength;
    }

    public static Http2FrameType byId(int id) {
        return BY_ID.getOrDefault(id, UNKNOWN);
    }

    public int type() {
        return this.type;
    }

    public void checkLength(int length) {
        if (this.exactLength == -1) {
            return;
        }
        if (this.exactLength != length) {
            throw new Http2Exception(Http2ErrorCode.FRAME_SIZE, this.name() + " frame size must be " + this.exactLength + ", but is " + length);
        }
    }

    static {
        Http2FrameType[] values = Http2FrameType.values();
        HashMap<Integer, Http2FrameType> map = new HashMap<Integer, Http2FrameType>(values.length);
        for (Http2FrameType value : values) {
            map.put(value.type(), value);
        }
        BY_ID = Map.copyOf(map);
    }
}

