/*
 * Decompiled with CFR 0.152.
 */
package io.helidon.http.http2;

import io.helidon.common.buffers.BufferData;
import io.helidon.http.http2.Http2HuffmanConstants;

public class Http2HuffmanEncoder {
    private static final int HUFFMAN_ENCODED = 128;

    private Http2HuffmanEncoder() {
    }

    public static Http2HuffmanEncoder create() {
        return new Http2HuffmanEncoder();
    }

    void encode(BufferData buffer, String string) {
        int index = 0;
        long current = 0L;
        int n = 0;
        byte[] bytes = new byte[string.length()];
        for (int i = 0; i < string.length(); ++i) {
            int b = string.charAt(i) & 0xFF;
            int code = Http2HuffmanConstants.HUFFMAN_CODES[b];
            byte nbits = Http2HuffmanConstants.HUFFMAN_CODE_LENGTHS[b];
            current <<= nbits;
            current |= (long)code;
            n += nbits;
            while (n >= 8) {
                bytes[index] = (byte)(current >> (n -= 8));
                ++index;
            }
        }
        if (n > 0) {
            current <<= 8 - n;
            bytes[index] = (byte)(current |= (long)(255 >>> n));
            ++index;
        }
        buffer.writeHpackInt(index, 128, 7);
        buffer.write(bytes, 0, index);
    }
}

