/*
 * Decompiled with CFR 0.152.
 */
package io.helidon.common.types;

import io.helidon.builder.api.Prototype;
import io.helidon.common.types.AccessModifier;
import io.helidon.common.types.ElementKind;
import io.helidon.common.types.Modifier;
import io.helidon.common.types.TypeInfo;
import io.helidon.common.types.TypeName;
import java.util.Locale;

final class TypeInfoSupport {
    private TypeInfoSupport() {
    }

    static final class TypeInfoDecorator
    implements Prototype.BuilderDecorator<TypeInfo.BuilderBase<?, ?>> {
        TypeInfoDecorator() {
        }

        public void decorate(TypeInfo.BuilderBase<?, ?> target) {
            if (target.kind().isEmpty() && target.typeKind().isPresent()) {
                target.kind(ElementKind.valueOf(target.typeKind().get().toUpperCase(Locale.ROOT)));
            }
            target.typeKind(target.kind().get().toString());
            if (target.accessModifier().isEmpty()) {
                AccessModifier accessModifier = null;
                for (String modifier : target.modifiers()) {
                    if ("public".equals(modifier)) {
                        accessModifier = AccessModifier.PUBLIC;
                        break;
                    }
                    if ("protected".equals(modifier)) {
                        accessModifier = AccessModifier.PROTECTED;
                        break;
                    }
                    if (!"private".equals(modifier)) continue;
                    accessModifier = AccessModifier.PRIVATE;
                    break;
                }
                if (accessModifier == null) {
                    accessModifier = AccessModifier.PACKAGE_PRIVATE;
                }
                target.accessModifier(accessModifier);
            }
            for (String modifier : target.modifiers()) {
                try {
                    target.addElementModifier(Modifier.valueOf(modifier.toUpperCase(Locale.ROOT)));
                }
                catch (IllegalArgumentException illegalArgumentException) {}
            }
            for (Modifier typeModifier : target.elementModifiers()) {
                target.addModifier(typeModifier.modifierName());
            }
            target.addModifier(target.accessModifier().get().modifierName());
            if (target.rawType().isEmpty()) {
                target.typeName().map(TypeName::genericTypeName).ifPresent(target::rawType);
            }
            if (target.declaredType().isEmpty()) {
                target.rawType().ifPresent(target::declaredType);
            }
        }
    }
}

