/*
 * Decompiled with CFR 0.152.
 */
package com.hedera.node.app;

import com.google.common.annotations.VisibleForTesting;
import com.hedera.hapi.node.base.AccountID;
import com.hedera.hapi.node.base.SemanticVersion;
import com.hedera.node.app.Hedera;
import com.hedera.node.app.hints.impl.HintsLibraryImpl;
import com.hedera.node.app.hints.impl.HintsServiceImpl;
import com.hedera.node.app.history.impl.HistoryLibraryImpl;
import com.hedera.node.app.history.impl.HistoryServiceImpl;
import com.hedera.node.app.info.DiskStartupNetworks;
import com.hedera.node.app.service.addressbook.impl.ReadableNodeStoreImpl;
import com.hedera.node.app.service.entityid.ReadableEntityCounters;
import com.hedera.node.app.service.entityid.impl.ReadableEntityIdStoreImpl;
import com.hedera.node.app.services.OrderedServiceMigrator;
import com.hedera.node.app.services.ServicesRegistryImpl;
import com.hedera.node.app.tss.TssBlockHashSigner;
import com.hedera.node.config.data.BlockStreamConfig;
import com.hedera.node.internal.network.Network;
import com.hedera.node.internal.network.NodeMetadata;
import com.swirlds.base.time.Time;
import com.swirlds.common.context.PlatformContext;
import com.swirlds.common.io.filesystem.FileSystemManager;
import com.swirlds.common.io.utility.FileUtils;
import com.swirlds.common.io.utility.RecycleBin;
import com.swirlds.common.merkle.crypto.MerkleCryptography;
import com.swirlds.common.merkle.crypto.MerkleCryptographyFactory;
import com.swirlds.config.api.Configuration;
import com.swirlds.config.api.ConfigurationBuilder;
import com.swirlds.config.api.source.ConfigSource;
import com.swirlds.config.extensions.sources.SystemEnvironmentConfigSource;
import com.swirlds.config.extensions.sources.SystemPropertiesConfigSource;
import com.swirlds.logging.legacy.LogMarker;
import com.swirlds.metrics.api.Metrics;
import com.swirlds.platform.CommandLineArgs;
import com.swirlds.platform.builder.ExecutionLayer;
import com.swirlds.platform.builder.PlatformBuilder;
import com.swirlds.platform.builder.internal.StaticPlatformBuilder;
import com.swirlds.platform.config.BasicConfig;
import com.swirlds.platform.config.internal.PlatformConfigUtils;
import com.swirlds.platform.config.legacy.ConfigurationException;
import com.swirlds.platform.crypto.CryptoStatic;
import com.swirlds.platform.state.ConsensusStateEventHandler;
import com.swirlds.platform.state.signed.HashedReservedSignedState;
import com.swirlds.platform.state.signed.ReservedSignedState;
import com.swirlds.platform.state.signed.StartupStateUtils;
import com.swirlds.platform.system.InitTrigger;
import com.swirlds.platform.system.Platform;
import com.swirlds.platform.system.SystemExitCode;
import com.swirlds.platform.system.SystemExitUtils;
import com.swirlds.platform.util.BootstrapUtils;
import com.swirlds.state.MerkleNodeState;
import com.swirlds.state.State;
import com.swirlds.state.StateLifecycleManager;
import com.swirlds.state.merkle.VirtualMapState;
import edu.umd.cs.findbugs.annotations.NonNull;
import java.nio.file.Path;
import java.time.InstantSource;
import java.util.List;
import java.util.Objects;
import java.util.Set;
import java.util.concurrent.ForkJoinPool;
import java.util.concurrent.atomic.AtomicBoolean;
import java.util.function.Consumer;
import java.util.function.Predicate;
import java.util.function.Supplier;
import org.apache.logging.log4j.LogManager;
import org.apache.logging.log4j.Logger;
import org.hiero.base.constructable.ConstructableRegistry;
import org.hiero.consensus.concurrent.manager.AdHocThreadManager;
import org.hiero.consensus.concurrent.manager.ThreadManager;
import org.hiero.consensus.model.node.KeysAndCerts;
import org.hiero.consensus.model.node.NodeId;
import org.hiero.consensus.roster.RosterHistory;
import org.hiero.consensus.roster.RosterStateUtils;

public class ServicesMain {
    private static final Logger logger = LogManager.getLogger(ServicesMain.class);
    private static final Supplier<Set<NodeId>> ILLEGAL_FALLBACK_NODE_IDS = () -> {
        throw new IllegalStateException("The node id must be configured explicitly");
    };
    private static final Predicate<NodeId> NOOP_NODE_VALIDATOR = nodeId -> true;
    private static Hedera hedera;
    private static Metrics metrics;

    public static void main(String ... args) throws Exception {
        StaticPlatformBuilder.initLogging();
        BootstrapUtils.setupConstructableRegistry();
        CommandLineArgs commandLineArgs = CommandLineArgs.parse((String[])args);
        if (commandLineArgs.localNodesToStart().size() > 1) {
            logger.error(LogMarker.EXCEPTION.getMarker(), "Multiple nodes were supplied via the command line. Only one node can be started per java process.");
            SystemExitUtils.exitSystem((SystemExitCode)SystemExitCode.NODE_ADDRESS_MISMATCH);
            throw new ConfigurationException();
        }
        Configuration platformConfig = ServicesMain.buildPlatformConfig();
        MerkleCryptography merkleCryptography = MerkleCryptographyFactory.create((Configuration)platformConfig);
        Set cliNodesToRun = commandLineArgs.localNodesToStart();
        List configNodesToRun = ((BasicConfig)platformConfig.getConfigData(BasicConfig.class)).nodesToRun();
        List nodesToRun = BootstrapUtils.getNodesToRun((Set)cliNodesToRun, (List)configNodesToRun, ILLEGAL_FALLBACK_NODE_IDS, NOOP_NODE_VALIDATOR);
        NodeId selfId = ServicesMain.ensureSingleNode(nodesToRun);
        StaticPlatformBuilder.setupGlobalMetrics((Configuration)platformConfig);
        Time time = Time.getCurrent();
        metrics = StaticPlatformBuilder.getMetricsProvider().createPlatformMetrics(selfId);
        hedera = ServicesMain.newHedera(platformConfig, metrics, time);
        SemanticVersion version = hedera.getSemanticVersion();
        AtomicBoolean genesisNetwork = new AtomicBoolean(false);
        logger.info("Starting node {} with version {}", (Object)selfId, (Object)version);
        BootstrapUtils.setupConstructableRegistryWithConfiguration((Configuration)platformConfig);
        FileSystemManager fileSystemManager = FileSystemManager.create((Configuration)platformConfig);
        RecycleBin recycleBin = RecycleBin.create((Metrics)metrics, (Configuration)platformConfig, (ThreadManager)AdHocThreadManager.getStaticThreadManager(), (Time)time, (FileSystemManager)fileSystemManager, (NodeId)selfId);
        ConsensusStateEventHandler<MerkleNodeState> consensusStateEventHandler = hedera.newConsensusStateEvenHandler();
        PlatformContext platformContext = PlatformContext.create((Configuration)platformConfig, (Time)Time.getCurrent(), (Metrics)metrics, (FileSystemManager)fileSystemManager, (RecycleBin)recycleBin, (MerkleCryptography)merkleCryptography);
        HashedReservedSignedState reservedState = StartupStateUtils.loadInitialState((RecycleBin)recycleBin, (SemanticVersion)version, () -> {
            genesisNetwork.set(true);
            MerkleNodeState genesisState = hedera.newStateRoot();
            hedera.initializeStatesApi(genesisState, InitTrigger.GENESIS, platformConfig);
            return genesisState;
        }, (String)"com.hedera.services.ServicesMain", (String)"123", (NodeId)selfId, (PlatformContext)platformContext, (StateLifecycleManager)hedera.getStateLifecycleManager());
        ReservedSignedState initialState = reservedState.state();
        MerkleNodeState state = initialState.get().getState();
        if (!genesisNetwork.get()) {
            hedera.initializeStatesApi(state, InitTrigger.RESTART, platformConfig);
        }
        hedera.setInitialStateHash(reservedState.hash());
        RosterHistory rosterHistory = RosterStateUtils.createRosterHistory((State)state);
        KeysAndCerts keysAndCerts = CryptoStatic.initNodeSecurity((Configuration)platformConfig, (NodeId)selfId);
        String consensusEventStreamName = genesisNetwork.get() ? ServicesMain.eventStreamLocOrThrow(hedera.startupNetworks().genesisNetworkOrThrow(platformConfig), selfId.id()) : ServicesMain.canonicalEventStreamLoc(selfId.id(), (State)state);
        PlatformBuilder platformBuilder = PlatformBuilder.create((String)"com.hedera.services.ServicesMain", (String)"123", (SemanticVersion)version, (ReservedSignedState)initialState, consensusStateEventHandler, (NodeId)selfId, (String)consensusEventStreamName, (RosterHistory)rosterHistory, (StateLifecycleManager)hedera.getStateLifecycleManager()).withPlatformContext(platformContext).withConfiguration(platformConfig).withKeysAndCerts(keysAndCerts).withExecutionLayer((ExecutionLayer)hedera).withStaleEventCallback((Consumer)hedera);
        Platform platform = platformBuilder.build();
        hedera.init(platform, selfId);
        platform.start();
        hedera.run();
    }

    private static String eventStreamLocOrThrow(@NonNull Network network, long nodeId) {
        return network.nodeMetadata().stream().map(NodeMetadata::nodeOrThrow).filter(node -> node.nodeId() == nodeId).map(node -> ServicesMain.canonicalEventStreamLoc(node.accountIdOrThrow())).findFirst().orElseThrow();
    }

    private static String canonicalEventStreamLoc(long nodeId, @NonNull State root) {
        try {
            ReadableNodeStoreImpl nodeStore = new ReadableNodeStoreImpl(root.getReadableStates("AddressBookService"), (ReadableEntityCounters)new ReadableEntityIdStoreImpl(root.getReadableStates("EntityIdService")));
            AccountID accountId = Objects.requireNonNull(nodeStore.get(nodeId)).accountIdOrThrow();
            return ServicesMain.canonicalEventStreamLoc(accountId);
        }
        catch (Exception ignore) {
            Network genesisNetwork = ServicesMain.hederaOrThrow().genesisNetworkSupplierOrThrow().get();
            return ServicesMain.eventStreamLocOrThrow(genesisNetwork, nodeId);
        }
    }

    private static String canonicalEventStreamLoc(@NonNull AccountID accountId) {
        Objects.requireNonNull(accountId);
        return accountId.shardNum() + "." + accountId.realmNum() + "." + accountId.accountNumOrThrow();
    }

    public static Hedera newHedera(@NonNull Configuration configuration, @NonNull Metrics metrics, @NonNull Time time) {
        Objects.requireNonNull(configuration);
        Objects.requireNonNull(metrics);
        Objects.requireNonNull(time);
        return new Hedera(ConstructableRegistry.getInstance(), ServicesRegistryImpl::new, new OrderedServiceMigrator(), InstantSource.system(), DiskStartupNetworks::new, (appContext, bootstrapConfig) -> new HintsServiceImpl(metrics, ForkJoinPool.commonPool(), appContext, new HintsLibraryImpl(), ((BlockStreamConfig)bootstrapConfig.getConfigData(BlockStreamConfig.class)).blockPeriod()), (appContext, bootstrapConfig) -> new HistoryServiceImpl(metrics, ForkJoinPool.commonPool(), appContext, new HistoryLibraryImpl(), bootstrapConfig), TssBlockHashSigner::new, configuration, metrics, time, () -> new VirtualMapState(configuration, metrics));
    }

    @NonNull
    public static Configuration buildPlatformConfig() {
        ConfigurationBuilder configurationBuilder = ConfigurationBuilder.create().withSource((ConfigSource)SystemEnvironmentConfigSource.getInstance()).withSource((ConfigSource)SystemPropertiesConfigSource.getInstance());
        FileUtils.rethrowIO(() -> BootstrapUtils.setupConfigBuilder((ConfigurationBuilder)configurationBuilder, (Path)FileUtils.getAbsolutePath((String)"settings.txt"), (Path)FileUtils.getAbsolutePath((String)"data/config/node-overrides.yaml")));
        Configuration configuration = configurationBuilder.build();
        PlatformConfigUtils.checkConfiguration((Configuration)configuration);
        return configuration;
    }

    private static NodeId ensureSingleNode(@NonNull List<NodeId> nodesToRun) {
        Objects.requireNonNull(nodesToRun);
        logger.info(LogMarker.STARTUP.getMarker(), "The following nodes {} are set to run locally", nodesToRun);
        if (nodesToRun.isEmpty()) {
            String errorMessage = "No nodes are configured to run locally.";
            logger.error(LogMarker.STARTUP.getMarker(), "No nodes are configured to run locally.");
            SystemExitUtils.exitSystem((SystemExitCode)SystemExitCode.NODE_ADDRESS_MISMATCH, (String)"No nodes are configured to run locally.");
            throw new ConfigurationException("No nodes are configured to run locally.");
        }
        if (nodesToRun.size() > 1) {
            String errorMessage = "Multiple nodes are configured to run locally.";
            logger.error(LogMarker.EXCEPTION.getMarker(), "Multiple nodes are configured to run locally.");
            SystemExitUtils.exitSystem((SystemExitCode)SystemExitCode.NODE_ADDRESS_MISMATCH, (String)"Multiple nodes are configured to run locally.");
            throw new ConfigurationException("Multiple nodes are configured to run locally.");
        }
        return nodesToRun.getFirst();
    }

    @NonNull
    private static Hedera hederaOrThrow() {
        return Objects.requireNonNull(hedera);
    }

    @VisibleForTesting
    static void initGlobal(@NonNull Hedera hedera, @NonNull Metrics metrics) {
        ServicesMain.hedera = hedera;
        ServicesMain.metrics = metrics;
    }
}

