/*
 * Decompiled with CFR 0.152.
 */
package com.hedera.node.app.config;

import com.hedera.node.config.ConfigProvider;
import com.swirlds.base.utility.FileSystemUtils;
import com.swirlds.config.api.ConfigurationBuilder;
import com.swirlds.config.api.source.ConfigSource;
import com.swirlds.config.extensions.sources.PropertyFileConfigSource;
import edu.umd.cs.findbugs.annotations.NonNull;
import java.io.FileNotFoundException;
import java.io.IOException;
import java.nio.file.Path;
import java.util.Objects;
import java.util.Optional;
import java.util.function.ObjIntConsumer;
import org.apache.logging.log4j.LogManager;
import org.apache.logging.log4j.Logger;

public abstract class ConfigProviderBase
implements ConfigProvider {
    public static final String GENESIS_PROPERTIES_PATH_ENV = "HEDERA_GENESIS_PROPERTIES_PATH";
    public static final String APPLICATION_PROPERTIES_PATH_ENV = "HEDERA_APP_PROPERTIES_PATH";
    public static final String GENESIS_PROPERTIES_DEFAULT_PATH = "data/config/genesis.properties";
    public static final String APPLICATION_PROPERTIES_DEFAULT_PATH = "data/config/application.properties";
    private static final Logger logger = LogManager.getLogger(ConfigProviderBase.class);
    protected static final String SEMANTIC_VERSION_PROPERTIES_DEFAULT_PATH = "semantic-version.properties";

    protected void addFileSource(@NonNull ConfigurationBuilder builder, @NonNull String envName, @NonNull String defaultPath, int priority) {
        Objects.requireNonNull(builder);
        Objects.requireNonNull(envName);
        Objects.requireNonNull(defaultPath);
        ObjIntConsumer<Path> addSource = (path, p) -> {
            if (path.toFile().exists()) {
                if (path.toFile().isDirectory()) throw new IllegalArgumentException("File " + String.valueOf(path) + " is a directory and not a property file");
                try {
                    if (!FileSystemUtils.waitForPathPresence((Path)path)) {
                        throw new FileNotFoundException("File not found: " + String.valueOf(path));
                    }
                    builder.withSource((ConfigSource)new PropertyFileConfigSource(path, p));
                    return;
                }
                catch (IOException e) {
                    throw new IllegalStateException("Can not create config source for property file", e);
                }
            } else {
                logger.info("Properties file {} does not exist and won't be used as configuration source", path);
            }
        };
        try {
            Path propertiesPath = Optional.ofNullable(System.getenv(envName)).or(() -> Optional.ofNullable(System.getProperty(envName.toLowerCase().replace("_", ".")))).map(x$0 -> Path.of(x$0, new String[0])).orElseGet(() -> Path.of(defaultPath, new String[0]));
            addSource.accept(propertiesPath, priority);
        }
        catch (Exception e) {
            throw new IllegalStateException("Can not create config source for application properties", e);
        }
    }
}

