/*
 * Decompiled with CFR 0.152.
 */
package com.hedera.node.app.workflows.handle.dispatch;

import com.hedera.hapi.node.base.AccountID;
import com.hedera.hapi.node.base.ResponseCodeEnum;
import com.hedera.hapi.node.state.token.Account;
import com.hedera.hapi.util.HapiUtils;
import com.hedera.node.app.fees.AppFeeCharging;
import com.hedera.node.app.service.token.ReadableAccountStore;
import com.hedera.node.app.spi.fees.FeeCharging;
import com.hedera.node.app.spi.signatures.SignatureVerification;
import com.hedera.node.app.spi.workflows.HandleContext;
import com.hedera.node.app.spi.workflows.PreCheckException;
import com.hedera.node.app.state.HederaRecordCache;
import com.hedera.node.app.store.ReadableStoreFactory;
import com.hedera.node.app.workflows.TransactionChecker;
import com.hedera.node.app.workflows.handle.Dispatch;
import com.hedera.node.app.workflows.handle.dispatch.ValidationResult;
import com.hedera.node.app.workflows.prehandle.PreHandleResult;
import edu.umd.cs.findbugs.annotations.NonNull;
import edu.umd.cs.findbugs.annotations.Nullable;
import java.util.Objects;
import java.util.concurrent.atomic.AtomicBoolean;
import javax.inject.Inject;
import javax.inject.Singleton;

@Singleton
public class DispatchValidator {
    private final HederaRecordCache recordCache;
    private final TransactionChecker transactionChecker;
    private final AppFeeCharging feeCharging;
    @Nullable
    private final AtomicBoolean systemEntitiesCreatedFlag;

    @Inject
    public DispatchValidator(@NonNull HederaRecordCache recordCache, @NonNull TransactionChecker transactionChecker, @NonNull AppFeeCharging feeCharging, @Nullable AtomicBoolean systemEntitiesCreatedFlag) {
        this.recordCache = Objects.requireNonNull(recordCache);
        this.transactionChecker = Objects.requireNonNull(transactionChecker);
        this.feeCharging = Objects.requireNonNull(feeCharging);
        this.systemEntitiesCreatedFlag = systemEntitiesCreatedFlag;
    }

    public FeeCharging.Validation validateFeeChargingScenario(@NonNull Dispatch dispatch) {
        SignatureVerification verification;
        boolean requiresPayerSig;
        if (this.systemEntitiesCreatedFlag != null && !this.systemEntitiesCreatedFlag.get()) {
            return ValidationResult.newGenesisWaiver(dispatch.creatorInfo().accountId());
        }
        ResponseCodeEnum creatorError = this.creatorErrorIfKnown(dispatch);
        if (creatorError != null) {
            return ValidationResult.newCreatorError(dispatch.creatorInfo().accountId(), creatorError);
        }
        Account payer = this.getPayerAccount(dispatch.readableStoreFactory(), dispatch.payerId(), dispatch.txnCategory());
        HandleContext.TransactionCategory category = dispatch.txnCategory();
        boolean bl = requiresPayerSig = category == HandleContext.TransactionCategory.SCHEDULED || category == HandleContext.TransactionCategory.USER || category == HandleContext.TransactionCategory.BATCH_INNER;
        if (requiresPayerSig && !HapiUtils.isHollow((Account)payer) && (verification = dispatch.keyVerifier().verificationFor(payer.keyOrThrow())).failed()) {
            return ValidationResult.newCreatorError(dispatch.creatorInfo().accountId(), ResponseCodeEnum.INVALID_PAYER_SIGNATURE);
        }
        HederaRecordCache.DuplicateCheckResult duplicateCheckResult = category != HandleContext.TransactionCategory.USER && category != HandleContext.TransactionCategory.NODE && category != HandleContext.TransactionCategory.BATCH_INNER ? HederaRecordCache.DuplicateCheckResult.NO_DUPLICATE : this.recordCache.hasDuplicate(dispatch.txnInfo().txBody().transactionIDOrThrow(), dispatch.creatorInfo().nodeId());
        return switch (duplicateCheckResult) {
            default -> throw new MatchException(null, null);
            case HederaRecordCache.DuplicateCheckResult.NO_DUPLICATE -> this.getFinalPayerValidation(payer, DuplicateStatus.NO_DUPLICATE, dispatch);
            case HederaRecordCache.DuplicateCheckResult.SAME_NODE -> ValidationResult.newCreatorError(dispatch.creatorInfo().accountId(), ResponseCodeEnum.DUPLICATE_TRANSACTION);
            case HederaRecordCache.DuplicateCheckResult.OTHER_NODE -> this.getFinalPayerValidation(payer, DuplicateStatus.DUPLICATE, dispatch);
        };
    }

    @NonNull
    private FeeCharging.Validation getFinalPayerValidation(@NonNull Account payer, @NonNull DuplicateStatus duplicateStatus, @NonNull Dispatch dispatch) {
        AccountID creatorId = dispatch.creatorInfo().accountId();
        boolean isDuplicate = duplicateStatus == DuplicateStatus.DUPLICATE;
        FeeCharging.Validation validation = dispatch.feeChargingOrElse(this.feeCharging).validate(payer, creatorId, dispatch.fees(), dispatch.txnInfo().txBody(), isDuplicate, dispatch.txnInfo().functionality(), dispatch.txnCategory());
        if (validation.maybeErrorStatus() != null) {
            return validation;
        }
        return switch (duplicateStatus.ordinal()) {
            default -> throw new MatchException(null, null);
            case 0 -> ValidationResult.newPayerDuplicateError(creatorId, payer);
            case 1 -> dispatch.preHandleResult().status() == PreHandleResult.Status.SO_FAR_SO_GOOD ? validation : ValidationResult.newPayerUniqueError(creatorId, payer, dispatch.preHandleResult().responseCode());
        };
    }

    @Nullable
    private ResponseCodeEnum creatorErrorIfKnown(@NonNull Dispatch dispatch) {
        PreHandleResult preHandleResult = dispatch.preHandleResult();
        return switch (preHandleResult.status()) {
            default -> throw new MatchException(null, null);
            case PreHandleResult.Status.NODE_DUE_DILIGENCE_FAILURE -> preHandleResult.responseCode();
            case PreHandleResult.Status.SO_FAR_SO_GOOD -> this.getExpiryError(dispatch);
            case PreHandleResult.Status.UNKNOWN_FAILURE, PreHandleResult.Status.PAYER_UNWILLING_OR_UNABLE_TO_PAY_SERVICE_FEE, PreHandleResult.Status.PRE_HANDLE_FAILURE -> null;
        };
    }

    @Nullable
    private ResponseCodeEnum getExpiryError(@NonNull Dispatch dispatch) {
        if (dispatch.txnCategory() != HandleContext.TransactionCategory.USER && dispatch.txnCategory() != HandleContext.TransactionCategory.NODE && dispatch.txnCategory() != HandleContext.TransactionCategory.BATCH_INNER) {
            return null;
        }
        try {
            this.transactionChecker.checkTimeBox(dispatch.txnInfo().txBody(), dispatch.consensusNow(), TransactionChecker.RequireMinValidLifetimeBuffer.NO);
        }
        catch (PreCheckException e) {
            return e.responseCode();
        }
        return null;
    }

    private Account getPayerAccount(@NonNull ReadableStoreFactory storeFactory, @NonNull AccountID accountID, @NonNull HandleContext.TransactionCategory category) {
        ReadableAccountStore accountStore = storeFactory.getStore(ReadableAccountStore.class);
        Account account = accountStore.getAccountById(accountID);
        return switch (category) {
            default -> throw new MatchException(null, null);
            case HandleContext.TransactionCategory.USER, HandleContext.TransactionCategory.NODE, HandleContext.TransactionCategory.BATCH_INNER -> {
                if (account == null) {
                    throw new IllegalStateException(String.format("Category %s payer account with id %s does not exists", category, accountID));
                }
                if (account.deleted()) {
                    throw new IllegalStateException(String.format("Category %s payer account with id %s is deleted", category, accountID));
                }
                if (account.smartContract()) {
                    throw new IllegalStateException(String.format("Category %s payer account with id %s is a smart contract", category, accountID));
                }
                yield account;
            }
            case HandleContext.TransactionCategory.CHILD, HandleContext.TransactionCategory.PRECEDING, HandleContext.TransactionCategory.SCHEDULED -> {
                if (account == null) {
                    throw new IllegalStateException("Category " + String.valueOf(category) + " payer account should have been rejected " + String.valueOf(account));
                }
                yield account;
            }
        };
    }

    public static enum DuplicateStatus {
        DUPLICATE,
        NO_DUPLICATE;

    }

    public static enum WorkflowCheck {
        INGEST,
        NOT_INGEST;

    }

    public static enum ServiceFeeStatus {
        CAN_PAY_SERVICE_FEE,
        UNABLE_TO_PAY_SERVICE_FEE;

    }

    public static enum OfferedFeeCheck {
        CHECK_OFFERED_FEE,
        SKIP_OFFERED_FEE_CHECK;

    }
}

