/*
 * Decompiled with CFR 0.152.
 */
package com.hedera.node.app.workflows.query;

import com.hedera.hapi.node.base.AccountID;
import com.hedera.hapi.node.transaction.Query;
import com.hedera.node.app.fees.ExchangeRateManager;
import com.hedera.node.app.records.impl.BlockRecordInfoImpl;
import com.hedera.node.app.spi.fees.ExchangeRateInfo;
import com.hedera.node.app.spi.fees.FeeCalculator;
import com.hedera.node.app.spi.records.BlockRecordInfo;
import com.hedera.node.app.spi.records.RecordCache;
import com.hedera.node.app.spi.workflows.QueryContext;
import com.hedera.node.app.store.ReadableStoreFactory;
import com.swirlds.config.api.Configuration;
import com.swirlds.state.State;
import edu.umd.cs.findbugs.annotations.NonNull;
import edu.umd.cs.findbugs.annotations.Nullable;
import java.util.Objects;

public class QueryContextImpl
implements QueryContext {
    private final ReadableStoreFactory storeFactory;
    private final Query query;
    private final Configuration configuration;
    private final RecordCache recordCache;
    private final State state;
    private final ExchangeRateManager exchangeRateManager;
    private final AccountID payer;
    private final FeeCalculator feeCalculator;
    private BlockRecordInfo blockRecordInfo;
    private ExchangeRateInfo exchangeRateInfo;

    public QueryContextImpl(@NonNull State state, @NonNull ReadableStoreFactory storeFactory, @NonNull Query query, @NonNull Configuration configuration, @NonNull RecordCache recordCache, @NonNull ExchangeRateManager exchangeRateManager, @NonNull FeeCalculator feeCalculator, @Nullable AccountID payer) {
        this.state = Objects.requireNonNull(state, "state must not be null");
        this.storeFactory = Objects.requireNonNull(storeFactory, "storeFactory must not be null");
        this.query = Objects.requireNonNull(query, "query must not be null");
        this.configuration = Objects.requireNonNull(configuration, "configuration must not be null");
        this.recordCache = Objects.requireNonNull(recordCache, "recordCache must not be null");
        this.exchangeRateManager = Objects.requireNonNull(exchangeRateManager, "exchangeRateManager must not be null");
        this.feeCalculator = Objects.requireNonNull(feeCalculator, "feeCalculator must not be null");
        this.payer = payer;
    }

    @NonNull
    public Query query() {
        return this.query;
    }

    @Nullable
    public AccountID payer() {
        return this.payer;
    }

    @NonNull
    public <C> C createStore(@NonNull Class<C> storeInterface) {
        return this.storeFactory.getStore(storeInterface);
    }

    @NonNull
    public Configuration configuration() {
        return this.configuration;
    }

    @NonNull
    public RecordCache recordCache() {
        return this.recordCache;
    }

    @NonNull
    public BlockRecordInfo blockRecordInfo() {
        if (this.blockRecordInfo == null) {
            this.blockRecordInfo = BlockRecordInfoImpl.from(this.state);
        }
        return this.blockRecordInfo;
    }

    @NonNull
    public ExchangeRateInfo exchangeRateInfo() {
        if (this.exchangeRateInfo == null) {
            this.exchangeRateInfo = this.exchangeRateManager.exchangeRateInfo(this.state);
        }
        return this.exchangeRateInfo;
    }

    @NonNull
    public FeeCalculator feeCalculator() {
        return this.feeCalculator;
    }
}

